/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jwk.KeyType;
import org.apache.cxf.rs.security.jose.jwk.PublicKeyUse;

public class JoseParsers {
    public static JsonWebKey parseJwkSigningKey(String jwkJsonString) throws ConfigValidationException {
        JsonWebKey result = JwkUtils.readJwkKey((String)jwkJsonString);
        PublicKeyUse publicKeyUse = result.getPublicKeyUse();
        if (publicKeyUse != null && publicKeyUse != PublicKeyUse.SIGN) {
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("use", (Object)publicKeyUse, (Object)"The use claim must designate the JWK for signing"));
        }
        return result;
    }

    public static JsonWebKey parseJwkHs512SigningKey(String value) throws ConfigValidationException {
        byte[] key;
        try {
            key = JoseUtils.decode((String)value);
        }
        catch (Exception e) {
            throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)e.getMessage(), (Object)"A Base64URL encoded HMAC512 key with at least 512 bit (64 bytes, 86 Base64 encoded characters)").cause((Throwable)e));
        }
        if (key.length < 64) {
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)"The key contains less than 512 bit", (Object)"A Base64URL encoded HMAC512 key with at least 512 bit (64 bytes, 86 Base64 encoded characters)"));
        }
        JsonWebKey jwk = new JsonWebKey();
        jwk.setKeyType(KeyType.OCTET);
        jwk.setAlgorithm("HS512");
        jwk.setPublicKeyUse(PublicKeyUse.SIGN);
        jwk.setProperty("k", (Object)value);
        return jwk;
    }

    public static JsonWebKey parseJwkEcryptionKey(String jwkJsonString) throws ConfigValidationException {
        JsonWebKey result = JwkUtils.readJwkKey((String)jwkJsonString);
        PublicKeyUse publicKeyUse = result.getPublicKeyUse();
        if (publicKeyUse != null && publicKeyUse != PublicKeyUse.ENCRYPT) {
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("use", (Object)publicKeyUse, (Object)"The use claim must designate the JWK for encryption"));
        }
        return result;
    }

    public static JsonWebKey parseJwkA256kwEncryptionKey(String value) throws ConfigValidationException {
        byte[] key;
        try {
            key = JoseUtils.decode((String)value);
        }
        catch (Exception e) {
            throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)e.getMessage(), (Object)"A Base64URL encoded A256KW key with at least 256 bit (32 bytes, 43 Base64 encoded characters)").cause((Throwable)e));
        }
        if (key.length < 32) {
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)"The key contains less than 256 bit", (Object)"A Base64URL encoded A256KW key with at least 256 bit (32 bytes, 43 Base64 encoded characters)"));
        }
        JsonWebKey jwk = new JsonWebKey();
        jwk.setKeyType(KeyType.OCTET);
        jwk.setAlgorithm("A256KW");
        jwk.setPublicKeyUse(PublicKeyUse.ENCRYPT);
        jwk.setProperty("k", (Object)value);
        return jwk;
    }
}

