/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.variables;

import com.floragunn.searchguard.configuration.variables.ConfigVarService;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public class ConfigVarRefreshAction
extends ActionType<Response> {
    private static final Logger log = LogManager.getLogger(ConfigVarRefreshAction.class);
    public static final ConfigVarRefreshAction INSTANCE = new ConfigVarRefreshAction();
    public static final String NAME = "cluster:admin:searchguard:config_vars/refresh";

    protected ConfigVarRefreshAction() {
        super(NAME);
    }

    public static void send(Client client) {
        log.trace("Sending ConfigVarRefreshAction.Request");
        client.execute((ActionType)INSTANCE, (ActionRequest)new Request(), (ActionListener)new ActionListener<Response>(){

            public void onResponse(Response response) {
                log.debug("Result of settings update:\n" + String.valueOf((Object)response));
            }

            public void onFailure(Exception e) {
                log.error("settings update failed", (Throwable)e);
            }
        });
    }

    public static void send(Client client, ActionListener<Response> actionListener) {
        log.trace("Sending SecretsRefreshAction.Request");
        client.execute((ActionType)INSTANCE, (ActionRequest)new Request(), actionListener);
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        public Request() {
            super((String[])null);
        }
    }

    public static class TransportAction
    extends TransportNodesAction<Request, Response, NodeRequest, NodeResponse, Void> {
        private final ConfigVarService configVarService;

        @Inject
        public TransportAction(ConfigVarService configVarService, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
            super(ConfigVarRefreshAction.NAME, clusterService, transportService, actionFilters, NodeRequest::new, (Executor)threadPool.executor("management"));
            this.configVarService = configVarService;
        }

        protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
            return new NodeResponse(in);
        }

        protected Response newResponse(Request request, List<NodeResponse> responses, List<FailedNodeException> failures) {
            return new Response(this.clusterService.getClusterName(), responses, failures);
        }

        protected NodeResponse nodeOperation(NodeRequest request, Task task) {
            DiscoveryNode localNode = this.clusterService.localNode();
            try {
                this.configVarService.refresh();
                return new NodeResponse(localNode, NodeResponse.Status.SUCCESS, "");
            }
            catch (Exception e) {
                log.error("Error while updating settings", (Throwable)e);
                return new NodeResponse(localNode, NodeResponse.Status.EXCEPTION, e.toString());
            }
        }

        protected NodeRequest newNodeRequest(Request request) {
            return new NodeRequest(request);
        }

        public static class NodeResponse
        extends BaseNodeResponse {
            private Status status;
            private String message;

            public NodeResponse(StreamInput in) throws IOException {
                super(in);
                this.status = (Status)in.readEnum(Status.class);
                this.message = in.readOptionalString();
            }

            public NodeResponse(DiscoveryNode node, Status status, String message) {
                super(node);
                this.status = status;
                this.message = message;
            }

            public String getMessage() {
                return this.message;
            }

            public Status getStatus() {
                return this.status;
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                out.writeEnum((Enum)this.status);
                out.writeOptionalString(this.message);
            }

            public String toString() {
                return "NodeResponse [status=" + String.valueOf((Object)this.status) + ", message=" + this.message + "]";
            }

            public static NodeResponse readNodeResponse(StreamInput in) throws IOException {
                NodeResponse result = new NodeResponse(in);
                return result;
            }

            public static enum Status {
                SUCCESS,
                EXCEPTION;

            }
        }

        public static class NodeRequest
        extends TransportRequest {
            public NodeRequest(StreamInput in) throws IOException {
                super(in);
            }

            public NodeRequest(Request request) {
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
            }
        }
    }

    public static class Response
    extends BaseNodesResponse<TransportAction.NodeResponse> {
        public Response(ClusterName clusterName, List<TransportAction.NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public List<TransportAction.NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(TransportAction.NodeResponse::readNodeResponse);
        }

        public void writeNodesTo(StreamOutput out, List<TransportAction.NodeResponse> nodes) throws IOException {
            out.writeCollection(nodes);
        }

        public String toString() {
            return "SecretsUpdateResponse [failures=" + String.valueOf(this.failures()) + ", nodes=" + String.valueOf(this.getNodesMap()) + "]";
        }
    }
}

