/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.int_tests;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.IndexApiMatchers;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestAlias;
import com.floragunn.searchguard.test.TestComponentTemplate;
import com.floragunn.searchguard.test.TestDataStream;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestIndexLike;
import com.floragunn.searchguard.test.TestIndexTemplate;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DataStreamAuthorizationReadOnlyIntTests {
    static TestDataStream ds_a1 = TestDataStream.name("ds_a1").documentCount(100).rolloverAfter(10).seed(1).attr("prefix", "a").build();
    static TestDataStream ds_a2 = TestDataStream.name("ds_a2").documentCount(110).rolloverAfter(10).seed(2).attr("prefix", "a").build();
    static TestDataStream ds_a3 = TestDataStream.name("ds_a3").documentCount(120).rolloverAfter(10).seed(3).attr("prefix", "a").build();
    static TestDataStream ds_ax = TestDataStream.name("ds_ax").build();
    static TestDataStream ds_b1 = TestDataStream.name("ds_b1").documentCount(51).rolloverAfter(10).seed(4).attr("prefix", "b").build();
    static TestDataStream ds_b2 = TestDataStream.name("ds_b2").documentCount(52).rolloverAfter(10).seed(5).attr("prefix", "b").build();
    static TestDataStream ds_b3 = TestDataStream.name("ds_b3").documentCount(53).rolloverAfter(10).seed(6).attr("prefix", "b").build();
    static TestDataStream ds_hidden = TestDataStream.name("ds_hidden").documentCount(55).seed(8).attr("prefix", "h").build();
    static TestIndex index_c1 = TestIndex.name("index_c1").documentCount(5).seed(7).attr("prefix", "c").build();
    static TestAlias alias_ab1 = new TestAlias("alias_ab1", ds_a1, ds_a2, ds_a3, ds_b1);
    static TestAlias alias_c1 = new TestAlias("alias_c1", index_c1);
    static TestSgConfig.User LIMITED_USER_A = new TestSgConfig.User("limited_user_A").description("ds_a*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR").on("ds_a*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_a1, ds_a2, ds_a3, ds_ax)).indexMatcher("read_top_level", IndexApiMatchers.limitedTo(ds_a1, ds_a2, ds_a3)).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B = new TestSgConfig.User("limited_user_B").description("ds_b*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR").on("ds_b*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_b1, ds_b2, ds_b3)).indexMatcher("read_top_level", IndexApiMatchers.limitedTo(ds_b1, ds_b2, ds_b3)).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B1 = new TestSgConfig.User("limited_user_B1").description("ds_b1").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR").on("ds_b1")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_b1)).indexMatcher("read_top_level", IndexApiMatchers.limitedTo(ds_b1)).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_ALIAS_AB1 = new TestSgConfig.User("limited_user_alias_AB1").description("alias_ab1").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").aliasPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/aliases/get").on("alias_ab1*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_a1, ds_a2, ds_a3, ds_b1, alias_ab1)).indexMatcher("read_top_level", IndexApiMatchers.limitedTo(alias_ab1)).indexMatcher("get_alias", IndexApiMatchers.limitedTo(ds_a1, ds_a2, ds_a3, ds_b1, alias_ab1));
    static TestSgConfig.User LIMITED_USER_A_HIDDEN = new TestSgConfig.User("limited_user_A_hidden").description("ds_a*, ds_hidden*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR").on("ds_a*", "ds_hidden*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_a1, ds_a2, ds_a3, ds_ax, ds_hidden)).indexMatcher("read_top_level", IndexApiMatchers.limitedTo(ds_a1, ds_a2, ds_a3, ds_ax, ds_hidden)).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_NONE = new TestSgConfig.User("limited_user_none").description("no privileges for existing indices").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_CRUD", "SGS_INDICES_MONITOR").on("ds_does_not_exist_*")).indexMatcher("read", IndexApiMatchers.limitedToNone()).indexMatcher("read_top_level", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User INVALID_USER_INDEX_PERMISSIONS_FOR_ALIAS = new TestSgConfig.User("invalid_user_index_permissions_for_alias").description("invalid: index permissions for alias").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR").on("alias_ab1")).indexMatcher("read", IndexApiMatchers.limitedToNone()).indexMatcher("read_top_level", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User INDEX_UNLIMITED_USER = new TestSgConfig.User("index_unlimited_user").description("unlimited index_permissions").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").indexPermissions("*").on("*").aliasPermissions("*").on("*")).indexMatcher("read", IndexApiMatchers.unlimitedIncludingEsInternalIndices()).indexMatcher("read_top_level", IndexApiMatchers.unlimitedIncludingEsInternalIndices()).indexMatcher("get_alias", IndexApiMatchers.unlimitedIncludingEsInternalIndices());
    static TestSgConfig.User UNLIMITED_USER = new TestSgConfig.User("unlimited_user").description("unlimited complete").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").indexPermissions("*").on("*").aliasPermissions("*").on("*").dataStreamPermissions("*").on("*")).indexMatcher("read", IndexApiMatchers.unlimitedIncludingEsInternalIndices()).indexMatcher("read_top_level", IndexApiMatchers.unlimitedIncludingEsInternalIndices()).indexMatcher("get_alias", IndexApiMatchers.unlimitedIncludingEsInternalIndices());
    static TestSgConfig.User SUPER_UNLIMITED_USER = new TestSgConfig.User("super_unlimited_user").description("super unlimited (admin cert)").adminCertUser().indexMatcher("read", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("read_top_level", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("get_alias", IndexApiMatchers.unlimitedIncludingSearchGuardIndices());
    static List<TestSgConfig.User> USERS = ImmutableList.of((Object)LIMITED_USER_A, (Object)LIMITED_USER_B, (Object)LIMITED_USER_B1, (Object[])new TestSgConfig.User[]{LIMITED_USER_ALIAS_AB1, LIMITED_USER_A_HIDDEN, LIMITED_USER_NONE, INVALID_USER_INDEX_PERMISSIONS_FOR_ALIAS, UNLIMITED_USER, SUPER_UNLIMITED_USER});
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().users(USERS).indexTemplates(new TestIndexTemplate("ds_test", "ds_*").dataStream().composedOf(TestComponentTemplate.DATA_STREAM_MINIMAL)).indexTemplates(new TestIndexTemplate("ds_hidden", "ds_hidden*").priority(10).dataStream("hidden", true).composedOf(TestComponentTemplate.DATA_STREAM_MINIMAL)).dataStreams(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3, ds_hidden).indices(index_c1).aliases(alias_ab1, alias_c1).authzDebug(true).useExternalProcessCluster().build();
    final TestSgConfig.User user;

    @Test
    public void search_noPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3, index_c1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_noPattern_noWildcards() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_search?size=1000&expand_wildcards=none", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(new TestIndexLike[0]).at("hits.hits[*]._index").whenEmpty(200));
        }
    }

    @Test
    public void search_noPattern_allowNoIndicesFalse() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_search?size=1000&allow_no_indices=false", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3, index_c1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(404));
        }
    }

    @Test
    public void search_all() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_all/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3, index_c1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_all_noWildcards() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_all/_search?size=1000&expand_wildcards=none", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(new TestIndexLike[0]).at("hits.hits[*]._index").whenEmpty(200));
        }
    }

    @Test
    public void search_all_includeHidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_all/_search?size=1000&expand_wildcards=all", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3, index_c1, ds_hidden, IndexApiMatchers.searchGuardIndices(), IndexApiMatchers.esInternalIndices()).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_wildcard() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/*/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3, index_c1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_wildcard_includeHidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/*/_search?size=1000&expand_wildcards=all", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3, index_c1, ds_hidden, IndexApiMatchers.searchGuardIndices(), IndexApiMatchers.esInternalIndices()).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_staticIndicies_noIgnoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a1,ds_a2,ds_b1/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_b1).at("hits.hits[*]._index").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void search_staticIndicies_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a1,ds_a2,ds_b1/_search?size=1000&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_b1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_staticIndicies_negation() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a1,ds_a2,ds_b1,-ds_b1/_search?size=1000", new Header[0]);
            if (IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_b1).at("hits.hits[*]._index").isCoveredBy(this.user.indexMatcher("read"))) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isNotFound());
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.type", Matchers.equalTo((Object)"index_not_found_exception"))}));
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.reason", Matchers.containsString((String)"no such index [-ds_b1]"))}));
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void search_staticIndicies_negation_backingIndices() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a1,ds_a2,ds_b1,-.ds-ds_b1*/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_b1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_staticIndicies_hidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_hidden/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_hidden).at("hits.hits[*]._index").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void search_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a*,ds_b*/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_indexPattern_minus() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a*,ds_b*,-ds_b2,-ds_b3/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_indexPattern_minus_backingIndices() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a*,ds_b*,-.ds-ds_b2*,-.ds-ds_b3*/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_indexPattern_nonExistingIndex_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a*,ds_b*,xxx_non_existing/_search?size=1000&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_indexPattern_noWildcards() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a*,ds_b*/_search?size=1000&expand_wildcards=none&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(new TestIndexLike[0]).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_alias_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1/_search?size=1000&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_alias_noIgnoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1).at("hits.hits[*]._index").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void search_aliasPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1*/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_aliasAndIndex_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1,ds_b2/_search?size=1000&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_aliasAndIndex_noIgnoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1,ds_b2/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2).at("hits.hits[*]._index").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void search_nonExisting_static() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("x_does_not_exist/_search?size=1000", new Header[0]);
            if (this.user == UNLIMITED_USER || this.user == SUPER_UNLIMITED_USER) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isNotFound());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void search_nonExisting_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("x_does_not_exist*/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(new TestIndexLike[0]).at("hits.hits[*]._index").whenEmpty(200));
        }
    }

    @Test
    public void search_termsAggregation_index() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/_search", "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":1000}}}}", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3, index_c1).at("aggregations.indices.buckets[*].key").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_pit() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.post("/ds_a*/_pit?keep_alive=1m");
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            String pitId = httpResponse.getBodyAsDocNode().getAsString("id");
            httpResponse = restClient.postJson("/_search?size=1000", (Map<String, Object>)DocNode.of((String)"pit.id", (Object)pitId), new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void msearch_staticIndices() throws Exception {
        String msearchBody = "{\"index\":\"ds_b1\"}\n{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}\n{\"index\":\"ds_b2\"}\n{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}\n";
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/_msearch", msearchBody, new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_b1, ds_b2).at("responses[*].hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void index_stats_all() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_stats", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3, index_c1, IndexApiMatchers.esInternalIndices()).at("indices.keys()").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void index_stats_pattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_b*/_stats", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_b1, ds_b2, ds_b3).at("indices.keys()").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void getAlias_all() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_alias", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(alias_ab1, alias_c1).at("$.*.aliases.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(200));
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, index_c1, IndexApiMatchers.searchGuardIndices()).at("$.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(200));
        }
    }

    @Test
    public void getAlias_staticAlias() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_alias/alias_c1", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(alias_c1).at("$.*.aliases.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(404));
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_c1).at("$.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(404));
        }
    }

    @Test
    public void getAlias_aliasPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_alias/alias_ab*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(alias_ab1).at("$.*.aliases.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(200));
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1).at("$.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(200));
        }
    }

    @Test
    public void getAlias_mixed() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_alias/alias_ab1,alias_c*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(alias_ab1, alias_c1).at("$.*.aliases.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(404));
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, index_c1).at("$.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(404));
        }
    }

    @Test
    public void getDataStream_all() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_data_stream", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3).at("$.data_streams[*].name").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void getDataStream_wildcard() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_data_stream/*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3).at("$.data_streams[*].name").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void getDataStream_pattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_data_stream/ds_a*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3).at("$.data_streams[*].name").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void getDataStream_pattern_negation() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_data_stream/ds_*,-ds_b*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3).at("$.data_streams[*].name").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void getDataStream_static() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_data_stream/ds_a1,ds_a2", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2).at("$.data_streams[*].name").but(this.user.indexMatcher("read")).whenEmpty(403));
        }
    }

    @Test
    public void getDataStreamStats_all() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_data_stream/_stats", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3).at("$.data_streams[*].data_stream").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void getDataStreamStats_wildcard() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_data_stream/*/_stats", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3).at("$.data_streams[*].data_stream").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void getDataStreamStats_pattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_data_stream/ds_a*/_stats", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3).at("$.data_streams[*].data_stream").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void getDataStreamStats_pattern2() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_data_stream/ds_*/_stats", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3).at("$.data_streams[*].data_stream").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void getDataStreamStats_static() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_data_stream/ds_a1,ds_a2/_stats", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2).at("$.data_streams[*].data_stream").but(this.user.indexMatcher("read")).whenEmpty(403));
        }
    }

    @Test
    public void resolve_wildcard() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_resolve/index/*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3, index_c1, alias_ab1, alias_c1).at("$.*[*].name").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void resolve_wildcard_includeHidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_resolve/index/*?expand_wildcards=all", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3, index_c1, alias_ab1, alias_c1, ds_hidden, IndexApiMatchers.searchGuardIndices(), IndexApiMatchers.esInternalIndices()).at("$.*[*].name").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void resolve_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_resolve/index/ds_a*,ds_b*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3).at("$.*[*].name").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_all() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3, index_c1).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a*,ds_b*/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_staticIndices_noIgnoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a1,ds_a2,ds_b1/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_b1).at("indices").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void field_caps_staticIndices_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a1,ds_a2,ds_b1/_field_caps?fields=*&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_b1).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_staticIndices_hidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_hidden/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_hidden).at("indices").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void field_caps_alias_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1/_field_caps?fields=*&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_alias_noIgnoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1).at("indices").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void field_caps_aliasPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1*/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_nonExisting_static() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("x_does_not_exist/_field_caps?fields=*", new Header[0]);
            if (this.user == UNLIMITED_USER || this.user == SUPER_UNLIMITED_USER) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isNotFound());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void field_caps_nonExisting_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("x_does_not_exist*/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(new TestIndexLike[0]).at("indices").whenEmpty(200));
        }
    }

    @Test
    public void field_caps_aliasAndDataStream_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1,ds_b2/_field_caps?fields=*&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_aliasAndDataStream_noIgnoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1,ds_b2/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2).at("indices").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void field_caps_staticIndices_negation() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a1,ds_a2,ds_b1,-ds_b1/_field_caps?fields=*", new Header[0]);
            if (IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_b1).at("indices").isCoveredBy(this.user.indexMatcher("read"))) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isNotFound());
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.type", Matchers.equalTo((Object)"index_not_found_exception"))}));
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.reason", Matchers.containsString((String)"no such index [-ds_b1]"))}));
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void field_caps_indexPattern_minus() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a*,ds_b*,-ds_b2,-ds_b3/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1, ds_b2, ds_b3).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_indexPattern_minus_backingIndices() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a*,ds_b*,-.ds-ds_b2*,-.ds-ds_b3*/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_a3, ds_b1).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_staticIndices_negation_backingIndices() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("ds_a1,ds_a2,ds_b1,-.ds-ds_b1*/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_a1, ds_a2, ds_b1).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> params() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (TestSgConfig.User user : USERS) {
            result.add(new Object[]{user, user.getDescription()});
        }
        return result;
    }

    public DataStreamAuthorizationReadOnlyIntTests(TestSgConfig.User user, String description) throws Exception {
        this.user = user;
    }
}

