/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.log;

import com.floragunn.searchguard.test.helper.log.LogMessage;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Queues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="LogCapturingAppender", category="Core", elementType="appender", printObject=true)
public class LogCapturingAppender
extends AbstractAppender {
    public static final String PLUGIN_NAME = "LogCapturingAppender";
    public static final int MAX_SIZE = 100;
    private static final Queue<LogMessage> messages = Queues.synchronizedQueue((Queue)EvictingQueue.create((int)100));
    private static final Set<String> activeLoggers = ConcurrentHashMap.newKeySet();

    protected LogCapturingAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    @PluginFactory
    public static LogCapturingAppender createAppender(@PluginAttribute(value="name", defaultString="logCapturingAppender") String name) {
        return new LogCapturingAppender(name, null, null, true, Property.EMPTY_ARRAY);
    }

    public void append(LogEvent event) {
        String loggerName = event.getLoggerName();
        boolean loggable = activeLoggers.contains(loggerName);
        if (loggable) {
            event.getThrown();
            messages.add(new LogMessage(event.getMessage().getFormattedMessage(), event.getThrown()));
        }
    }

    public static void enable(String ... loggerNames) {
        LogCapturingAppender.disable();
        activeLoggers.addAll(Arrays.asList(loggerNames));
    }

    public static void disable() {
        activeLoggers.clear();
        messages.clear();
    }

    public static List<LogMessage> getLogMessages() {
        return new ArrayList<LogMessage>(messages);
    }

    public static List<String> getLogMessagesAsString() {
        return LogCapturingAppender.getLogMessages().stream().map(LogMessage::getMessage).collect(Collectors.toList());
    }

    public String toString() {
        return "LogCapturingAppender{}";
    }
}

