/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.internalauthtoken;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.internalauthtoken.InternalAuthTokenProvider;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.user.User;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.junit.Assert;
import org.junit.Test;

public class InternalAuthTokenProviderTest {
    static final Actions actions = new Actions(null);
    static final SgDynamicConfiguration<Role> rolesConfig = TestSgConfig.Role.toActualRole(new TestSgConfig.Role("role_1").indexPermissions("*").on("index_a*"), new TestSgConfig.Role("role_2").indexPermissions("*").on("index_b*"), new TestSgConfig.Role("role_3").indexPermissions("*").on("index_c*"));
    static final Function<User, ImmutableSet<String>> roleMapper = user -> ImmutableSet.of((Object)"role_1", (Object)"role_2");
    static final Supplier<ActionGroup.FlattenedIndex> emptyActionGroupSupplier = () -> ActionGroup.FlattenedIndex.EMPTY;
    static final Supplier<Set<String>> emptyTenantNameSupplier = ImmutableSet::empty;
    static final SgDynamicConfiguration<Role> dlsRolesConfig = TestSgConfig.Role.toActualRole(InternalAuthTokenProviderTest.getContextWithMatchAllQueryParser(), new TestSgConfig.Role("dls_role").indexPermissions("*").dls("{\"match_all\":{}}").on("my_index*"));
    static final Function<User, ImmutableSet<String>> dlsRoleMapper = user -> ImmutableSet.of((Object)"dls_role");
    static final String SIGNING_KEY = "8me7E2GunuIMaeBCbwl+7Le4TzydK7Sv2/kr0p4EVcqisyT3U5qkExBYVMAycYfYyN3Q/e8YYrWd2kZKWVkCJg==";
    static final String JWT_PRODUCED_BY_CXF = "eyJhbGciOiJIUzUxMiJ9.eyJuYmYiOjE3NDE5NDcwMjIsInN1YiI6InRlc3RfdXNlciIsImF1ZCI6InRlc3RfYXVkaWVuY2UiLCJzZ19yb2xlcyI6eyJyb2xlXzEiOnsiY2x1c3Rlcl9wZXJtaXNzaW9ucyI6W10sImluZGV4X3Blcm1pc3Npb25zIjpbeyJpbmRleF9wYXR0ZXJucyI6WyJpbmRleF9hKiJdLCJhbGxvd2VkX2FjdGlvbnMiOlsiKiJdfV0sImFsaWFzX3Blcm1pc3Npb25zIjpbXSwiZGF0YV9zdHJlYW1fcGVybWlzc2lvbnMiOltdLCJ0ZW5hbnRfcGVybWlzc2lvbnMiOltdLCJleGNsdWRlX2NsdXN0ZXJfcGVybWlzc2lvbnMiOltdfSwicm9sZV8yIjp7ImNsdXN0ZXJfcGVybWlzc2lvbnMiOltdLCJpbmRleF9wZXJtaXNzaW9ucyI6W3siaW5kZXhfcGF0dGVybnMiOlsiaW5kZXhfYioiXSwiYWxsb3dlZF9hY3Rpb25zIjpbIioiXX1dLCJhbGlhc19wZXJtaXNzaW9ucyI6W10sImRhdGFfc3RyZWFtX3Blcm1pc3Npb25zIjpbXSwidGVuYW50X3Blcm1pc3Npb25zIjpbXSwiZXhjbHVkZV9jbHVzdGVyX3Blcm1pc3Npb25zIjpbXX19fQ.dsvhX9hKAmxgWljcxBTHjM_T8o53IuGlF1hs-IMTO5iYPgr543ZSwAjtMdcrEmvtm3aJ49U3NWoV7LHVqZrkTw";
    static final String JWT_PRODUCED_BY_NIMBUS = "eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJ0ZXN0X3VzZXIiLCJhdWQiOiJ0ZXN0X2F1ZGllbmNlIiwibmJmIjoxNzQxOTQ2LCJzZ19pIjoibiIsInNnX3JvbGVzIjp7InJvbGVfMSI6eyJjbHVzdGVyX3Blcm1pc3Npb25zIjpbXSwiaW5kZXhfcGVybWlzc2lvbnMiOlt7ImluZGV4X3BhdHRlcm5zIjpbImluZGV4X2EqIl0sImFsbG93ZWRfYWN0aW9ucyI6WyIqIl19XSwiYWxpYXNfcGVybWlzc2lvbnMiOltdLCJkYXRhX3N0cmVhbV9wZXJtaXNzaW9ucyI6W10sInRlbmFudF9wZXJtaXNzaW9ucyI6W10sImV4Y2x1ZGVfY2x1c3Rlcl9wZXJtaXNzaW9ucyI6W119LCJyb2xlXzIiOnsiY2x1c3Rlcl9wZXJtaXNzaW9ucyI6W10sImluZGV4X3Blcm1pc3Npb25zIjpbeyJpbmRleF9wYXR0ZXJucyI6WyJpbmRleF9iKiJdLCJhbGxvd2VkX2FjdGlvbnMiOlsiKiJdfV0sImFsaWFzX3Blcm1pc3Npb25zIjpbXSwiZGF0YV9zdHJlYW1fcGVybWlzc2lvbnMiOltdLCJ0ZW5hbnRfcGVybWlzc2lvbnMiOltdLCJleGNsdWRlX2NsdXN0ZXJfcGVybWlzc2lvbnMiOltdfX19.gcWLI-BOMQH9M70bQSaltGjHpbR7XPqzCrcJd4iS4A0PPsGSJLohQ4MqiWnCjd7ytB__MIek3GkbuhTJZxquyQ";
    static final String JWT_WITH_DLS_ROLE = "eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJ0ZXN0X3VzZXIiLCJhdWQiOiJ0ZXN0X2F1ZGllbmNlIiwibmJmIjoxNzYxMTU2LCJzZ19pIjoibiIsInNnX3JvbGVzIjp7ImRsc19yb2xlIjp7ImNsdXN0ZXJfcGVybWlzc2lvbnMiOltdLCJpbmRleF9wZXJtaXNzaW9ucyI6W3siaW5kZXhfcGF0dGVybnMiOlsibXlfaW5kZXgqIl0sImFsbG93ZWRfYWN0aW9ucyI6WyIqIl0sImRscyI6IntcIm1hdGNoX2FsbFwiOnt9fSJ9XSwiYWxpYXNfcGVybWlzc2lvbnMiOltdLCJkYXRhX3N0cmVhbV9wZXJtaXNzaW9ucyI6W10sInRlbmFudF9wZXJtaXNzaW9ucyI6W10sImV4Y2x1ZGVfY2x1c3Rlcl9wZXJtaXNzaW9ucyI6W119fX0.DNYCxLRQPR1zoYBMqDUcNv2RRGFPN8ak6EC9cyJCADikehvtcGCv6GLnh895n_we_HuMLrwedOM_9pi_LHkQSA";

    static ConfigurationRepository.Context getContextWithMatchAllQueryParser() {
        NamedXContentRegistry xContentRegistry = new NamedXContentRegistry(List.of(new NamedXContentRegistry.Entry(QueryBuilder.class, new ParseField("match_all", new String[0]), MatchAllQueryBuilder::fromXContent)));
        return new ConfigurationRepository.Context(null, null, null, xContentRegistry, null);
    }

    @Test
    public void getJwt() throws Exception {
        InternalAuthTokenProvider subject = new InternalAuthTokenProvider(roleMapper, emptyActionGroupSupplier, emptyTenantNameSupplier, actions, () -> rolesConfig, null);
        subject.setSigningKey(SIGNING_KEY);
        String jwt = subject.getJwt(new User("test_user"), "test_audience");
        SignedJWT signedJWT = SignedJWT.parse((String)jwt);
        Assert.assertTrue((String)("JWT can be verified: " + jwt), (boolean)signedJWT.verify((JWSVerifier)new MACVerifier(Base64.getDecoder().decode(SIGNING_KEY))));
    }

    @Test
    public void userAuthFromToken_jwtFromNimbus() throws Exception {
        InternalAuthTokenProvider subject = new InternalAuthTokenProvider(roleMapper, emptyActionGroupSupplier, emptyTenantNameSupplier, actions, () -> rolesConfig, null);
        subject.setSigningKey(SIGNING_KEY);
        InternalAuthTokenProvider.AuthFromInternalAuthToken result = subject.userAuthFromToken(JWT_PRODUCED_BY_NIMBUS, "test_audience");
        Assert.assertEquals((Object)"test_user", (Object)result.getUser().getName());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"role_1", (Object)"role_2"), (Object)result.getUser().getSearchGuardRoles());
    }

    @Test
    public void userAuthFromToken_jwtFromCxf() throws Exception {
        InternalAuthTokenProvider subject = new InternalAuthTokenProvider(roleMapper, emptyActionGroupSupplier, emptyTenantNameSupplier, actions, () -> rolesConfig, null);
        subject.setSigningKey(SIGNING_KEY);
        InternalAuthTokenProvider.AuthFromInternalAuthToken result = subject.userAuthFromToken(JWT_PRODUCED_BY_CXF, "test_audience");
        Assert.assertEquals((Object)"test_user", (Object)result.getUser().getName());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"role_1", (Object)"role_2"), (Object)result.getUser().getSearchGuardRoles());
    }

    @Test
    public void userAuthFromToken_withDlsRole() throws Exception {
        InternalAuthTokenProvider subject = new InternalAuthTokenProvider(dlsRoleMapper, emptyActionGroupSupplier, emptyTenantNameSupplier, actions, () -> dlsRolesConfig, InternalAuthTokenProviderTest.getContextWithMatchAllQueryParser());
        subject.setSigningKey(SIGNING_KEY);
        InternalAuthTokenProvider.AuthFromInternalAuthToken result = subject.userAuthFromToken(JWT_WITH_DLS_ROLE, "test_audience");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"test_user", (Object)result.getUser().getName());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"dls_role"), (Object)result.getUser().getSearchGuardRoles());
    }

    @Test
    public void userAuthFromToken_withDlsRoleMissingParsingContext() throws Exception {
        InternalAuthTokenProvider subject = new InternalAuthTokenProvider(dlsRoleMapper, emptyActionGroupSupplier, emptyTenantNameSupplier, actions, () -> dlsRolesConfig, null);
        subject.setSigningKey(SIGNING_KEY);
        Assert.assertThrows(PrivilegesEvaluationException.class, () -> subject.userAuthFromToken(JWT_WITH_DLS_ROLE, "test_audience"));
    }
}

