/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.rest.authenticators;

import com.floragunn.codova.documents.ContentType;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.Arrays;
import java.util.Collection;
import org.apache.http.Header;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class BaseClientCertificateUserNameMappingTest {
    private final String subjectDistinguishedName;
    private final String expectedUserName;

    protected BaseClientCertificateUserNameMappingTest(String subjectDistinguishedName, String expectedUserName) {
        this.subjectDistinguishedName = subjectDistinguishedName;
        this.expectedUserName = expectedUserName;
    }

    static LocalCluster clusterWithConfiguredCertificateClientAuthentication(String userNameMapping) {
        return new LocalCluster.Builder().sslEnabled().enterpriseModulesEnabled().authc(new TestSgConfig.Authc(new TestSgConfig.Authc.Domain("clientcert").userMapping(new TestSgConfig.Authc.Domain.UserMapping().userNameFrom(userNameMapping)))).build();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testParameters() {
        return Arrays.asList({"C = uk, O = search, OU = it, CN = james", "james"}, {"c = de, o = search, ou = it, cn = Leo", "Leo"}, {"c = pl, o = search, ou = it, CN = George", "George"}, {"cn = Amelia", "Amelia"}, {"c = us, L = NY, o = Guard, cn = Isla", "Isla"});
    }

    @Test
    public void shouldIgnoreCasesInDirectoryStringAttributesNames() throws Exception {
        try (GenericRestClient client = this.getLocalCluster().getUserCertRestClient(this.subjectDistinguishedName, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            String username = DocNode.parse((ContentType)ContentType.parseHeader((String)response.getHeaderValue("Content-Type"))).from(response.getBody()).getAsString("user_name");
            MatcherAssert.assertThat((Object)username, (Matcher)Matchers.equalTo((Object)this.expectedUserName));
        }
    }

    protected abstract LocalCluster getLocalCluster();
}

