/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestData;
import com.floragunn.searchguard.test.TestIndexLike;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;

public class TestDataStream
implements TestIndexLike {
    private final String name;
    private final TestData testData;

    public TestDataStream(String name, TestData testData) {
        this.name = name;
        this.testData = testData;
    }

    @Override
    public DocNode getFieldsMappings() {
        return this.testData.getFieldsMappings();
    }

    public void create(GenericRestClient client) throws Exception {
        GenericRestClient.HttpResponse response = client.head(this.name, new Header[0]);
        if (response.getStatusCode() == 200) {
            return;
        }
        response = client.put("/_data_stream/" + this.name);
        if (response.getStatusCode() != 200 && response.getStatusCode() != 201) {
            throw new RuntimeException("Error while creating data stream " + this.name + "\n" + String.valueOf(response));
        }
        DocNode mappings = this.testData.getFieldMappingsWithoutTimestamp();
        if (!mappings.isEmpty()) {
            DocNode mappingRequestBody = DocNode.of((String)"properties", (Object)mappings);
            GenericRestClient.HttpResponse mappingsResponse = client.putJson("/" + this.name + "/_mapping", (Document<?>)mappingRequestBody);
            if (mappingsResponse.getStatusCode() != 200) {
                throw new RuntimeException("Cannot update mappings for data stream '" + this.name + "' response code '" + mappingsResponse.getStatusCode() + "' and body '" + mappingsResponse.getBody() + "'");
            }
        }
        this.testData.putDocuments(client, this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TestData getTestData() {
        return this.testData;
    }

    public static Builder name(String name) {
        return new Builder().name(name);
    }

    public String toString() {
        return "Test data stream '" + this.name + "'";
    }

    @Override
    public Set<String> getDocumentIds() {
        return this.getTestData().getRetainedDocuments().keySet();
    }

    @Override
    public Map<String, Map<String, ?>> getDocuments() {
        return this.getTestData().getRetainedDocuments();
    }

    public static class Builder {
        private String name;
        private TestData.Builder testDataBuilder = new TestData.Builder().timestampColumnName("@timestamp").deletedDocumentFraction(0.0);
        private TestData testData;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder data(TestData data) {
            this.testData = data;
            return this;
        }

        public Builder seed(int seed) {
            this.testDataBuilder.seed(seed);
            return this;
        }

        public Builder documentCount(int size) {
            this.testDataBuilder.documentCount(size);
            return this;
        }

        public Builder refreshAfter(int refreshAfter) {
            this.testDataBuilder.refreshAfter(refreshAfter);
            return this;
        }

        public Builder rolloverAfter(int rolloverAfter) {
            this.testDataBuilder.rolloverAfter(rolloverAfter);
            return this;
        }

        public Builder segmentCount(int segmentCount) {
            this.testDataBuilder.segmentCount(segmentCount);
            return this;
        }

        public Builder attr(String name, Object value) {
            this.testDataBuilder.attr(name, value);
            return this;
        }

        public TestDataStream build() {
            if (this.testData == null) {
                this.testData = this.testDataBuilder.get();
            }
            return new TestDataStream(this.name, this.testData);
        }
    }
}

