/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.certificate;

import com.floragunn.searchguard.test.helper.certificate.CertificateWithKeyPair;
import com.floragunn.searchguard.test.helper.certificate.asymmetricscryptography.AsymmetricCryptographyAlgorithm;
import com.floragunn.searchguard.test.helper.certificate.asymmetricscryptography.ECDSAAsymmetricCryptographyAlgorithm;
import com.floragunn.searchguard.test.helper.certificate.asymmetricscryptography.RSAAsymmetricCryptographyAlgorithm;
import com.floragunn.searchguard.test.helper.certificate.utils.CertificateSerialNumberGenerator;
import com.floragunn.searchguard.test.helper.certificate.utils.DnGenerator;
import com.floragunn.searchguard.test.helper.certificate.utils.SubjectAlternativesNameGenerator;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class TestCertificateFactory {
    private static final Logger log = LogManager.getLogger(TestCertificateFactory.class);
    private static final Provider DEFAULT_SECURITY_PROVIDER = new BouncyCastleProvider();
    private final Provider securityProvider;
    private final AsymmetricCryptographyAlgorithm asymmetricCryptographyAlgorithm;
    private final JcaX509ExtensionUtils extUtils;

    public static TestCertificateFactory rsaBaseCertificateFactory() {
        return TestCertificateFactory.rsaBaseCertificateFactory(null);
    }

    public static TestCertificateFactory rsaBaseCertificateFactory(Provider securityProvider) {
        Provider provider = Optional.ofNullable(securityProvider).orElse(DEFAULT_SECURITY_PROVIDER);
        return new TestCertificateFactory(provider, new RSAAsymmetricCryptographyAlgorithm(provider, 2048));
    }

    public static TestCertificateFactory ecdsaBaseCertificatesFactory() {
        return TestCertificateFactory.ecdsaBaseCertificatesFactory(null);
    }

    public static TestCertificateFactory ecdsaBaseCertificatesFactory(Provider securityProvider) {
        Provider provider = Optional.ofNullable(securityProvider).orElse(DEFAULT_SECURITY_PROVIDER);
        return new TestCertificateFactory(provider, new ECDSAAsymmetricCryptographyAlgorithm(provider, "P-384"));
    }

    private TestCertificateFactory(Provider securityProvider, AsymmetricCryptographyAlgorithm asymmetricCryptographyAlgorithm) {
        this.securityProvider = securityProvider;
        this.asymmetricCryptographyAlgorithm = asymmetricCryptographyAlgorithm;
        this.extUtils = TestCertificateFactory.getExtUtils();
    }

    public CertificateWithKeyPair createCaCertificate(String dn, int validityDays) {
        Date validityStartDate = new Date(System.currentTimeMillis());
        Date validityEndDate = this.getEndDate(validityStartDate, validityDays);
        return this.getCertificateWithKeyPair(dn, validityStartDate, validityEndDate);
    }

    public CertificateWithKeyPair createCaCertificate(String dn, Date validityStartDate, Date validityEndDate) {
        return this.getCertificateWithKeyPair(dn, validityStartDate, validityEndDate);
    }

    private CertificateWithKeyPair getCertificateWithKeyPair(String dn, Date validityStartDate, Date validityEndDate) {
        try {
            KeyPair keyPair = this.asymmetricCryptographyAlgorithm.generateKeyPair();
            X500Name subjectName = (X500Name)DnGenerator.rootDn.apply(dn);
            ContentSigner contentSigner = new JcaContentSignerBuilder(this.asymmetricCryptographyAlgorithm.getSignatureAlgorithmName()).setProvider(this.securityProvider).build(keyPair.getPrivate());
            X509CertificateHolder x509CertificateHolder = new X509v3CertificateBuilder(subjectName, BigInteger.valueOf(1L), validityStartDate, validityEndDate, subjectName, SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded())).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true)).addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)this.extUtils.createAuthorityKeyIdentifier(keyPair.getPublic())).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.extUtils.createSubjectKeyIdentifier(keyPair.getPublic())).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134)).build(contentSigner);
            return new CertificateWithKeyPair(x509CertificateHolder, keyPair);
        }
        catch (CertIOException | OperatorCreationException e) {
            log.error("Error while generating CA certificate", e);
            throw new RuntimeException("Error while generating CA certificate", e);
        }
    }

    public CertificateWithKeyPair createClientCertificate(String dn, int validityDays, X509CertificateHolder signingCertificate, PrivateKey signingPrivateKey) {
        try {
            KeyPair keyPair = this.asymmetricCryptographyAlgorithm.generateKeyPair();
            X500Name subjectName = (X500Name)DnGenerator.clientDn.apply(dn);
            ContentSigner contentSigner = new JcaContentSignerBuilder(this.asymmetricCryptographyAlgorithm.getSignatureAlgorithmName()).setProvider(this.securityProvider).build(signingPrivateKey);
            Date validityStartDate = new Date(System.currentTimeMillis());
            Date validityEndDate = this.getEndDate(validityStartDate, validityDays);
            X509CertificateHolder x509CertificateHolder = new X509v3CertificateBuilder(signingCertificate.getSubject(), CertificateSerialNumberGenerator.generateNextCertificateSerialNumber(), validityStartDate, validityEndDate, subjectName, SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded())).addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)this.extUtils.createAuthorityKeyIdentifier(signingCertificate)).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.extUtils.createSubjectKeyIdentifier(keyPair.getPublic())).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(224)).build(contentSigner);
            return new CertificateWithKeyPair(x509CertificateHolder, keyPair);
        }
        catch (CertIOException | OperatorCreationException e) {
            log.error("Error while generating client certificate", e);
            throw new RuntimeException("Error while generating client certificate", e);
        }
    }

    public CertificateWithKeyPair createNodeCertificate(String dn, int validityDays, String nodeOid, List<String> dnsList, List<String> ipList, X509CertificateHolder signingCertificate, PrivateKey signingPrivateKey) {
        try {
            KeyPair keyPair = this.asymmetricCryptographyAlgorithm.generateKeyPair();
            X500Name subjectName = (X500Name)DnGenerator.nodeDn.apply(dn);
            ContentSigner contentSigner = new JcaContentSignerBuilder(this.asymmetricCryptographyAlgorithm.getSignatureAlgorithmName()).setProvider(this.securityProvider).build(signingPrivateKey);
            Date validityStartDate = new Date(System.currentTimeMillis());
            Date validityEndDate = this.getEndDate(validityStartDate, validityDays);
            X509CertificateHolder x509CertificateHolder = new X509v3CertificateBuilder(signingCertificate.getSubject(), CertificateSerialNumberGenerator.generateNextCertificateSerialNumber(), validityStartDate, validityEndDate, subjectName, SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded())).addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)this.extUtils.createAuthorityKeyIdentifier(signingCertificate)).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.extUtils.createSubjectKeyIdentifier(keyPair.getPublic())).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(224)).addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_serverAuth, KeyPurposeId.id_kp_clientAuth})).addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)SubjectAlternativesNameGenerator.createSubjectAlternativeNameList(nodeOid, dnsList, ipList)).build(contentSigner);
            return new CertificateWithKeyPair(x509CertificateHolder, keyPair);
        }
        catch (CertIOException | OperatorCreationException e) {
            log.error("Error while generating node certificate", e);
            throw new RuntimeException("Error while generating node certificate", e);
        }
    }

    private Date getEndDate(Date startDate, int validityDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(5, validityDays);
        return calendar.getTime();
    }

    private static JcaX509ExtensionUtils getExtUtils() {
        try {
            return new JcaX509ExtensionUtils();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Getting ext utils failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

