/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.certificate.utils;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;

public class SubjectAlternativesNameGenerator {
    public static DERSequence createSubjectAlternativeNameList(String nodeOid, List<String> dnsList, List<String> ipList) {
        ArrayList<GeneralName> subjectAlternativeNameList = new ArrayList<GeneralName>();
        if (!Strings.isNullOrEmpty((String)nodeOid)) {
            subjectAlternativeNameList.add(new GeneralName(8, nodeOid));
        }
        if (dnsList != null && !dnsList.isEmpty()) {
            for (String dnsName : dnsList) {
                subjectAlternativeNameList.add(new GeneralName(2, dnsName));
            }
        }
        if (ipList != null && !ipList.isEmpty()) {
            for (String ip : ipList) {
                subjectAlternativeNameList.add(new GeneralName(7, ip));
            }
        }
        return new DERSequence(subjectAlternativeNameList.toArray(new ASN1Encodable[subjectAlternativeNameList.size()]));
    }
}

