/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.int_tests;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.IndexApiMatchers;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestAlias;
import com.floragunn.searchguard.test.TestData;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestIndexLike;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexAuthorizationReadOnlyIntTests {
    static TestIndex index_a1 = TestIndex.name("index_a1").documentCount(100).seed(1).attr("prefix", "a").build();
    static TestIndex index_a2 = TestIndex.name("index_a2").documentCount(110).seed(2).attr("prefix", "a").build();
    static TestIndex index_a3 = TestIndex.name("index_a3").documentCount(120).seed(3).attr("prefix", "a").build();
    static TestIndex index_ax = TestIndex.name("index_ax").build();
    static TestIndex index_b1 = TestIndex.name("index_b1").documentCount(51).seed(4).attr("prefix", "b").build();
    static TestIndex index_b2 = TestIndex.name("index_b2").documentCount(52).seed(5).attr("prefix", "b").build();
    static TestIndex index_b3 = TestIndex.name("index_b3").documentCount(53).seed(6).attr("prefix", "b").build();
    static TestIndex index_c1 = TestIndex.name("index_c1").documentCount(5).seed(7).attr("prefix", "c").build();
    static TestIndex index_hidden = TestIndex.name("index_hidden").hidden().documentCount(1).seed(8).attr("prefix", "h").build();
    static TestIndex index_hidden_dot = TestIndex.name(".index_hidden_dot").hidden().documentCount(1).seed(8).attr("prefix", "h").build();
    static TestIndex index_system = TestIndex.name(".index_system").hidden().documentCount(1).seed(8).attr("prefix", "system").build();
    static TestAlias alias_ab1 = new TestAlias("alias_ab1", index_a1, index_a2, index_a3, index_b1);
    static TestAlias alias_c1 = new TestAlias("alias_c1", index_c1);
    static TestSgConfig.User LIMITED_USER_A = new TestSgConfig.User("limited_user_A").description("index_a*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR").on("index_a*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_a1, index_a2, index_a3, index_ax)).indexMatcher("read_top_level", IndexApiMatchers.limitedTo(index_a1, index_a2, index_a3)).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B = new TestSgConfig.User("limited_user_B").description("index_b*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR").on("index_b*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_b1, index_b2, index_b3)).indexMatcher("read_top_level", IndexApiMatchers.limitedTo(index_b1, index_b2, index_b3)).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B1 = new TestSgConfig.User("limited_user_B1").description("index_b1").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR").on("index_b1")).indexMatcher("read", IndexApiMatchers.limitedTo(index_b1)).indexMatcher("read_top_level", IndexApiMatchers.limitedTo(index_b1)).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_C = new TestSgConfig.User("limited_user_C").description("index_c*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR").on("index_c*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_c1)).indexMatcher("read_top_level", IndexApiMatchers.limitedTo(index_c1)).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_ALIAS_AB1 = new TestSgConfig.User("limited_user_alias_AB1").description("alias_ab1").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").aliasPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/aliases/get").on("alias_ab1*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_a1, index_a2, index_a3, index_b1, alias_ab1)).indexMatcher("read_top_level", IndexApiMatchers.limitedTo(alias_ab1)).indexMatcher("get_alias", IndexApiMatchers.limitedTo(index_a1, index_a2, index_a3, index_b1, alias_ab1));
    static TestSgConfig.User LIMITED_USER_ALIAS_C1 = new TestSgConfig.User("limited_user_alias_C1").description("alias_c1").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").aliasPermissions("SGS_READ", "SGS_INDICES_MONITOR").on("alias_c1")).indexMatcher("read", IndexApiMatchers.limitedTo(index_c1, alias_c1)).indexMatcher("read_top_level", IndexApiMatchers.limitedTo(alias_c1)).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_A_HIDDEN = new TestSgConfig.User("limited_user_A_hidden").description("index_a*, index_hidden*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR").on("index_a*", "index_hidden*", ".index_hidden*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_a1, index_a2, index_a3, index_ax, index_hidden, index_hidden_dot)).indexMatcher("read_top_level", IndexApiMatchers.limitedTo(index_a1, index_a2, index_a3, index_ax, index_hidden, index_hidden_dot)).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_A_SYSTEM = new TestSgConfig.User("limited_user_A_system").description("index_a*, .index_system*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR").on("index_a*", ".index_system*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_a1, index_a2, index_a3, index_ax, index_system)).indexMatcher("read_top_level", IndexApiMatchers.limitedTo(index_a1, index_a2, index_a3, index_ax, index_system)).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_NONE = new TestSgConfig.User("limited_user_none").description("no privileges for existing indices").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_CRUD", "SGS_INDICES_MONITOR").on("index_does_not_exist_*")).indexMatcher("read", IndexApiMatchers.limitedToNone()).indexMatcher("read_top_level", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User INVALID_USER_INDEX_PERMISSIONS_FOR_ALIAS = new TestSgConfig.User("invalid_user_index_permissions_for_alias").description("invalid: index permissions for alias").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR").on("alias_ab1")).indexMatcher("read", IndexApiMatchers.limitedToNone()).indexMatcher("read_top_level", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User UNLIMITED_USER = new TestSgConfig.User("unlimited_user").description("unlimited").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").indexPermissions("*").on("*").aliasPermissions("*").on("*")).indexMatcher("read", IndexApiMatchers.unlimited()).indexMatcher("read_top_level", IndexApiMatchers.unlimited()).indexMatcher("get_alias", IndexApiMatchers.unlimited());
    static TestSgConfig.User SUPER_UNLIMITED_USER = new TestSgConfig.User("super_unlimited_user").description("super unlimited (admin cert)").adminCertUser().indexMatcher("read", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("read_top_level", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("get_alias", IndexApiMatchers.unlimitedIncludingSearchGuardIndices());
    static List<TestSgConfig.User> USERS = ImmutableList.of((Object)LIMITED_USER_A, (Object)LIMITED_USER_B, (Object)LIMITED_USER_B1, (Object[])new TestSgConfig.User[]{LIMITED_USER_C, LIMITED_USER_ALIAS_AB1, LIMITED_USER_ALIAS_C1, LIMITED_USER_A_HIDDEN, LIMITED_USER_A_SYSTEM, LIMITED_USER_NONE, INVALID_USER_INDEX_PERMISSIONS_FOR_ALIAS, UNLIMITED_USER, SUPER_UNLIMITED_USER});
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().singleNode().sslEnabled().users(USERS).indices(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1, index_hidden, index_hidden_dot, index_system).aliases(alias_ab1, alias_c1).authzDebug(true).embedded().plugin(TestSystemIndexPlugin.class).logRequests().build();
    static List<GenericRestClient.RequestInfo> executedRequests = new ArrayList<GenericRestClient.RequestInfo>(1000);
    final TestSgConfig.User user;

    @Test
    public void search_noPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_noPattern_noWildcards() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_search?size=1000&expand_wildcards=none", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(new TestIndexLike[0]).at("hits.hits[*]._index").whenEmpty(200));
        }
    }

    @Test
    public void search_noPattern_allowNoIndicesFalse() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_search?size=1000&allow_no_indices=false", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(404));
        }
    }

    @Test
    public void search_all() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_all/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_all_noWildcards() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_all/_search?size=1000&expand_wildcards=none", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(new TestIndexLike[0]).at("hits.hits[*]._index").whenEmpty(200));
        }
    }

    @Test
    public void search_all_includeHidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_all/_search?size=1000&expand_wildcards=all", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1, index_hidden, index_hidden_dot, IndexApiMatchers.searchGuardIndices()).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_all_includeHidden_origin() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_all/_search?size=1000&expand_wildcards=all", new Header[]{new BasicHeader("X-elastic-product-origin", "origin-with-allowed-system-indices")});
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1, index_hidden, index_hidden_dot, index_system, IndexApiMatchers.searchGuardIndices()).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_wildcard() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/*/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_wildcard_noWildcards() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/*/_search?size=1000&expand_wildcards=none", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(new TestIndexLike[0]).at("hits.hits[*]._index").whenEmpty(404));
        }
    }

    @Test
    public void search_wildcard_includeHidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/*/_search?size=1000&expand_wildcards=all", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1, index_hidden, index_hidden_dot, IndexApiMatchers.searchGuardIndices()).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_staticIndicies_noIgnoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_a1,index_a2,index_b1/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_b1).at("hits.hits[*]._index").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void search_staticIndicies_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_a1,index_a2,index_b1/_search?size=1000&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_b1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_staticIndicies_nonExisting() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_ax/_search?size=1000", new Header[0]);
            if (IndexApiMatchers.containsExactly(index_ax).but(this.user.indexMatcher("read")).isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isNotFound());
            }
        }
    }

    @Test
    public void search_staticIndicies_negation() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_a1,index_a2,index_b1,-index_b1/_search?size=1000", new Header[0]);
            if (httpResponse.getStatusCode() == 404) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.type", Matchers.equalTo((Object)"index_not_found_exception"))}));
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.reason", Matchers.containsString((String)"no such index [-index_b1]"))}));
            } else {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_b1).at("hits.hits[*]._index").butForbiddenIfIncomplete(this.user.indexMatcher("read")).whenEmpty(403));
            }
        }
    }

    @Test
    public void search_staticIndicies_hidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_hidden/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_hidden).at("hits.hits[*]._index").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void search_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_a*,index_b*/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_indexPattern_minus() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_a*,index_b*,-index_b2,-index_b3/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_indexPattern_nonExistingIndex_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_a*,index_b*,xxx_non_existing/_search?size=1000&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_indexPattern_noWildcards() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_a*,index_b*/_search?size=1000&expand_wildcards=none&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(new TestIndexLike[0]).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_indexPatternAndStatic_noWildcards() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_a*,index_b1/_search?size=1000&expand_wildcards=none&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_b1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_indexPatternAndStatic_negation() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_a*,index_b1,index_b2,-index_b2/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_alias_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1/_search?size=1000&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_alias_noIgnoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1).at("hits.hits[*]._index").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void search_alias_pattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1*/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_alias_pattern_negation() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_*,-alias_ab1/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_c1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_aliasAndIndex_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1,index_b2/_search?size=1000&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_aliasAndIndex_noIgnoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1,index_b2/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2).at("hits.hits[*]._index").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void search_nonExisting_static() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("x_does_not_exist/_search?size=1000", new Header[0]);
            if (this.user == UNLIMITED_USER || this.user == SUPER_UNLIMITED_USER) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isNotFound());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void search_nonExisting_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("x_does_not_exist*/_search?size=1000", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(new TestIndexLike[0]).at("hits.hits[*]._index").whenEmpty(200));
        }
    }

    @Test
    public void search_termsAggregation_index() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/_search", "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":1000}}}}", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1).at("aggregations.indices.buckets[*].key").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_protectedIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/.searchguard/_search", new Header[0]);
            if (this.user == SUPER_UNLIMITED_USER) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void search_pit() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.post("/index_*/_pit?keep_alive=1m");
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            String pitId = httpResponse.getBodyAsDocNode().getAsString("id");
            httpResponse = restClient.postJson("/_search?size=1000", (Map<String, Object>)DocNode.of((String)"pit.id", (Object)pitId), new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_pit_all() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.post("/_all/_pit?keep_alive=1m");
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            String pitId = httpResponse.getBodyAsDocNode().getAsString("id");
            httpResponse = restClient.postJson("/_search?size=1000", (Map<String, Object>)DocNode.of((String)"pit.id", (Object)pitId), new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void search_pit_static() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.post("/index_a1/_pit?keep_alive=1m");
            if (IndexApiMatchers.containsExactly(index_a1).but(this.user.indexMatcher("read")).isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
                return;
            }
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            String pitId = httpResponse.getBodyAsDocNode().getAsString("id");
            httpResponse = restClient.postJson("/_search?size=1000", (Map<String, Object>)DocNode.of((String)"pit.id", (Object)pitId), new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1).at("hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(403));
        }
    }

    @Test
    public void search_pit_wrongIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.post("/index_a*/_pit?keep_alive=1m");
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            String pitId = httpResponse.getBodyAsDocNode().getAsString("id");
            httpResponse = restClient.postJson("/index_b*/_search?size=1000", (Map<String, Object>)DocNode.of((String)"pit.id", (Object)pitId), new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isBadRequest("error.reason", "*[indices] cannot be used with point in time*"));
        }
    }

    @Test
    public void msearch_staticIndices() throws Exception {
        String msearchBody = "{\"index\":\"index_b1\"}\n{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}\n{\"index\":\"index_b2\"}\n{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}\n";
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/_msearch", msearchBody, new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_b1, index_b2).at("responses[*].hits.hits[*]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void mget() throws Exception {
        TestData.TestDocument testDocumentA1 = index_a1.getTestData().anyDocument();
        TestData.TestDocument testDocumentB1 = index_b1.getTestData().anyDocument();
        TestData.TestDocument testDocumentB2 = index_b2.getTestData().anyDocument();
        DocNode mget = DocNode.of((String)"docs", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"_index", (Object)"index_a1", (String)"_id", (Object)testDocumentA1.getId()), DocNode.of((String)"_index", (Object)"index_b1", (String)"_id", (Object)testDocumentB1.getId()), DocNode.of((String)"_index", (Object)"index_b2", (String)"_id", (Object)testDocumentB2.getId())}));
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/_mget", (Map<String, Object>)mget, new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_b1, index_b2).at("docs[?(@.found == true)]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void mget_alias() throws Exception {
        TestData.TestDocument testDocumentC1a = index_c1.getTestData().anyDocument();
        TestData.TestDocument testDocumentC1b = index_c1.getTestData().anyDocument();
        DocNode mget = DocNode.of((String)"docs", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"_index", (Object)"alias_c1", (String)"_id", (Object)testDocumentC1a.getId()), DocNode.of((String)"_index", (Object)"alias_c1", (String)"_id", (Object)testDocumentC1b.getId())}));
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/_mget", (Map<String, Object>)mget, new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_c1).at("docs[?(@.found == true)]._index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void get() throws Exception {
        TestData.TestDocument testDocumentB1 = index_b1.getTestData().anyDocument();
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/index_b1/_doc/" + testDocumentB1.getId(), new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_b1).at("_index").but(this.user.indexMatcher("read")).whenEmpty(403));
        }
    }

    @Test
    public void get_alias() throws Exception {
        TestData.TestDocument testDocumentC1 = index_c1.getTestData().anyDocument();
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/alias_c1/_doc/" + testDocumentC1.getId(), new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_c1).at("_index").but(this.user.indexMatcher("read")).whenEmpty(403));
        }
    }

    @Test
    public void cat_all() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_cat/indices?format=json", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1).at("$[*].index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void cat_pattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_cat/indices/index_a*?format=json", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3).at("$[*].index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void cat_all_includeHidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_cat/indices?format=json&expand_wildcards=all", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1, index_hidden, index_hidden_dot, index_system, IndexApiMatchers.searchGuardIndices()).at("$[*].index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void cat_all_includeHidden_origin() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_cat/indices?format=json&expand_wildcards=all", new Header[]{new BasicHeader("X-elastic-product-origin", "origin-with-allowed-system-indices")});
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1, index_hidden, index_hidden_dot, index_system, IndexApiMatchers.searchGuardIndices()).at("$[*].index").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void index_stats_all() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_stats", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1).at("indices.keys()").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void index_stats_pattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_b*/_stats", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_b1, index_b2, index_b3).at("indices.keys()").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void getAlias_all() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_alias", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(alias_ab1, alias_c1).at("$.*.aliases.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(200));
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1, index_hidden, index_hidden_dot, IndexApiMatchers.searchGuardIndices()).at("$.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(200));
        }
    }

    @Test
    public void getAlias_staticAlias() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_alias/alias_c1", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(alias_c1).at("$.*.aliases.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(404));
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_c1).at("$.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(404));
        }
    }

    @Test
    public void getAlias_aliasPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_alias/alias_ab*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(alias_ab1).at("$.*.aliases.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(200));
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1).at("$.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(200));
        }
    }

    @Test
    public void getAlias_aliasPattern_noWildcards() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_alias/alias_ab*?expand_wildcards=none", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            MatcherAssert.assertThat((Object)httpResponse.getBodyAsDocNode(), (Matcher)Matchers.equalTo((Object)DocNode.EMPTY));
        }
    }

    @Test
    public void getAlias_mixed() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("_alias/alias_ab1,alias_c*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(alias_ab1, alias_c1).at("$.*.aliases.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(404));
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_c1).at("$.keys()").but(this.user.indexMatcher("get_alias")).whenEmpty(404));
        }
    }

    @Test
    public void analyze_noIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("_analyze", "{\"text\": \"sample text\"}", new Header[0]);
            if (this.user.indexMatcher("read").isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            }
        }
    }

    @Test
    public void analyze_staticIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("index_a1/_analyze", "{\"text\": \"sample text\"}", new Header[0]);
            IndexApiMatchers.IndexMatcher matcher = IndexApiMatchers.containsExactly(index_a1).but(this.user.indexMatcher("read"));
            if (matcher.isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            }
        }
    }

    @Test
    public void resolve_wildcard() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_resolve/index/*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1, alias_ab1, alias_c1).at("$.*[*].name").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void resolve_wildcard_includeHidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_resolve/index/*?expand_wildcards=all", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1, alias_ab1, alias_c1, index_hidden, index_hidden_dot, IndexApiMatchers.searchGuardIndices()).at("$.*[*].name").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void resolve_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_resolve/index/index_a*,index_b*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3).at("$.*[*].name").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_all() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
            String product = httpResponse.getHeaderValue("X-elastic-product");
            MatcherAssert.assertThat((String)httpResponse.getBody(), (Object)product, (Matcher)Matchers.containsString((String)"search"));
        }
    }

    @Test
    public void field_caps_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_b*/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_b1, index_b2, index_b3).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_staticIndices_noIgnoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_a1,index_a2,index_b1/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_b1).at("indices").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void field_caps_staticIndices_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_a1,index_a2,index_b1/_field_caps?fields=*&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_b1).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_staticIndices_hidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_hidden/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_hidden).at("indices").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void field_caps_alias_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1/_field_caps?fields=*&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_alias_noIgnoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1).at("indices").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void field_caps_aliasPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/alias_ab*/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_nonExisting_static() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_ax/_field_caps?fields=*", new Header[0]);
            if (IndexApiMatchers.containsExactly(index_ax).but(this.user.indexMatcher("read")).isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isNotFound());
            }
        }
    }

    @Test
    public void field_caps_nonExisting_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("x_does_not_exist*/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(new TestIndexLike[0]).at("indices").whenEmpty(200));
        }
    }

    @Test
    public void field_caps_aliasAndIndex_ignoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1,index_b2/_field_caps?fields=*&ignore_unavailable=true", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Test
    public void field_caps_aliasAndIndex_noIgnoreUnavailable() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("alias_ab1,index_b2/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1, index_b2).at("indices").butForbiddenIfIncomplete(this.user.indexMatcher("read")));
        }
    }

    @Test
    public void field_caps_staticIndices_negation() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_a1,index_a2,index_b1,-index_b1/_field_caps?fields=*", new Header[0]);
            if (httpResponse.getStatusCode() == 404) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.type", Matchers.equalTo((Object)"index_not_found_exception"))}));
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("error.reason", Matchers.containsString((String)"no such index [-index_b1]"))}));
            } else {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_b1).at("indices").butForbiddenIfIncomplete(this.user.indexMatcher("read")).whenEmpty(403));
            }
        }
    }

    @Test
    public void field_caps_indexPattern_minus() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("index_a*,index_b*,-index_b2,-index_b3/_field_caps?fields=*", new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(index_a1, index_a2, index_a3, index_b1).at("indices").but(this.user.indexMatcher("read")).whenEmpty(200));
        }
    }

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> params() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (TestSgConfig.User user : USERS) {
            result.add(new Object[]{user, user.getDescription()});
        }
        return result;
    }

    public IndexAuthorizationReadOnlyIntTests(TestSgConfig.User user, String description) throws Exception {
        this.user = user;
    }

    public static class TestSystemIndexPlugin
    extends Plugin
    implements SystemIndexPlugin {
        public String getFeatureName() {
            return "TestSystemIndexPlugin";
        }

        public String getFeatureDescription() {
            return "Plugin that defines system indices";
        }

        public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
            String mappingJson = index_system.getFieldsMappings().with((Document)DocNode.of((String)"prefix.type", (Object)"text", (String)"prefix.fields.keyword.type", (Object)"keyword")).toJsonString();
            String mappings = "{\n \t\"_doc\": {\n \t\t\"_meta\": {\n \t\t\t\"my_test_version\": \"8.0.0\",\n \t\t\t\"managed_index_mappings_version\": 0\n \t\t},\n \t\t\"properties\": \"!!mappings-placeholder!!\"\n \t}\n }\n".replace("\"!!mappings-placeholder!!\"", mappingJson);
            return ImmutableList.of((Object)SystemIndexDescriptor.builder().setIndexPattern(".index_system*").setDescription("Test system indices").setType(SystemIndexDescriptor.Type.EXTERNAL_MANAGED).setVersionMetaKey("my_test_version").setSettings(Settings.builder().build()).setMappings(mappings).setPrimaryIndex(index_system.getName()).setOrigin("origin-with-allowed-system-indices").setAllowedElasticProductOrigins((List)ImmutableList.of((Object)"origin-with-allowed-system-indices")).setNetNew().build());
        }
    }
}

