/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

public class InternalUsersConfigApiTest {
    private static final TestSgConfig.User ADMIN_USER = new TestSgConfig.User("admin").roles(new TestSgConfig.Role("allaccess").indexPermissions("*").on("*").clusterPermissions("*"));
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().sslEnabled().user(ADMIN_USER).build();

    @Test
    public void addUser_shouldAddUserIfPasswordIsPresent() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String userName = this.randomUserName();
            DocNode userData = DocNode.of((String)"password", (Object)"pass");
            GenericRestClient.HttpResponse response = client.putJson("/_searchguard/internal_users/" + userName, userData.toJsonString(), new Header[0]);
            Assert.assertEquals((long)201L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)("Internal User " + userName + " has been created"), (Object)response.getBodyAsDocNode().get("message"));
        }
    }

    @Ignore(value="TODO why is this ignored?")
    @Test
    public void addUser_shouldFailWhenPasswordIsMissing() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String userName = this.randomUserName();
            DocNode userData = DocNode.of((String)"search_guard_roles", Arrays.asList("sgRole1", "sgRole2"), (String)"backend_roles", Arrays.asList("backendRole1", "backendRole2"), (String)"attributes", (Object)ImmutableMap.of((Object)"a", (Object)"aAttributeValue"));
            GenericRestClient.HttpResponse response = client.putJson("/_searchguard/internal_users/" + userName, userData.toJsonString(), new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
        }
    }

    @Test
    public void addUser_shouldFailWhenPasswordIsBlank() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String userName = this.randomUserName();
            DocNode userData = DocNode.of((String)"search_guard_roles", Arrays.asList("sgRole1", "sgRole2"), (String)"backend_roles", Arrays.asList("backendRole1", "backendRole2"), (String)"attributes", (Object)ImmutableMap.of((Object)"a", (Object)"aAttributeValue"), (String)"password", (Object)"");
            GenericRestClient.HttpResponse response = client.putJson("/_searchguard/internal_users/" + userName, userData.toJsonString(), new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
        }
    }

    @Test
    public void addUser_shouldSaveCorrectData() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String userName = this.randomUserName();
            DocNode userData = DocNode.of((String)"search_guard_roles", Arrays.asList("sgRole1", "sgRole2"), (String)"backend_roles", Arrays.asList("backendRole1", "backendRole2"), (String)"attributes", (Object)ImmutableMap.of((Object)"a", (Object)"aAttributeValue"), (String)"password", (Object)"pass");
            client.putJson("/_searchguard/internal_users/" + userName, userData.toJsonString(), new Header[0]);
            GenericRestClient.HttpResponse response = client.get("/_searchguard/internal_users/" + userName, new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)userData.without(new String[]{"password"}), (Object)response.getBodyAsDocNode().getAsNode("data"));
        }
    }

    @Test
    public void addUser_shouldSaveWithEmptyBackendRolesIfMissingInARequest() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String userName = this.randomUserName();
            DocNode userData = DocNode.of((String)"search_guard_roles", Arrays.asList("sgRole1", "sgRole2"), (String)"attributes", (Object)ImmutableMap.of((Object)"a", (Object)"b"), (String)"password", (Object)"pass");
            client.putJson("/_searchguard/internal_users/" + userName, userData.toJsonString(), new Header[0]);
            GenericRestClient.HttpResponse response = client.get("/_searchguard/internal_users/" + userName, new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertEquals((Object)ImmutableMap.of((Object)"attributes", (Object)ImmutableMap.of((Object)"a", (Object)"b"), (Object)"search_guard_roles", Arrays.asList("sgRole1", "sgRole2")), (Object)response.getBodyAsDocNode().getAsNode("data").toMap());
        }
    }

    @Test
    public void addUser_shouldSaveWithEmptyAttributesIfMissingInARequest() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String userName = this.randomUserName();
            DocNode userData = DocNode.of((String)"search_guard_roles", Arrays.asList("sgRole1", "sgRole2"), (String)"backend_roles", Arrays.asList("backendRole1", "backendRole2"), (String)"password", (Object)"pass");
            client.putJson("/_searchguard/internal_users/" + userName, userData.toJsonString(), new Header[0]);
            GenericRestClient.HttpResponse response = client.get("/_searchguard/internal_users/" + userName, new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertEquals((Object)ImmutableMap.of((Object)"backend_roles", Arrays.asList("backendRole1", "backendRole2"), (Object)"search_guard_roles", Arrays.asList("sgRole1", "sgRole2")), (Object)response.getBodyAsDocNode().getAsNode("data").toMap());
        }
    }

    @Test
    public void getUser_shouldFailWhenUserNotFound() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String userName = this.randomUserName();
            GenericRestClient.HttpResponse response = client.get("/_searchguard/internal_users/" + userName, new Header[0]);
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
        }
    }

    @Test
    public void getUser_shouldReturnUserData() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String userName = this.randomUserName();
            DocNode userData = DocNode.of((String)"search_guard_roles", Arrays.asList("sgRole1", "sgRole2"), (String)"backend_roles", Arrays.asList("backendRole1", "backendRole2"), (String)"attributes", (Object)ImmutableMap.of((Object)"a", (Object)"aAttributeValue"), (String)"password", (Object)"pass");
            client.putJson("/_searchguard/internal_users/" + userName, userData.toJsonString(), new Header[0]);
            GenericRestClient.HttpResponse response = client.get("/_searchguard/internal_users/" + userName, new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)userData.without(new String[]{"password"}), (Object)response.getBodyAsDocNode().getAsNode("data"));
            Assert.assertTrue((String)response.getHeaders().toString(), (boolean)response.getHeaders().stream().anyMatch(h -> h.getName().equalsIgnoreCase("ETag")));
        }
    }

    @Test
    public void addUser_concurrencyControl() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String userName = this.randomUserName();
            DocNode userData = DocNode.of((String)"password", (Object)"pass");
            GenericRestClient.HttpResponse response = client.putJson("/_searchguard/internal_users/" + userName, userData.toJsonString(), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = client.get("/_searchguard/internal_users/" + userName, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            String eTag = response.getHeaderValue("ETag");
            Assert.assertNotNull((String)response.getHeaders().toString(), (Object)eTag);
            userData = DocNode.of((String)"password", (Object)"xyz");
            response = client.putJson("/_searchguard/internal_users/" + userName, userData.toJsonString(), new Header[]{new BasicHeader("If-Match", eTag)});
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            userData = DocNode.of((String)"password", (Object)"abc");
            response = client.putJson("/_searchguard/internal_users/" + userName, userData.toJsonString(), new Header[]{new BasicHeader("If-Match", eTag)});
            Assert.assertEquals((String)response.getBody(), (long)412L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("Unable to update configuration due to concurrent modification"));
        }
    }

    @Test
    public void patchUser_concurrencyControl() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String userName = this.randomUserName();
            DocNode userData = DocNode.of((String)"password", (Object)"pass", (String)"description", (Object)"foo");
            GenericRestClient.HttpResponse response = client.putJson("/_searchguard/internal_users/" + userName, userData.toJsonString(), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = client.get("/_searchguard/internal_users/" + userName, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            String eTag = response.getHeaderValue("ETag");
            Assert.assertNotNull((String)response.getHeaders().toString(), (Object)eTag);
            userData = DocNode.of((String)"backend_roles", Arrays.asList("a", "b", "c"));
            response = client.patchJsonMerge("/_searchguard/internal_users/" + userName, (Document<?>)userData, new Header[]{new BasicHeader("If-Match", eTag)});
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            userData = DocNode.of((String)"password", (Object)"abc");
            response = client.patchJsonMerge("/_searchguard/internal_users/" + userName, userData.toJsonString(), new Header[]{new BasicHeader("If-Match", eTag)});
            Assert.assertEquals((String)response.getBody(), (long)412L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("Unable to update configuration due to concurrent modification"));
            response = client.get("/_searchguard/internal_users/" + userName, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (Object)DocNode.of((String)"description", (Object)"foo", (String)"backend_roles", Arrays.asList("a", "b", "c")).toMap(), (Object)response.getBodyAsDocNode().get("data"));
        }
    }

    @Test
    public void deleteUser_shouldInformThatUserNotFound() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String userName = this.randomUserName();
            GenericRestClient.HttpResponse response = client.delete("/_searchguard/internal_users/" + userName, new Header[0]);
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)("Internal User " + userName + " does not exist"), (Object)response.getBodyAsDocNode().get("error", new String[]{"message"}));
        }
    }

    @Test
    public void deleteUser_shouldDeleteUser() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String userName = this.randomUserName();
            this.userExists(client, userName);
            GenericRestClient.HttpResponse response = client.delete("/_searchguard/internal_users/" + userName, new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
        }
    }

    private void userExists(GenericRestClient client, String userName) throws Exception {
        GenericRestClient.HttpResponse response = client.putJson("/_searchguard/internal_users/" + userName, this.validUserData().toJsonString(), new Header[0]);
        Assert.assertEquals((long)201L, (long)response.getStatusCode());
    }

    private DocNode validUserData() {
        return DocNode.of((String)"search_guard_roles", Arrays.asList("sgRole1", "sgRole2"), (String)"backend_roles", Arrays.asList("backendRole1", "backendRole2"), (String)"attributes", (Object)ImmutableMap.of((Object)"a", (Object)"aAttributeValue"), (String)"password", (Object)"pass");
    }

    private String randomUserName() {
        return "userName_" + String.valueOf(UUID.randomUUID());
    }
}

