/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.variables;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.Map;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;

public class ConfigVarIntegrationTest {
    private static final Logger log = LogManager.getLogger(ConfigVarIntegrationTest.class);
    public static final String VALUE_PLAIN = "value_plain_for_index_name";
    public static final String VALUE_BCRYPT = "BCrypt_user_password";
    private static TestSgConfig.User USER_BCRYPT_ADMIN = new TestSgConfig.User("bcrypt_admin").passwordExpression("#{var:plain_password|bcrypt}").roles(TestSgConfig.Role.ALL_ACCESS);
    private static TestSgConfig.User USER_TEST = new TestSgConfig.User("test").roles(new TestSgConfig.Role("var").clusterPermissions("*").indexPermissions("*").on("#{var:index_var_plain}"));
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().var("index_var_plain", () -> "value_plain_for_index_name").var("plain_password", () -> "BCrypt_user_password").users(USER_TEST, USER_BCRYPT_ADMIN).enterpriseModulesEnabled().sslEnabled().build();

    @Test
    public void shouldUsePlainVariableValue() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(USER_TEST, new Header[0]);){
            Awaitility.await((String)"create document ").until(() -> {
                GenericRestClient.HttpResponse response = client.postJson("/value_plain_for_index_name/_doc", (Map<String, Object>)DocNode.EMPTY, new Header[0]);
                log.debug("Response status code '{}' and body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
                return 201 == response.getStatusCode();
            });
        }
    }

    @Test
    public void shouldUseBcryptPipeFunction() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(USER_BCRYPT_ADMIN.getName(), VALUE_BCRYPT, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/any_index/_doc", (Map<String, Object>)DocNode.EMPTY, new Header[0]);
            log.debug("Response status code '{}' and body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
        }
    }
}

