/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.Objects;
import org.apache.http.Header;

public class ConfigurationUpdater {
    private final LocalCluster.Embedded localCluster;
    private final TestSgConfig.User user;

    public ConfigurationUpdater(LocalCluster.Embedded localCluster, TestSgConfig.User user) {
        this.localCluster = Objects.requireNonNull(localCluster, "Local cluster must not be null");
        this.user = Objects.requireNonNull(user, "User is required");
    }

    public <T> T callWithRole(TestSgConfig.Role desiredRole, ClientCallable<T> clientCallable) throws Exception {
        return (T)this.localCluster.callAndRestoreConfig(CType.ROLES, () -> {
            this.localCluster.updateRolesConfig(desiredRole);
            try (GenericRestClient client = this.localCluster.getRestClient(this.user, new Header[0]);){
                Object t = clientCallable.callClient(client);
                return t;
            }
        });
    }

    public <T> T callWithMapping(TestSgConfig.RoleMapping roleMapping, ClientCallable<T> clientCallable) throws Exception {
        return (T)this.localCluster.callAndRestoreConfig(CType.ROLESMAPPING, () -> {
            this.localCluster.updateRolesMappingsConfig(roleMapping);
            try (GenericRestClient client = this.localCluster.getRestClient(this.user, new Header[0]);){
                Object t = clientCallable.callClient(client);
                return t;
            }
        });
    }

    @FunctionalInterface
    public static interface ClientCallable<T> {
        public T callClient(GenericRestClient var1) throws Exception;
    }
}

