/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.NodeSettingsSupplier;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.EsDownload;
import com.floragunn.searchguard.test.helper.cluster.EsInstallation;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchguard.test.helper.cluster.LocalEsCluster;
import com.floragunn.searchguard.test.helper.cluster.SgPluginPackage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;

public class ExternalProcessEsCluster
extends LocalEsCluster {
    private static final Logger log = LogManager.getLogger(ExternalProcessEsCluster.class);
    private static final ExecutorService logConsumptionExecutorService = Executors.newCachedThreadPool();
    private static final ExecutorService quickActionExecutorService = new ThreadPoolExecutor(0, 10, 5L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
    private boolean started;
    protected final File esDir;
    private EsInstallation esInstallation;
    private final List<Node> allNodes = new ArrayList<Node>();
    private final List<Node> masterNodes = new ArrayList<Node>();
    private final List<Node> dataNodes = new ArrayList<Node>();
    private final List<Node> clientNodes = new ArrayList<Node>();
    private final TestSgConfig testSgConfig;
    private TestCertificates installedTestCertificates;

    public ExternalProcessEsCluster(String clusterName, ClusterConfiguration clusterConfiguration, NodeSettingsSupplier nodeSettingsSupplier, TestCertificates testCertificates, TestSgConfig testSgConfig) {
        super(clusterName, clusterConfiguration, nodeSettingsSupplier, testCertificates);
        this.esDir = new File(this.clusterHomeDir, "es");
        this.testSgConfig = testSgConfig;
    }

    @Override
    public void start() throws Exception {
        String esVersion = this.getEsVersion();
        CompletableFuture<EsInstallation> installationFuture = EsDownload.get(esVersion).extractAsync(this.esDir);
        CompletableFuture<SgPluginPackage> pluginFuture = SgPluginPackage.get();
        ExternalProcessEsCluster.failFastAllOf(installationFuture, pluginFuture).get();
        this.esInstallation = installationFuture.get();
        this.esInstallation.ensureKeystore();
        this.esInstallation.installPlugin(pluginFuture.get().getFile());
        this.esInstallation.appendConfig("jvm.options", "-Xms1g");
        this.esInstallation.appendConfig("jvm.options", "-Xmx1g");
        this.esInstallation.appendConfig("elasticsearch.yml", "cluster.routing.allocation.disk.threshold_enabled: false\ningest.geoip.downloader.enabled: false\nxpack.security.enabled: false\nindices.lifecycle.history_index_enabled: false\nslm.history_index_enabled: false\nsearchguard.background_init_if_sgindex_not_exist: false");
        this.esInstallation.appendConfig("log4j2.properties", "logger.sg.name = com.floragunn.searchguard.authz\nlogger.sg.level = trace");
        this.installedTestCertificates = this.testCertificates.at(this.esInstallation.getConfigPath());
        this.started = true;
        super.start();
    }

    protected CompletableFuture<Node> startNode(ClusterConfiguration.NodeSettings nodeSettings, int httpPort, int transportPort) {
        CompletableFuture<Node> result = new CompletableFuture<Node>();
        quickActionExecutorService.submit(() -> {
            try {
                File nodeHomeDir = new File(this.clusterHomeDir, nodeSettings.name);
                nodeHomeDir.mkdir();
                nodeHomeDir.deleteOnExit();
                Settings settings = ExternalProcessEsCluster.joinedSettings(this.nodeSettingsSupplier.get(0), this.installedTestCertificates.getSgSettings(), this.getMinimalEsSettings());
                long startupTime = System.currentTimeMillis();
                Process process = this.esInstallation.startProcess(httpPort, transportPort, nodeHomeDir, settings, nodeSettings);
                try {
                    new Node(nodeSettings, process, httpPort, transportPort, result, this, startupTime);
                }
                catch (Throwable t) {
                    process.destroyForcibly();
                    result.completeExceptionally(t);
                }
            }
            catch (EsDownload.EsInstallationUnavailableException e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void destroy() {
        this.stop();
        this.clientNodes.clear();
        this.dataNodes.clear();
        this.masterNodes.clear();
        this.allNodes.clear();
        try {
            FileUtils.deleteDirectory((File)this.clusterHomeDir);
        }
        catch (IOException e) {
            log.warn("Error while deleting " + String.valueOf(this.clusterHomeDir), (Throwable)e);
        }
    }

    public String toString() {
        return "external_process_cluster" + String.valueOf(this.allNodes);
    }

    private String getEsVersion() {
        String version = Version.CURRENT.toString();
        if (version.equals("9.0.0")) {
            return "9.0.0-beta1";
        }
        return version;
    }

    @Override
    public List<? extends LocalEsCluster.Node> getAllNodes() {
        return this.allNodes;
    }

    @Override
    public List<? extends LocalEsCluster.Node> clientNodes() {
        return this.clientNodes;
    }

    @Override
    public List<? extends LocalEsCluster.Node> dataNodes() {
        return this.dataNodes;
    }

    @Override
    public List<? extends LocalEsCluster.Node> masterNodes() {
        return this.masterNodes;
    }

    @Override
    public void waitForGreenCluster() throws Exception {
        try (GenericRestClient client = this.masterNode().getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.get("/_cluster/health?wait_for_status=green&timeout=30s", new Header[0]);
            if (response.getStatusCode() != 200) {
                throw new Exception("/_cluster/health request failed: " + String.valueOf(response));
            }
            if (!"green".equals(response.getBodyAsDocNode().getAsString("status"))) {
                throw new Exception("Cluster is not green: " + String.valueOf(response));
            }
        }
    }

    @Override
    protected void destroyNodes() {
        this.allNodes.clear();
        this.masterNodes.clear();
        this.dataNodes.clear();
        this.clientNodes.clear();
    }

    private static CompletableFuture<?> failFastAllOf(CompletableFuture<?> ... futures) {
        CompletableFuture failure = new CompletableFuture();
        for (CompletableFuture<?> f : futures) {
            f.exceptionally(ex -> {
                failure.completeExceptionally((Throwable)ex);
                return null;
            });
        }
        failure.exceptionally(ex -> {
            for (CompletableFuture future : futures) {
                future.cancel(true);
            }
            return null;
        });
        return CompletableFuture.anyOf(failure, CompletableFuture.allOf(futures));
    }

    public static class Node
    implements LocalEsCluster.Node {
        private final ClusterConfiguration.NodeSettings nodeSettings;
        private final Process process;
        private final CompletableFuture<Node> onReady;
        private boolean onReadyCompleted;
        private final Instant started = Instant.now();
        private final InetSocketAddress transportAddress;
        private final InetSocketAddress httpAddress;
        private final String name;
        private final ExternalProcessEsCluster cluster;
        private final long startupTime;
        private boolean ready = false;

        Node(ClusterConfiguration.NodeSettings nodeSettings, Process process, int httpPort, int transportPort, CompletableFuture<Node> onReady, ExternalProcessEsCluster cluster, long startupTime) throws UnknownHostException {
            this.nodeSettings = nodeSettings;
            this.name = nodeSettings.name;
            this.process = process;
            this.onReady = onReady;
            this.transportAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), transportPort);
            this.httpAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), httpPort);
            this.cluster = cluster;
            this.startupTime = startupTime;
            logConsumptionExecutorService.submit(() -> {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        System.out.println(line);
                        this.processLogLine(line);
                    }
                    if (!this.onReadyCompleted) {
                        this.completeFutureExceptionally(new Exception("Startup has failed"));
                    }
                }
                catch (IOException e) {
                    if ("Stream closed".equals(e.getMessage())) {
                        if (this.onReadyCompleted) {
                            log.info("Output stream of " + String.valueOf(this) + " was closed");
                        } else {
                            log.error("Output stream of " + String.valueOf(this) + " was closed before startup was finished", (Throwable)e);
                            this.completeFutureExceptionally(e);
                        }
                    } else {
                        log.error("Error while monitoring output of " + String.valueOf(this), (Throwable)e);
                        this.completeFutureExceptionally(e);
                    }
                }
                catch (Throwable t) {
                    log.error("Error while monitoring output of " + String.valueOf(this), t);
                    this.completeFutureExceptionally(t);
                }
                finally {
                    this.stop();
                }
            });
            logConsumptionExecutorService.submit(() -> {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    while ((line = reader.readLine()) != null) {
                        System.out.println(line);
                    }
                    if (!this.onReadyCompleted) {
                        this.completeFutureExceptionally(new Exception("Startup has failed"));
                    }
                    this.stop();
                }
                catch (IOException e) {
                    if ("Stream closed".equals(e.getMessage())) {
                        if (this.onReadyCompleted) {
                            log.info("Error stream of " + String.valueOf(this) + " was closed");
                        } else {
                            log.error("Error stream of " + String.valueOf(this) + " was closed before startup was finished", (Throwable)e);
                            this.completeFutureExceptionally(e);
                        }
                    } else {
                        log.error("Error while monitoring output of " + String.valueOf(this), (Throwable)e);
                        this.completeFutureExceptionally(e);
                    }
                }
                catch (Throwable t) {
                    log.error("Error while monitoring output of " + String.valueOf(this), t);
                    this.completeFutureExceptionally(t);
                }
                finally {
                    this.stop();
                }
            });
            if (nodeSettings.masterNode) {
                cluster.masterNodes.add(this);
            } else if (nodeSettings.dataNode) {
                cluster.dataNodes.add(this);
            } else {
                cluster.clientNodes.add(this);
            }
            cluster.allNodes.add(this);
        }

        @Override
        public InetSocketAddress getTransportAddress() {
            return this.transportAddress;
        }

        @Override
        public InetSocketAddress getHttpAddress() {
            return this.httpAddress;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public boolean isRunning() {
            return this.ready;
        }

        @Override
        public synchronized void stop() {
            if (this.process.isAlive()) {
                log.info("Stopping " + String.valueOf(this));
                this.process.destroyForcibly();
            }
            if (!this.onReadyCompleted) {
                this.completeFutureExceptionally(new Exception("stop() was called"));
            }
        }

        @Override
        public String getClusterName() {
            return this.cluster.clusterName;
        }

        @Override
        public TestCertificates getTestCertificates() {
            return this.cluster.testCertificates;
        }

        @Override
        public Consumer<GenericRestClient.RequestInfo> getRequestInfoConsumer() {
            return r -> {};
        }

        private synchronized void completeFuture() {
            if (!this.onReadyCompleted) {
                this.onReady.complete(this);
                this.onReadyCompleted = true;
            }
        }

        private synchronized void completeFutureExceptionally(Throwable t) {
            if (!this.onReadyCompleted) {
                this.onReady.completeExceptionally(t);
                this.onReadyCompleted = true;
                if (this.process.isAlive()) {
                    log.info("Stopping " + String.valueOf(this));
                    this.process.destroyForcibly();
                }
            }
        }

        private void processLogLine(String line) {
            if (!this.ready) {
                if (this.nodeSettings.masterNode && this.cluster.testSgConfig != null && line.contains(".searchguard index does not exist yet, use sgctl to initialize the cluster.")) {
                    quickActionExecutorService.submit(() -> {
                        log.info("Wating for components");
                        LocalCluster.waitForComponents((Collection<String>)ImmutableSet.of((Object)"config_var_storage"), this);
                        log.info("Setting initial Search Guard configuration");
                        try (GenericRestClient client = this.getAdminCertRestClient();){
                            this.cluster.testSgConfig.initByConfigRestApi(client);
                            log.info("Configuration initialized");
                        }
                        catch (Exception e) {
                            log.error("Error while initializing configuration", (Throwable)e);
                            this.completeFutureExceptionally(e);
                            this.stop();
                        }
                    });
                } else if (line.contains("Search Guard configuration has been successfully initialized")) {
                    quickActionExecutorService.submit(() -> {
                        for (int i = 0; i < 10000; ++i) {
                            try {
                                Thread.sleep(10L);
                                try (GenericRestClient client = this.getRestClient(new Header[0]);){
                                    GenericRestClient.HttpResponse response = client.get("/", new Header[0]);
                                    if (response.getStatusCode() == 503) continue;
                                    this.ready = true;
                                    log.info("Startup of {} completed after {} seconds", (Object)this, (Object)((System.currentTimeMillis() - this.startupTime) / 1000L));
                                    this.completeFuture();
                                    return;
                                }
                                catch (Exception e) {
                                    this.completeFutureExceptionally(e);
                                    this.stop();
                                    return;
                                }
                            }
                            catch (InterruptedException e) {
                                this.completeFutureExceptionally(e);
                                this.stop();
                                return;
                            }
                        }
                        this.completeFutureExceptionally(new Exception("Node startup has timed out"));
                    });
                } else if (line.contains("BindHttpException")) {
                    this.cluster.portCollisionDetected = true;
                } else if (this.started.compareTo(Instant.now().minus(1L, ChronoUnit.MINUTES)) < 0) {
                    this.completeFutureExceptionally(new Exception("Node startup has timed out"));
                }
            }
        }

        public String toString() {
            return this.cluster.clusterName + "/" + this.name;
        }
    }
}

