/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.fluent.collections.CheckList;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.SearchGuardModule;
import com.floragunn.searchguard.SearchGuardModulesRegistry;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestAlias;
import com.floragunn.searchguard.test.TestComponentTemplate;
import com.floragunn.searchguard.test.TestDataStream;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestIndexTemplate;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.ExternalProcessEsCluster;
import com.floragunn.searchguard.test.helper.cluster.JvmEmbeddedEsCluster;
import com.floragunn.searchguard.test.helper.cluster.LocalEsCluster;
import com.floragunn.searchguard.test.helper.cluster.MinimumSearchGuardSettingsSupplierFactory;
import com.floragunn.searchguard.test.helper.cluster.NestedValueMap;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.PluginAwareNode;
import org.elasticsearch.plugins.Plugin;
import org.junit.rules.ExternalResource;

public class LocalCluster
extends ExternalResource
implements AutoCloseable,
EsClientProvider {
    static final boolean USE_EXTERNAL_PROCESS_CLUSTER_BY_DEFAULT = "true".equalsIgnoreCase(System.getProperty("sg.tests.use_ep_cluster"));
    private static final Logger log = LogManager.getLogger(LocalCluster.class);
    private static final ImmutableSet<String> MODULES_DISABLED_BY_DEFAULT;
    protected static final AtomicLong num;
    protected final String resourceFolder;
    private final List<Class<? extends Plugin>> plugins;
    private final ClusterConfiguration clusterConfiguration;
    private final TestSgConfig testSgConfig;
    private Settings nodeOverride;
    private final String clusterName;
    private final MinimumSearchGuardSettingsSupplierFactory minimumSearchGuardSettingsSupplierFactory;
    private final TestCertificates testCertificates;
    private final List<LocalCluster> clusterDependencies;
    private final Map<String, LocalCluster> remotes;
    private final List<TestIndex> testIndices;
    private final List<TestDataStream> testDataStreams;
    private final List<TestAlias> testAliases;
    private final List<TestComponentTemplate> componentTemplates;
    private final List<TestIndexTemplate> indexTemplates;
    private final List<GenericRestClient.RequestInfo> executedRequests;
    private final boolean externalProcessCluster;
    private final ImmutableList<String> waitForComponents;
    private volatile LocalEsCluster localEsCluster;

    private LocalCluster(String clusterName, String resourceFolder, TestSgConfig testSgConfig, Settings nodeOverride, ClusterConfiguration clusterConfiguration, List<Class<? extends Plugin>> plugins, TestCertificates testCertificates, List<LocalCluster> clusterDependencies, Map<String, LocalCluster> remotes, List<TestIndex> testIndices, List<TestDataStream> testDataStreams, List<TestAlias> testAliases, List<TestComponentTemplate> componentTemplates, List<TestIndexTemplate> indexTemplates, boolean logRequests, boolean externalProcessCluster, ImmutableList<String> waitForComponents) {
        IndexMetadata.builder((String)"abc");
        this.resourceFolder = resourceFolder;
        this.plugins = plugins;
        this.clusterConfiguration = clusterConfiguration;
        this.testSgConfig = testSgConfig;
        this.nodeOverride = nodeOverride;
        this.clusterName = clusterName;
        this.minimumSearchGuardSettingsSupplierFactory = new MinimumSearchGuardSettingsSupplierFactory(resourceFolder, testCertificates == null);
        this.testCertificates = testCertificates;
        this.remotes = remotes;
        this.clusterDependencies = clusterDependencies;
        this.testIndices = testIndices;
        this.testDataStreams = testDataStreams;
        this.testAliases = testAliases;
        this.componentTemplates = componentTemplates;
        this.indexTemplates = indexTemplates;
        this.executedRequests = logRequests ? new ArrayList(1000) : null;
        this.externalProcessCluster = externalProcessCluster || USE_EXTERNAL_PROCESS_CLUSTER_BY_DEFAULT;
        this.waitForComponents = waitForComponents;
    }

    public void before() throws Throwable {
        if (this.localEsCluster == null) {
            for (LocalCluster localCluster : this.clusterDependencies) {
                if (localCluster.isStarted()) continue;
                localCluster.before();
            }
            for (Map.Entry entry : this.remotes.entrySet()) {
                InetSocketAddress transportAddress = ((LocalCluster)entry.getValue()).localEsCluster.masterNode().getTransportAddress();
                this.nodeOverride = Settings.builder().put(this.nodeOverride).putList("cluster.remote." + (String)entry.getKey() + ".seeds", new String[]{transportAddress.getHostString() + ":" + transportAddress.getPort()}).build();
            }
            this.start();
        }
    }

    protected void after() {
        if (this.executedRequests != null && !this.executedRequests.isEmpty()) {
            System.out.println("\n=========\nExecuted requests:\n" + this.executedRequests.stream().map(r -> r.toString()).collect(Collectors.joining("\n\n\n")));
        }
        if (this.localEsCluster != null && this.localEsCluster.isStarted()) {
            try {
                Thread.sleep(1234L);
                this.localEsCluster.destroy();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.localEsCluster = null;
            }
        }
    }

    @Override
    public void close() {
        if (this.executedRequests != null && !this.executedRequests.isEmpty()) {
            log.info("Executed requests:\n{}", (Object)this.executedRequests.stream().map(r -> r.toString()).collect(Collectors.joining("\n\n\n")));
        }
        if (this.localEsCluster != null && this.localEsCluster.isStarted()) {
            try {
                Thread.sleep(100L);
                this.localEsCluster.destroy();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.localEsCluster = null;
            }
        }
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public TestCertificates getTestCertificates() {
        return this.testCertificates;
    }

    @Override
    public InetSocketAddress getHttpAddress() {
        return this.localEsCluster.clientNode().getHttpAddress();
    }

    @Override
    public InetSocketAddress getTransportAddress() {
        return this.localEsCluster.clientNode().getTransportAddress();
    }

    public List<? extends LocalEsCluster.Node> nodes() {
        return this.localEsCluster.getAllNodes();
    }

    public LocalEsCluster.Node getNodeByName(String name) {
        return this.localEsCluster.getNodeByName(name);
    }

    public LocalEsCluster.Node getRandomClientNode() {
        return this.localEsCluster.randomClientNode();
    }

    private static byte[] stringToUtfByteArray(String config) {
        try {
            return config.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot convert configuration string to byte array", e);
        }
    }

    private static String loadConfig(CType<?> configType, Client client, String searchGuardIndex) {
        GetResponse getResponse = (GetResponse)client.get(new GetRequest(searchGuardIndex, configType.toLCString())).actionGet();
        if (getResponse.isExists()) {
            return new String(Base64.getDecoder().decode(String.valueOf(getResponse.getSource().get(configType.toLCString()))));
        }
        return null;
    }

    public boolean isStarted() {
        return this.localEsCluster != null;
    }

    public Random getRandom() {
        return this.localEsCluster.random;
    }

    public List<DocNode> documents(TestIndex ... indices) throws Exception {
        try (GenericRestClient client = this.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.get("/" + Stream.of(indices).map(TestIndex::getName).collect(Collectors.joining(",")) + "/_search?size=10000", new Header[0]);
            if (response.getStatusCode() == 404) {
                ImmutableList immutableList = ImmutableList.empty();
                return immutableList;
            }
            ImmutableList immutableList = response.getBodyAsDocNode().getAsNode("hits").getAsListOfNodes("hits");
            return immutableList;
        }
    }

    protected void start() {
        try {
            if (this.externalProcessCluster) {
                this.startExternalProcessEsCluster();
            } else {
                this.startEmbeddedEsCluster();
            }
            this.waitForComponents();
        }
        catch (RuntimeException e) {
            if (this.localEsCluster != null) {
                this.localEsCluster.destroy();
            }
            throw e;
        }
    }

    protected JvmEmbeddedEsCluster startEmbeddedEsCluster() {
        try {
            JvmEmbeddedEsCluster result = new JvmEmbeddedEsCluster(this.clusterName, this.clusterConfiguration, this.minimumSearchGuardSettingsSupplierFactory.minimumSearchGuardSettings(this.nodeOverride), this.plugins, this.testCertificates);
            result.start();
            this.localEsCluster = result;
            this.createTemplates();
            Client client = result.clientNode().getInternalNodeClient();
            for (TestIndex index : this.testIndices) {
                index.create(client);
            }
            for (TestAlias alias : this.testAliases) {
                alias.create(client);
            }
            if (this.testSgConfig != null) {
                this.initSearchGuardIndex(result, this.testSgConfig);
            }
            return result;
        }
        catch (Exception e) {
            log.error("Local ES cluster start failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected ExternalProcessEsCluster startExternalProcessEsCluster() {
        try {
            ExternalProcessEsCluster result = new ExternalProcessEsCluster(this.clusterName, this.clusterConfiguration, this.minimumSearchGuardSettingsSupplierFactory.minimumSearchGuardSettings(this.nodeOverride), this.testCertificates, this.testSgConfig);
            result.start();
            this.localEsCluster = result;
            this.createTemplates();
            try (GenericRestClient client = this.getAdminCertRestClient();){
                for (TestIndex index : this.testIndices) {
                    index.create(client);
                }
                for (TestDataStream dataStream : this.testDataStreams) {
                    dataStream.create(client);
                }
                for (TestAlias alias : this.testAliases) {
                    alias.create(client);
                }
            }
            return result;
        }
        catch (Exception e) {
            log.error("Local ES cluster start failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void createTemplates() throws Exception {
        try (GenericRestClient client = this.getAdminCertRestClient();){
            for (TestComponentTemplate testComponentTemplate : this.componentTemplates) {
                testComponentTemplate.create(client);
            }
            for (TestIndexTemplate testIndexTemplate : this.indexTemplates) {
                testIndexTemplate.create(client);
            }
        }
    }

    protected void waitForComponents() {
        log.debug("waitForComponents: {}", this.waitForComponents);
        LocalCluster.waitForComponents(this.waitForComponents, this);
    }

    private void initSearchGuardIndex(JvmEmbeddedEsCluster jvmEmbeddedEsCluster, TestSgConfig testSgConfig) {
        log.info("Initializing Search Guard index");
        PrivilegedConfigClient client = PrivilegedConfigClient.adapt((Client)jvmEmbeddedEsCluster.clientNode().getInternalNodeClient());
        testSgConfig.initIndex((Client)client);
    }

    @Override
    public Consumer<GenericRestClient.RequestInfo> getRequestInfoConsumer() {
        return this.executedRequests != null ? r -> this.executedRequests.add((GenericRestClient.RequestInfo)r) : null;
    }

    public static void waitForComponents(Collection<String> waitForComponents, EsClientProvider esClientProvider) {
        if (waitForComponents.isEmpty()) {
            return;
        }
        Instant timeoutReachedAt = Instant.now().plus(Duration.ofSeconds(30L));
        GenericRestClient.HttpResponse lastErrorResponse = null;
        try (GenericRestClient client = esClientProvider.getAdminCertRestClient();){
            CheckList componentsCheckList = CheckList.create((Set)ImmutableSet.of(waitForComponents));
            while (!componentsCheckList.isComplete()) {
                for (String component : componentsCheckList.getUncheckedElements()) {
                    GenericRestClient.HttpResponse response = client.get("/_searchguard/component/" + component + "/_health", new Header[0]);
                    if (response.getStatusCode() == 200) {
                        String value = (String)response.getBodyAsDocNode().findSingleValueByJsonPath("$.components[?(@.name==\"" + component + "\")].state", String.class);
                        log.debug("State of component {}: {}", (Object)component, (Object)value);
                        if (value != null && value.contains("INITIALIZED")) {
                            componentsCheckList.check((Object)component);
                            continue;
                        }
                        lastErrorResponse = response;
                        continue;
                    }
                    lastErrorResponse = response;
                }
                if (componentsCheckList.isComplete()) {
                    break;
                }
                if (Instant.now().isAfter(timeoutReachedAt)) {
                    throw new RuntimeException("Component did not become initialized:\n" + String.valueOf(componentsCheckList) + "\n" + String.valueOf(lastErrorResponse));
                }
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        System.setProperty("sg.default_init.dir", new File("./sgconfig").getAbsolutePath());
        MODULES_DISABLED_BY_DEFAULT = ImmutableSet.of((Object)"com.floragunn.searchguard.authtoken.AuthTokenModule", (Object)"com.floragunn.signals.SignalsModule");
        num = new AtomicLong();
    }

    public static class Embedded
    extends LocalCluster {
        private volatile JvmEmbeddedEsCluster jvmEmbeddedEsCluster;

        public Embedded(String clusterName, String resourceFolder, TestSgConfig testSgConfig, Settings nodeOverride, ClusterConfiguration clusterConfiguration, List<Class<? extends Plugin>> plugins, TestCertificates testCertificates, List<LocalCluster> clusterDependencies, Map<String, LocalCluster> remotes, List<TestIndex> testIndices, List<TestDataStream> testDataStreams, List<TestAlias> testAliases, List<TestComponentTemplate> componentTemplates, List<TestIndexTemplate> indexTemplates, boolean logRequests, ImmutableList<String> waitForComponents) {
            super(clusterName, resourceFolder, testSgConfig, nodeOverride, clusterConfiguration, plugins, testCertificates, clusterDependencies, remotes, testIndices, testDataStreams, testAliases, componentTemplates, indexTemplates, logRequests, true, waitForComponents);
        }

        @Override
        protected void start() {
            this.jvmEmbeddedEsCluster = this.startEmbeddedEsCluster();
            this.waitForComponents();
        }

        public Client getInternalNodeClient() {
            return this.jvmEmbeddedEsCluster.clientNode().getInternalNodeClient();
        }

        public Client getPrivilegedInternalNodeClient() {
            return PrivilegedConfigClient.adapt((Client)this.getInternalNodeClient());
        }

        public <X> X getInjectable(Class<X> clazz) {
            return this.jvmEmbeddedEsCluster.getInjectable(clazz);
        }

        private String getConfigIndexName() {
            ConfigurationRepository configRepository = this.getInjectable(ConfigurationRepository.class);
            return configRepository.getEffectiveSearchGuardIndex();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T callAndRestoreConfig(CType<?> configTypeToRestore, Callable<T> callable) throws Exception {
            PrivilegedConfigClient client = PrivilegedConfigClient.adapt((Client)this.getInternalNodeClient());
            String searchGuardIndex = this.getConfigIndexName();
            String configurationBackup = LocalCluster.loadConfig(configTypeToRestore, (Client)client, searchGuardIndex);
            try {
                T t = callable.call();
                return t;
            }
            finally {
                Embedded.writeConfigToIndexAndReload((Client)client, configTypeToRestore, searchGuardIndex, configurationBackup);
            }
        }

        public void updateSgConfig(CType<?> configType, String key, Map<String, Object> value) {
            try {
                PrivilegedConfigClient client = PrivilegedConfigClient.adapt((Client)this.getInternalNodeClient());
                log.info("Updating config {}.{}:{}", configType, (Object)key, value);
                String searchGuardIndex = this.getConfigIndexName();
                String jsonDoc = LocalCluster.loadConfig(configType, (Client)client, searchGuardIndex);
                NestedValueMap config = NestedValueMap.fromJsonString(jsonDoc);
                if (Strings.isNullOrEmpty((String)key)) {
                    config.putAllFromAnyMap(value);
                } else {
                    config.put(key, value);
                }
                if (log.isTraceEnabled()) {
                    log.trace("Updated config: " + String.valueOf(config));
                }
                Embedded.writeConfigToIndexAndReload((Client)client, configType, searchGuardIndex, config.toJsonString());
            }
            catch (DocumentParseException | UnexpectedDocumentStructureException | IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void updateSgConfig(CType<?> configType, Map<String, Object> value) {
            this.updateSgConfig(configType, null, value);
        }

        public void updateRolesConfig(TestSgConfig.Role ... roles) {
            NestedValueMap nestedValueMap = new NestedValueMap();
            Arrays.stream(roles).map(TestSgConfig.Role::toJsonMap).forEach(nestedValueMap::putAllFromAnyMap);
            this.updateSgConfig(CType.ROLES, nestedValueMap);
        }

        public void updateRolesMappingsConfig(TestSgConfig.RoleMapping ... mappings) {
            NestedValueMap nestedValueMap = new NestedValueMap();
            Arrays.stream(mappings).map(TestSgConfig.RoleMapping::toJsonMap).forEach(nestedValueMap::putAllFromAnyMap);
            this.updateSgConfig(CType.ROLESMAPPING, nestedValueMap);
        }

        public List<JvmEmbeddedEsCluster.Node> nodes() {
            return this.jvmEmbeddedEsCluster.getAllNodes();
        }

        public PluginAwareNode node() {
            return ((JvmEmbeddedEsCluster.Node)this.jvmEmbeddedEsCluster.masterNode()).esNode();
        }

        private static void writeConfigToIndexAndReload(Client client, CType<?> configType, String searchGuardIndex, String config) {
            if (config != null) {
                DocWriteResponse response = (DocWriteResponse)client.index(((IndexRequest)new IndexRequest(searchGuardIndex).id(configType.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{configType.toLCString(), BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(LocalCluster.stringToUtfByteArray(config)))})).actionGet();
                if (!ImmutableSet.of((Object)DocWriteResponse.Result.UPDATED, (Object)DocWriteResponse.Result.CREATED).contains((Object)response.getResult())) {
                    throw new RuntimeException("Updated failed " + String.valueOf(response));
                }
            } else {
                client.delete((DeleteRequest)new DeleteRequest(searchGuardIndex).id(configType.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
            }
            ConfigUpdateResponse configUpdateResponse = (ConfigUpdateResponse)client.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(CType.lcStringValues().toArray(new String[0]))).actionGet();
            if (configUpdateResponse.hasFailures()) {
                throw new RuntimeException("ConfigUpdateResponse produced failures: " + String.valueOf(configUpdateResponse.failures()));
            }
        }
    }

    public static class Builder {
        private final Settings.Builder nodeOverrideSettingsBuilder = Settings.builder();
        private final Set<String> disabledModules = new HashSet<String>((Collection<String>)MODULES_DISABLED_BY_DEFAULT);
        private Map<String, LocalCluster> remoteClusters = new HashMap<String, LocalCluster>();
        private List<LocalCluster> clusterDependencies = new ArrayList<LocalCluster>();
        private List<TestIndex> testIndices = new ArrayList<TestIndex>();
        private List<TestDataStream> testDataStreams = new ArrayList<TestDataStream>();
        private List<TestAlias> testAliases = new ArrayList<TestAlias>();
        private List<TestComponentTemplate> testComponentTemplates = new ArrayList<TestComponentTemplate>();
        private List<TestIndexTemplate> testIndexTemplates = new ArrayList<TestIndexTemplate>();
        private String resourceFolder;
        private ClusterConfiguration clusterConfiguration = ClusterConfiguration.DEFAULT;
        private TestSgConfig testSgConfig = new TestSgConfig().resources("/");
        private String clusterName = "local_cluster";
        private TestCertificates testCertificates;
        private boolean enterpriseModulesEnabled;
        private boolean logRequests;
        private boolean externalProcessCluster;
        private ImmutableList<String> waitForComponents = ImmutableList.empty();

        public Builder sslEnabled() {
            this.sslEnabled(TestCertificates.builder().ca("CN=root.ca.example.com,OU=SearchGuard,O=SearchGuard").addNodes("CN=node-0.example.com,OU=SearchGuard,O=SearchGuard").addClients("CN=client-0.example.com,OU=SearchGuard,O=SearchGuard").addAdminClients("CN=admin-0.example.com,OU=SearchGuard,O=SearchGuard").build());
            return this;
        }

        public Builder sslEnabled(TestCertificates certificatesContext) {
            this.testCertificates = certificatesContext;
            return this;
        }

        public Builder dependsOn(Object object) {
            if (object == null) {
                throw new IllegalStateException("Dependency not fulfilled");
            }
            return this;
        }

        public Builder resources(String resourceFolder) {
            this.resourceFolder = resourceFolder;
            this.testSgConfig.resources(resourceFolder);
            return this;
        }

        public Builder clusterConfiguration(ClusterConfiguration clusterConfiguration) {
            this.clusterConfiguration = clusterConfiguration;
            return this;
        }

        public Builder singleNode() {
            this.clusterConfiguration = ClusterConfiguration.SINGLENODE;
            return this;
        }

        public Builder doNotInitializeSgConfig() {
            this.testSgConfig = null;
            return this;
        }

        public Builder sgConfig(TestSgConfig testSgConfig) {
            this.testSgConfig = testSgConfig;
            return this;
        }

        public Builder ignoreUnauthorizedIndices(boolean ignoreUnauthorizedIndices) {
            this.testSgConfig.ignoreUnauthorizedIndices(ignoreUnauthorizedIndices);
            return this;
        }

        public Builder authzDebug(boolean debug) {
            this.testSgConfig.authzDebug(debug);
            return this;
        }

        public Builder roleMappingResolutionMode(String roleMappingResolutionMode) {
            this.testSgConfig.roleMappingResolutionMode(roleMappingResolutionMode);
            return this;
        }

        public Builder nodeSettings(Object ... settings) {
            for (int i = 0; i < settings.length - 1; i += 2) {
                String key = String.valueOf(settings[i]);
                Object value = settings[i + 1];
                if (value instanceof List) {
                    List values = ((List)value).stream().map(String::valueOf).collect(Collectors.toList());
                    this.nodeOverrideSettingsBuilder.putList(key, values);
                    continue;
                }
                this.nodeOverrideSettingsBuilder.put(key, String.valueOf(value));
            }
            return this;
        }

        public Builder enterpriseModulesEnabled() {
            this.enterpriseModulesEnabled = true;
            return this;
        }

        public Builder disableModule(Class<? extends SearchGuardModule> moduleClass) {
            this.disabledModules.add(moduleClass.getName());
            return this;
        }

        public Builder enableModule(Class<? extends SearchGuardModule> moduleClass) {
            this.disabledModules.remove(moduleClass.getName());
            return this;
        }

        public Builder remote(String name, LocalCluster anotherCluster) {
            this.remoteClusters.put(name, anotherCluster);
            this.clusterDependencies.add(anotherCluster);
            return this;
        }

        public Builder indices(TestIndex ... indices) {
            this.testIndices.addAll(Arrays.asList(indices));
            return this;
        }

        public Builder dataStreams(TestDataStream ... dataStreams) {
            this.testDataStreams.addAll(Arrays.asList(dataStreams));
            return this;
        }

        public Builder aliases(TestAlias ... aliases) {
            this.testAliases.addAll(Arrays.asList(aliases));
            return this;
        }

        public Builder componentTemplates(TestComponentTemplate ... templates) {
            this.testComponentTemplates.addAll(Arrays.asList(templates));
            return this;
        }

        public Builder indexTemplates(TestIndexTemplate ... templates) {
            for (TestIndexTemplate template : templates) {
                this.testIndexTemplates.add(template);
                for (TestComponentTemplate componentTemplate : template.getComposedOf()) {
                    if (this.testComponentTemplates.contains(componentTemplate)) continue;
                    this.testComponentTemplates.add(componentTemplate);
                }
            }
            return this;
        }

        public Builder users(TestSgConfig.User ... users) {
            for (TestSgConfig.User user : users) {
                this.testSgConfig.user(user);
            }
            return this;
        }

        public Builder users(List<TestSgConfig.User> users) {
            for (TestSgConfig.User user : users) {
                this.testSgConfig.user(user);
            }
            return this;
        }

        public Builder user(TestSgConfig.User user) {
            this.testSgConfig.user(user);
            return this;
        }

        public Builder user(String name, String password, TestSgConfig.Role ... sgRoles) {
            this.testSgConfig.user(name, TestSgConfig.UserPassword.of(password), sgRoles);
            return this;
        }

        public Builder roles(TestSgConfig.Role ... roles) {
            this.testSgConfig.roles(roles);
            return this;
        }

        public Builder roleMapping(TestSgConfig.RoleMapping ... mappings) {
            this.testSgConfig.roleMapping(mappings);
            return this;
        }

        public Builder roleToRoleMapping(TestSgConfig.Role role, String ... backendRoles) {
            this.testSgConfig.roleToRoleMapping(role, backendRoles);
            return this;
        }

        public Builder authc(TestSgConfig.Authc authc) {
            this.testSgConfig.authc(authc);
            return this;
        }

        public Builder frontendMultiTenancy(TestSgConfig.FrontendMultiTenancy frontendMultiTenancy) {
            this.testSgConfig.frontendMultiTenancy(frontendMultiTenancy);
            return this;
        }

        public Builder tenants(TestSgConfig.Tenant ... tenants) {
            this.testSgConfig.tenants(tenants);
            return this;
        }

        public Builder dlsFls(TestSgConfig.DlsFls dlsfls) {
            this.testSgConfig.dlsFls(dlsfls);
            return this;
        }

        public Builder authTokenService(TestSgConfig.AuthTokenService authTokenService) {
            this.testSgConfig.authTokenService(authTokenService);
            return this;
        }

        public Builder var(String name, Supplier<Object> value) {
            this.testSgConfig.var(name, value);
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Embedded embedded() {
            return new Embedded(this);
        }

        public Builder logRequests() {
            this.logRequests = true;
            return this;
        }

        public Builder useExternalProcessCluster() {
            this.externalProcessCluster = true;
            return this;
        }

        public Builder waitForComponents(String ... components) {
            this.waitForComponents = this.waitForComponents.with((Collection)ImmutableList.ofArray((Object[])components));
            return this;
        }

        public LocalCluster build() {
            try {
                this.preBuild();
                return new LocalCluster(this.clusterName, this.resourceFolder, this.testSgConfig, this.nodeOverrideSettingsBuilder.build(), this.clusterConfiguration, (List<Class<? extends Plugin>>)ImmutableList.empty(), this.testCertificates, this.clusterDependencies, this.remoteClusters, this.testIndices, this.testDataStreams, this.testAliases, this.testComponentTemplates, this.testIndexTemplates, this.logRequests, this.externalProcessCluster, this.waitForComponents);
            }
            catch (Exception e) {
                log.error("Failed to build LocalCluster", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public LocalCluster start() {
            LocalCluster localCluster = this.build();
            localCluster.start();
            return localCluster;
        }

        private void preBuild() {
            this.nodeOverrideSettingsBuilder.put("searchguard.enterprise_modules_enabled", this.enterpriseModulesEnabled);
            if (this.disabledModules.size() > 0) {
                this.nodeOverrideSettingsBuilder.putList(SearchGuardModulesRegistry.DISABLED_MODULES.getKey(), new ArrayList<String>(this.disabledModules));
            }
            this.clusterName = this.clusterName + "_" + num.incrementAndGet();
        }

        public static class Embedded {
            private final Builder delegate;
            private final List<Class<? extends Plugin>> plugins = new ArrayList<Class<? extends Plugin>>();

            Embedded(Builder delegate) {
                this.delegate = delegate;
            }

            public Embedded configIndexName(String configIndexName) {
                this.delegate.testSgConfig.configIndexName(configIndexName);
                return this;
            }

            public Embedded plugin(Class<? extends Plugin> plugin) {
                this.plugins.add(plugin);
                return this;
            }

            public com.floragunn.searchguard.test.helper.cluster.LocalCluster$Embedded build() {
                try {
                    this.delegate.preBuild();
                    return new com.floragunn.searchguard.test.helper.cluster.LocalCluster$Embedded(this.delegate.clusterName, this.delegate.resourceFolder, this.delegate.testSgConfig, this.delegate.nodeOverrideSettingsBuilder.build(), this.delegate.clusterConfiguration, this.plugins, this.delegate.testCertificates, this.delegate.clusterDependencies, this.delegate.remoteClusters, this.delegate.testIndices, this.delegate.testDataStreams, this.delegate.testAliases, this.delegate.testComponentTemplates, this.delegate.testIndexTemplates, this.delegate.logRequests, this.delegate.waitForComponents);
                }
                catch (Exception e) {
                    log.error("Failed to build LocalCluster", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }

            public com.floragunn.searchguard.test.helper.cluster.LocalCluster$Embedded start() {
                com.floragunn.searchguard.test.helper.cluster.LocalCluster$Embedded localCluster = this.build();
                localCluster.start();
                return localCluster;
            }

            public Embedded dependsOn(Object object) {
                this.delegate.dependsOn(object);
                return this;
            }

            public Embedded clusterConfiguration(ClusterConfiguration clusterConfiguration) {
                this.delegate.clusterConfiguration(clusterConfiguration);
                return this;
            }

            public Embedded ignoreUnauthorizedIndices(boolean ignoreUnauthorizedIndices) {
                this.delegate.ignoreUnauthorizedIndices(ignoreUnauthorizedIndices);
                return this;
            }

            public Embedded authzDebug(boolean debug) {
                this.delegate.authzDebug(debug);
                return this;
            }

            public Embedded nodeSettings(Object ... settings) {
                this.delegate.nodeSettings(settings);
                return this;
            }

            public Embedded enterpriseModulesEnabled() {
                this.delegate.enterpriseModulesEnabled();
                return this;
            }

            public Embedded disableModule(Class<? extends SearchGuardModule> moduleClass) {
                this.delegate.disableModule(moduleClass);
                return this;
            }

            public Embedded enableModule(Class<? extends SearchGuardModule> moduleClass) {
                this.delegate.enableModule(moduleClass);
                return this;
            }

            public Embedded indices(TestIndex ... indices) {
                this.delegate.indices(indices);
                return this;
            }

            public Embedded aliases(TestAlias ... aliases) {
                this.delegate.aliases(aliases);
                return this;
            }

            public Embedded authc(TestSgConfig.Authc authc) {
                this.delegate.authc(authc);
                return this;
            }

            public Embedded dlsFls(TestSgConfig.DlsFls dlsfls) {
                this.delegate.dlsFls(dlsfls);
                return this;
            }

            public Embedded authTokenService(TestSgConfig.AuthTokenService authTokenService) {
                this.delegate.authTokenService(authTokenService);
                return this;
            }

            public Embedded clusterName(String clusterName) {
                this.delegate.clusterName(clusterName);
                return this;
            }

            public Embedded logRequests() {
                this.delegate.logRequests();
                return this;
            }

            public Embedded sslEnabled() {
                this.delegate.sslEnabled();
                return this;
            }

            public Embedded sslEnabled(TestCertificates certificatesContext) {
                this.delegate.sslEnabled(certificatesContext);
                return this;
            }

            public Embedded resources(String resourceFolder) {
                this.delegate.resources(resourceFolder);
                return this;
            }

            public Embedded singleNode() {
                this.delegate.singleNode();
                return this;
            }

            public Embedded sgConfig(TestSgConfig testSgConfig) {
                this.delegate.sgConfig(testSgConfig);
                return this;
            }

            public Embedded remote(String name, LocalCluster anotherCluster) {
                this.delegate.remote(name, anotherCluster);
                return this;
            }

            public Embedded users(TestSgConfig.User ... users) {
                this.delegate.users(users);
                return this;
            }

            public Embedded user(TestSgConfig.User user) {
                this.delegate.user(user);
                return this;
            }

            public Embedded user(String name, String password, TestSgConfig.Role ... sgRoles) {
                this.delegate.user(name, password, sgRoles);
                return this;
            }

            public Embedded roles(TestSgConfig.Role ... roles) {
                this.delegate.roles(roles);
                return this;
            }

            public Embedded roleMapping(TestSgConfig.RoleMapping ... mappings) {
                this.delegate.roleMapping(mappings);
                return this;
            }

            public Embedded roleToRoleMapping(TestSgConfig.Role role, String ... backendRoles) {
                this.delegate.roleToRoleMapping(role, backendRoles);
                return this;
            }

            public Embedded waitForComponents(String ... components) {
                this.delegate.waitForComponents(components);
                return this;
            }

            public Embedded var(String name, Supplier<Object> value) {
                this.delegate.var(name, value);
                return this;
            }
        }
    }
}

