/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.searchguard.test.NodeSettingsSupplier;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.io.FileNotFoundException;
import java.util.Optional;
import org.elasticsearch.common.settings.Settings;

public class MinimumSearchGuardSettingsSupplierFactory {
    private final String resourceFolder;
    private final boolean useJksCerts;

    public MinimumSearchGuardSettingsSupplierFactory(String resourceFolder, boolean useJksCerts) {
        this.resourceFolder = resourceFolder;
        this.useJksCerts = useJksCerts;
    }

    public NodeSettingsSupplier minimumSearchGuardSettings(Settings other) {
        return i -> this.minimumSearchGuardSettingsBuilder(i, false).put(other).build();
    }

    public NodeSettingsSupplier minimumSearchGuardSettingsSslOnly(Settings other) {
        return i -> this.minimumSearchGuardSettingsBuilder(i, true).put(other).build();
    }

    private Settings.Builder minimumSearchGuardSettingsBuilder(int node, boolean sslOnly) {
        Settings.Builder builder = Settings.builder();
        builder.put("searchguard.ssl.transport.enforce_hostname_verification", false);
        if (!sslOnly) {
            builder.put("searchguard.background_init_if_sgindex_not_exist", false);
            builder.put("searchguard.ssl_only", false);
        } else {
            builder.put("searchguard.ssl_only", true);
        }
        if (this.useJksCerts) {
            try {
                String prefix = Optional.ofNullable(this.resourceFolder).map(folder -> folder + "/").orElse("");
                builder.put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath(prefix + "node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath(prefix + "truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false);
                if (!sslOnly) {
                    builder.putList("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"});
                }
                return builder;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return builder;
    }
}

