/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.log;

import com.floragunn.searchguard.test.helper.log.LogCapturingAppender;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.rules.ExternalResource;

public class LogsRule
extends ExternalResource {
    private final String[] loggerNames;

    public LogsRule(String ... loggerNames) {
        this.loggerNames = Objects.requireNonNull(loggerNames, "Logger names are required");
    }

    protected void before() {
        LogCapturingAppender.enable(this.loggerNames);
    }

    protected void after() {
        LogCapturingAppender.disable();
    }

    public void assertThatContainExactly(String expectedLogMessage) {
        List<String> messages = LogCapturingAppender.getLogMessagesAsString();
        String reason = LogsRule.reasonMessage(expectedLogMessage, messages);
        MatcherAssert.assertThat((String)reason, messages, (Matcher)Matchers.hasItem((Object)expectedLogMessage));
    }

    public void assertThatContain(String messageFragment) {
        List<String> messages = LogCapturingAppender.getLogMessagesAsString();
        String reason = LogsRule.reasonMessage(messageFragment, messages);
        MatcherAssert.assertThat((String)reason, messages, (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)messageFragment)));
    }

    public void assertThatStackTraceContain(String stackTraceFragment) {
        long count = LogCapturingAppender.getLogMessages().stream().filter(logMessage -> logMessage.stackTraceContains(stackTraceFragment)).count();
        String reason = "Stack trace does not contain element " + stackTraceFragment;
        MatcherAssert.assertThat((String)reason, (Object)count, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    private static String reasonMessage(String expectedLogMessage, List<String> messages) {
        String concatenatedLogMessages = messages.stream().map(message -> String.format("'%s'", message)).collect(Collectors.joining(", "));
        return String.format("Expected message '%s' has not been found in logs. All captured log messages: %s", expectedLogMessage, concatenatedLogMessages);
    }
}

