/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.base;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authc.AuthFailureListener;
import com.floragunn.searchguard.authc.AuthenticationDebugLogger;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.AuthenticationFrontend;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.authc.blocking.BlockedUserRegistry;
import com.floragunn.searchguard.authc.rest.RestImpersonationProcessor;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchguard.user.UserInformation;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public abstract class RequestAuthenticationProcessor<AuthenticatorType extends AuthenticationFrontend> {
    private static final Logger log = LogManager.getLogger(RequestAuthenticationProcessor.class);
    protected final RequestMetaData<RestRequest> request;
    protected final AuditLog auditLog;
    private final Collection<AuthenticationDomain<AuthenticatorType>> authenticationDomains;
    private final Iterator<AuthenticationDomain<AuthenticatorType>> authenticationDomainIter;
    private final List<AuthFailureListener> ipAuthFailureListeners;
    private final BlockedUserRegistry blockedUserRegistry;
    private final AdminDNs adminDns;
    private final Cache<AuthCredentials, User> userCache;
    private final Cache<String, User> impersonationCache;
    private final PrivilegesEvaluator privilegesEvaluator;
    protected final AuthenticationDebugLogger debug;
    private final List<String> requiredLoginPrivileges;
    private boolean cacheResult = true;
    protected AuthCredentials authCredentials = null;

    public RequestAuthenticationProcessor(RequestMetaData<RestRequest> request, Collection<AuthenticationDomain<AuthenticatorType>> authenticationDomains, AdminDNs adminDns, PrivilegesEvaluator privilegesEvaluator, Cache<AuthCredentials, User> userCache, Cache<String, User> impersonationCache, AuditLog auditLog, BlockedUserRegistry blockedUserRegistry, List<AuthFailureListener> ipAuthFailureListeners, List<String> requiredLoginPrivileges, boolean debug) {
        this.request = request;
        this.authenticationDomains = authenticationDomains;
        this.authenticationDomainIter = authenticationDomains.iterator();
        this.ipAuthFailureListeners = ipAuthFailureListeners;
        this.blockedUserRegistry = blockedUserRegistry;
        this.adminDns = adminDns;
        this.userCache = userCache;
        this.impersonationCache = impersonationCache;
        this.auditLog = auditLog;
        this.privilegesEvaluator = privilegesEvaluator;
        this.requiredLoginPrivileges = requiredLoginPrivileges;
        this.debug = AuthenticationDebugLogger.create(debug);
    }

    public void authenticate(Consumer<AuthcResult> onResult, Consumer<Exception> onFailure) {
        if (this.authenticationDomains.isEmpty()) {
            log.warn("Cannot authenticate request because no authentication domains are configured: " + String.valueOf(this));
        } else if (log.isDebugEnabled()) {
            log.debug("Authenticating request using: " + String.valueOf(this.authenticationDomains));
        }
        this.checkNextAuthenticationDomains(onResult, onFailure);
    }

    protected abstract AuthDomainState handleCurrentAuthenticationDomain(AuthenticationDomain<AuthenticatorType> var1, Consumer<AuthcResult> var2, Consumer<Exception> var3);

    protected AuthcResult handleChallenge(RestRequest restRequest) {
        return null;
    }

    protected String getImpersonationUser() {
        return null;
    }

    protected String getRequestedTenant() {
        return null;
    }

    protected void decorateAuthenticatedUser(User authenticatedUser) {
    }

    protected boolean checkLoginPrivileges(User user) throws PrivilegesEvaluationException {
        if (this.requiredLoginPrivileges == null || this.requiredLoginPrivileges.isEmpty()) {
            return true;
        }
        return this.privilegesEvaluator.hasClusterPermissions(user, this.requiredLoginPrivileges, null);
    }

    protected boolean userHasRoles(User user) {
        return user.getRoles().size() != 0 || user.getSearchGuardRoles().size() != 0;
    }

    protected void notifyIpAuthFailureListeners(AuthCredentials authCredentials) {
        for (AuthFailureListener authFailureListener : this.ipAuthFailureListeners) {
            authFailureListener.onAuthFailure(this.request.getOriginatingIpAddress() != null ? this.request.getOriginatingIpAddress().toInetAddress() : null, authCredentials, this.request.getRequest());
        }
    }

    private void checkNextAuthenticationDomains(Consumer<AuthcResult> onResult, Consumer<Exception> onFailure) {
        while (this.authenticationDomainIter.hasNext()) {
            AuthenticationDomain<AuthenticatorType> authenticationDomain = this.authenticationDomainIter.next();
            AuthDomainState state = this.checkCurrentAuthenticationDomain(authenticationDomain, onResult, onFailure);
            if (state == AuthDomainState.PENDING) {
                return;
            }
            if (state != AuthDomainState.STOP) continue;
            onResult.accept(AuthcResult.STOP);
            return;
        }
        onResult.accept(this.handleFinalAuthFailure());
    }

    private AuthDomainState checkCurrentAuthenticationDomain(AuthenticationDomain<AuthenticatorType> authenticationDomain, Consumer<AuthcResult> onResult, Consumer<Exception> onFailure) {
        try {
            if (!authenticationDomain.isEnabled()) {
                return AuthDomainState.SKIP;
            }
            if (log.isTraceEnabled()) {
                log.trace("Checking authdomain " + String.valueOf(authenticationDomain) + " (total: " + this.authenticationDomains.size() + ")");
            }
            if (!authenticationDomain.accept(this.request)) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping " + String.valueOf(authenticationDomain) + " because it is disabled by acceptance rules: " + String.valueOf(this.request.getDirectIpAddress()) + "/" + String.valueOf(this.request.getOriginatingIpAddress()));
                }
                return AuthDomainState.SKIP;
            }
            return this.handleCurrentAuthenticationDomain(authenticationDomain, onResult, onFailure);
        }
        catch (Exception e) {
            log.error("Error while handling auth domain " + String.valueOf(authenticationDomain), (Throwable)e);
            return AuthDomainState.SKIP;
        }
    }

    protected AuthDomainState proceed(AuthCredentials ac, AuthenticationDomain<AuthenticatorType> authenticationDomain, Consumer<AuthcResult> onResult, Consumer<Exception> onFailure) {
        this.authCredentials = ac;
        try {
            ac = authenticationDomain.getCredentialsMapper().mapCredentials(ac);
        }
        catch (CredentialsException e2) {
            log.warn("Error while mapping auth credentials for " + String.valueOf(authenticationDomain), (Throwable)e2);
            this.debug.add(authenticationDomain.getType(), e2.getDebugInfo());
            ac.clearSecrets();
            return AuthDomainState.SKIP;
        }
        this.authCredentials = ac;
        if (!authenticationDomain.accept(ac)) {
            if (log.isDebugEnabled()) {
                log.debug("Skipped authentication of user {}", (Object)ac.getUsername());
            }
            this.debug.failure(authenticationDomain.getType(), "User was skipped because of access/skip settings of auth domain", "user_name", ac.getUsername());
            ac.clearSecrets();
            return AuthDomainState.SKIP;
        }
        log.trace("Calling {} backends", (Object)authenticationDomain.getType());
        AuthCredentials pendingCredentials = ac;
        this.callAuthcBackends(ac, authenticationDomain, authenticatedUser -> {
            try {
                pendingCredentials.clearSecrets();
                if (authenticatedUser != null) {
                    if (this.adminDns.isAdmin((User)authenticatedUser)) {
                        log.error("Cannot authenticate rest user because admin user is not permitted to login via HTTP");
                        this.auditLog.logFailedLogin((UserInformation)authenticatedUser, true, null, this.request.getRequest());
                        this.debug.failure(authenticationDomain.getType(), "User name is associated with an administrator. These are only allowed to login via certificate.");
                        onResult.accept(AuthcResult.stop(RestStatus.FORBIDDEN, "Cannot authenticate user because admin user is not permitted to login via HTTP", this.debug.get()));
                        return;
                    }
                    if (!this.userHasRoles((User)authenticatedUser)) {
                        this.debug.failure(authenticationDomain.getType(), "User does not have any roles. Please verify the configuration of the authentication frontend and backend.", "user_mapping_attributes", pendingCredentials.getAttributesForUserMapping());
                    }
                    if (!this.checkLoginPrivileges((User)authenticatedUser)) {
                        log.error("Cannot authenticate rest user because user does not have the necessary login privileges: " + String.valueOf(this.requiredLoginPrivileges) + "; " + String.valueOf(authenticatedUser) + "; backend roles: " + String.valueOf(authenticatedUser.getRoles()) + "; sg roles: " + String.valueOf(authenticatedUser.getSearchGuardRoles()) + "; source attributes: " + String.valueOf(pendingCredentials.getAttributesForUserMapping()));
                        this.debug.failure(authenticationDomain.getType(), "User does not have the necessary login privileges: " + String.valueOf(this.requiredLoginPrivileges), "backend_roles", authenticatedUser.getRoles(), "sg_roles", authenticatedUser.getSearchGuardRoles(), "source_attributes", pendingCredentials.getAttributesForUserMapping());
                        onResult.accept(AuthcResult.stop(RestStatus.FORBIDDEN, "The user '" + pendingCredentials.getName() + "' is not allowed to log in.", this.debug.get()));
                        return;
                    }
                    String requestedTenant = this.getRequestedTenant();
                    if (log.isDebugEnabled()) {
                        log.debug("Authentication successful for " + authenticatedUser.toStringWithAttributes() + " on " + String.valueOf(authenticationDomain) + " using " + String.valueOf(this) + "\nrequestedTenant: " + requestedTenant);
                    }
                    this.decorateAuthenticatedUser((User)authenticatedUser);
                    authenticatedUser.setRequestedTenant(requestedTenant);
                    if (this.isImpersonationRequested()) {
                        new RestImpersonationProcessor<AuthenticatorType>((User)authenticatedUser, this.getImpersonationUser(), this.authenticationDomains, this.adminDns, this.impersonationCache).impersonate(result -> {
                            if (result.getUser() != null) {
                                this.auditLog.logSucceededLogin(result.getUser(), false, (UserInformation)authenticatedUser, this.request.getRequest());
                            }
                            onResult.accept((AuthcResult)result);
                        }, onFailure);
                    } else {
                        this.auditLog.logSucceededLogin((UserInformation)authenticatedUser, false, (UserInformation)authenticatedUser, this.request.getRequest());
                        if (this.debug.isEnabled()) {
                            this.debug.success(authenticationDomain.getType(), "User is logged in", "user", ImmutableMap.of((Object)"name", (Object)authenticatedUser.getName(), (Object)"roles", authenticatedUser.getRoles(), (Object)"search_guard_roles", authenticatedUser.getSearchGuardRoles(), (Object)"attributes", authenticatedUser.getStructuredAttributes()));
                        }
                        onResult.accept(AuthcResult.pass(authenticatedUser, pendingCredentials.getRedirectUri(), this.debug.get()));
                    }
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace("Could not authenticate user with " + authenticationDomain.getType());
                    }
                    this.debug.failure(authenticationDomain.getType(), "User " + pendingCredentials.getUsername() + " could not be authenticated by auth backend");
                    this.handleAuthFailure(pendingCredentials, authenticationDomain, null);
                    this.checkNextAuthenticationDomains(onResult, onFailure);
                }
            }
            catch (Exception e) {
                this.debug.failure(authenticationDomain.getType(), "Exception while authenticating " + pendingCredentials.getUsername() + ": " + String.valueOf(e));
                log.error((Object)e);
                onFailure.accept(e);
            }
        }, e -> {
            if (e instanceof ElasticsearchSecurityException) {
                this.debug.failure(authenticationDomain.getType(), e.getMessage());
                this.handleAuthFailure(pendingCredentials, authenticationDomain, (Exception)e);
            } else if (e instanceof CredentialsException) {
                if (((CredentialsException)e).getDebugInfo() != null) {
                    this.debug.add(((CredentialsException)e).getDebugInfo());
                } else {
                    this.debug.failure(authenticationDomain.getType(), e.getMessage());
                }
                this.handleAuthFailure(pendingCredentials, authenticationDomain, (Exception)e);
            } else if (e instanceof AuthenticatorUnavailableException) {
                this.debug.failure(authenticationDomain.getType(), "Authenticator unavailable: " + e.getMessage(), ((AuthenticatorUnavailableException)e).getDetails());
                log.error("Error while authenticating " + String.valueOf(pendingCredentials) + "\n" + String.valueOf(((AuthenticatorUnavailableException)e).getDetails()), (Throwable)e);
            } else {
                this.debug.failure(authenticationDomain.getType(), "Exception while authenticating " + pendingCredentials.getUsername() + ": " + String.valueOf(e));
                log.error("Error while authenticating " + String.valueOf(pendingCredentials), (Throwable)e);
            }
            pendingCredentials.clearSecrets();
            this.checkNextAuthenticationDomains(onResult, onFailure);
        });
        return AuthDomainState.PENDING;
    }

    protected AuthcResult handleFinalAuthFailure() {
        try {
            log.warn("Authentication failed for {} from {}", (Object)(this.authCredentials == null ? null : this.authCredentials.getUsername()), this.request);
            this.auditLog.logFailedLogin(this.authCredentials != null ? this.authCredentials : AuthCredentials.NONE, false, null, this.request.getRequest());
            this.notifyIpAuthFailureListeners(this.authCredentials);
            AuthcResult challengeHandled = this.handleChallenge(this.request.getRequest());
            if (challengeHandled != null) {
                return challengeHandled;
            }
            return AuthcResult.stop(RestStatus.UNAUTHORIZED, "Unauthorized", this.debug.get());
        }
        catch (Exception e) {
            log.error("Error while handling auth failure", (Throwable)e);
            return AuthcResult.stop(RestStatus.UNAUTHORIZED, "Unauthorized", this.debug.get());
        }
    }

    private void callAuthcBackends(AuthCredentials ac, AuthenticationDomain<AuthenticatorType> authenticationDomain, Consumer<User> onSuccess, Consumer<Exception> onFailure) {
        try {
            this.debug.success(authenticationDomain.getType(), "Extracted credentials", "user_name", ac.getUsername(), "user_mapping_attributes", ac.getAttributesForUserMapping());
            if (this.userCache == null || !authenticationDomain.cacheUser()) {
                authenticationDomain.authenticate(ac, this.debug).whenComplete((authenticatedUser, e) -> {
                    if (e != null) {
                        onFailure.accept((Exception)e);
                    } else if (authenticatedUser != null) {
                        this.debug.success(authenticationDomain.getType(), "User has been successfully authenticated by auth backend.");
                        onSuccess.accept((User)authenticatedUser);
                    } else {
                        onFailure.accept(new Exception("User not authenticated"));
                    }
                });
            } else {
                User user = (User)this.userCache.getIfPresent((Object)ac);
                if (user != null) {
                    this.debug.success(authenticationDomain.getType(), "User has been successfully authenticated by user cache");
                    onSuccess.accept(user);
                } else {
                    authenticationDomain.authenticate(ac, this.debug).whenComplete((authenticatedUser, e) -> {
                        if (e != null) {
                            onFailure.accept((Exception)e);
                        } else if (authenticatedUser != null) {
                            this.authzAndCache(ac, authenticationDomain, (User)authenticatedUser, onSuccess, onFailure);
                        } else {
                            onFailure.accept(new CredentialsException("User not authenticated"));
                        }
                    });
                }
            }
        }
        catch (Exception e2) {
            ac.clearSecrets();
            onFailure.accept(e2);
        }
    }

    private void authzAndCache(AuthCredentials ac, AuthenticationDomain<AuthenticatorType> authenticationDomain, User authenticatedUser, Consumer<User> onSuccess, Consumer<Exception> onFailure) {
        try {
            if (this.cacheResult && this.userCache != null) {
                this.userCache.put((Object)ac, (Object)authenticatedUser);
            }
            onSuccess.accept(authenticatedUser);
        }
        catch (Exception e) {
            log.error((Object)e);
            onFailure.accept(e);
        }
    }

    private void handleAuthFailure(AuthCredentials ac, AuthenticationDomain<AuthenticatorType> authenticationDomain, Exception e) {
    }

    private boolean isImpersonationRequested() {
        return !Strings.isNullOrEmpty((String)this.getImpersonationUser());
    }

    protected boolean isUserBlocked(String authBackend, String userName) {
        return this.blockedUserRegistry.isUserBlocked(userName);
    }

    protected static enum AuthDomainState {
        PENDING,
        SKIP,
        PASS,
        STOP;

    }
}

