/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.compliance;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.license.LicenseChangeListener;
import com.floragunn.searchguard.license.SearchGuardLicense;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.env.Environment;

public class ComplianceConfig
implements LicenseChangeListener {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Settings settings;
    private final Pattern immutableIndicesPatterns;
    private final ActionRequestIntrospector actionRequestIntrospector;
    private volatile boolean enabled = true;

    public ComplianceConfig(Environment environment, ActionRequestIntrospector actionRequestIntrospector, ConfigurationRepository configRepository) {
        this.settings = environment.settings();
        this.actionRequestIntrospector = actionRequestIntrospector;
        try {
            this.immutableIndicesPatterns = Pattern.create((List)this.settings.getAsList("searchguard.compliance.immutable_indices", Collections.emptyList()));
        }
        catch (ConfigValidationException | SettingsException e1) {
            throw new RuntimeException("Invalid setting searchguard.compliance.immutable_indices", e1);
        }
    }

    @Override
    public void onChange(SearchGuardLicense license) {
        this.enabled = license == null ? false : license.hasFeature(SearchGuardLicense.Feature.COMPLIANCE);
        this.log.info("Compliance features are " + (this.enabled ? "enabled" : "disabled. To enable them you need a special license. Please contact support for this."));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isIndexImmutable(Action action, Object request) {
        if (!this.enabled) {
            return false;
        }
        if (this.immutableIndicesPatterns.isBlank()) {
            return false;
        }
        ResolvedIndices resolved = this.actionRequestIntrospector.getActionRequestInfo(action, request).getResolvedIndices();
        if (resolved.isLocalAll()) {
            return true;
        }
        return this.immutableIndicesPatterns.matches(resolved.getLocal().getDeepUnion());
    }
}

