/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestIndexLike;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.client.internal.Client;

public class TestAlias
implements TestIndexLike {
    private final String name;
    private final ImmutableSet<TestIndexLike> indices;
    private Set<String> documentIds;
    private Map<String, Map<String, ?>> documents;
    private TestIndexLike writeIndex;

    public TestAlias(String name, TestIndexLike ... indices) {
        this.name = name;
        this.indices = ImmutableSet.ofArray((Object[])indices);
    }

    public TestAlias writeIndex(TestIndexLike writeIndex) {
        this.writeIndex = writeIndex;
        return this;
    }

    @Override
    public DocNode getFieldsMappings() {
        return this.indices.stream().map(TestIndexLike::getFieldsMappings).findFirst().orElseThrow();
    }

    public String toString() {
        return "Test alias name '" + this.name + "'";
    }

    public void create(Client client) {
        client.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(this.getIndexNamesAsArray()).alias(this.name))).actionGet();
        if (this.writeIndex != null) {
            client.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().index(this.writeIndex.getName()).alias(this.name).writeIndex(Boolean.valueOf(true)))).actionGet();
        }
    }

    public void create(GenericRestClient client) throws Exception {
        GenericRestClient.HttpResponse response = client.postJson("_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"add.indices", (Object)this.getIndexNamesAsArray(), (String)"add.alias", (Object)this.name)})), new Header[0]);
        if (response.getStatusCode() != 200) {
            throw new RuntimeException("Error while creating alias " + this.name + "\n" + String.valueOf(response));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableSet<TestIndexLike> getIndices() {
        return this.indices;
    }

    public String[] getIndexNamesAsArray() {
        return this.indices.stream().map(i -> i.getName()).collect(Collectors.toSet()).toArray(new String[0]);
    }

    @Override
    public Set<String> getDocumentIds() {
        Set<String> result = this.documentIds;
        if (result == null) {
            result = new HashSet<String>();
            for (TestIndexLike testIndex : this.indices) {
                result.addAll(testIndex.getDocumentIds());
            }
            this.documentIds = result = Collections.unmodifiableSet(result);
        }
        return result;
    }

    @Override
    public Map<String, Map<String, ?>> getDocuments() {
        Map<String, Map<String, ?>> result = this.documents;
        if (result == null) {
            result = new HashMap();
            for (TestIndexLike testIndex : this.indices) {
                result.putAll(testIndex.getDocuments());
            }
            result = Collections.unmodifiableMap(result);
            this.documents = result;
        }
        return result;
    }
}

