/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.certificate.TestCertificate;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.SSLContextProvider;
import com.floragunn.searchguard.test.helper.cluster.TestCertificateBasedSSLContextProvider;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public interface EsClientProvider {
    public String getClusterName();

    public TestCertificates getTestCertificates();

    public InetSocketAddress getHttpAddress();

    public InetSocketAddress getTransportAddress();

    default public URI getHttpAddressAsURI() {
        InetSocketAddress address = this.getHttpAddress();
        return URI.create("https://" + address.getHostString() + ":" + address.getPort());
    }

    default public SSLContextProvider getAdminClientSslContextProvider() {
        return new TestCertificateBasedSSLContextProvider(this.getTestCertificates().getCaCertificate(), this.getTestCertificates().getAdminCertificate());
    }

    default public SSLContextProvider getUserClientSslContextProvider(String subjectDistinguishedName) {
        TestCertificate userCertificate = this.getTestCertificates().create(subjectDistinguishedName);
        return new TestCertificateBasedSSLContextProvider(this.getTestCertificates().getCaCertificate(), userCertificate);
    }

    default public SSLContextProvider getAnyClientSslContextProvider() {
        return new TestCertificateBasedSSLContextProvider(this.getTestCertificates().getCaCertificate(), this.getTestCertificates().getAnyClientCertificate());
    }

    default public GenericRestClient getRestClient(UserCredentialsHolder user, Header ... headers) {
        ImmutableList headersList = ImmutableList.ofArray((Object[])headers);
        if (user.isAdminCertUser()) {
            return this.getAdminCertRestClient(user, (List<Header>)headersList);
        }
        return this.getRestClient(user, (List<Header>)headersList.with((Object)this.getBasicAuthHeader(user.getName(), user.getPassword())));
    }

    default public GenericRestClient getRestClient(String user, String password, String tenant) {
        return this.getRestClient(user, password, new Header[]{new BasicHeader("sgtenant", tenant)});
    }

    default public GenericRestClient getRestClient(String user, String password, Header ... headers) {
        return this.getRestClient(UserCredentialsHolder.basic(user, password), headers);
    }

    default public GenericRestClient getRestClient(Header ... headers) {
        return this.getRestClient(null, Arrays.asList(headers));
    }

    default public GenericRestClient getRestClient(UserCredentialsHolder user, List<Header> headers) {
        return new GenericRestClient(this.getHttpAddress(), headers, this.getAnyClientSslContextProvider().getSslContext(false), user, this.getRequestInfoConsumer());
    }

    default public GenericRestClient getAdminCertRestClient() {
        return this.getAdminCertRestClient(UserCredentialsHolder.ADMIN, (List<Header>)ImmutableList.empty());
    }

    default public GenericRestClient getAdminCertRestClient(UserCredentialsHolder user, List<Header> headers) {
        return new GenericRestClient(this.getHttpAddress(), headers, this.getAdminClientSslContextProvider().getSslContext(true), user, this.getRequestInfoConsumer());
    }

    default public GenericRestClient getUserCertRestClient(String subject, Header ... headers) {
        SSLContext sslContext = this.getUserClientSslContextProvider(subject).getSslContext(true);
        return new GenericRestClient(this.getHttpAddress(), Arrays.asList(headers), sslContext, UserCredentialsHolder.basic(subject, null), this.getRequestInfoConsumer());
    }

    default public GenericRestClient getRestClientWithoutTls(Header ... headers) {
        return this.getRestClientWithoutTls(Arrays.asList(headers));
    }

    default public GenericRestClient getRestClientWithoutTls(List<Header> headers) {
        return new GenericRestClient(this.getHttpAddress(), headers, null, null, this.getRequestInfoConsumer());
    }

    default public BasicHeader getBasicAuthHeader(String user, String password) {
        return new BasicHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((user + ":" + Objects.requireNonNull(password)).getBytes(StandardCharsets.UTF_8)));
    }

    public Consumer<GenericRestClient.RequestInfo> getRequestInfoConsumer();

    public static interface UserCredentialsHolder {
        public static final UserCredentialsHolder ADMIN = new UserCredentialsHolder(){

            @Override
            public String getName() {
                return "<admin cert user>";
            }

            @Override
            public String getPassword() {
                return null;
            }

            @Override
            public boolean isAdminCertUser() {
                return true;
            }

            public String toString() {
                return this.getName();
            }
        };

        public String getName();

        public String getPassword();

        default public boolean isAdminCertUser() {
            return false;
        }

        public static UserCredentialsHolder basic(final String name, final String password) {
            return new UserCredentialsHolder(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public String getPassword() {
                    return password;
                }

                public String toString() {
                    return this.getName();
                }
            };
        }
    }
}

