/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class FileHelper {
    protected static final Logger log = LogManager.getLogger(FileHelper.class);

    public static File createTempDirectory(String directoryNamePrefix) {
        try {
            String os = System.getProperty("os.name").toLowerCase();
            String sgTempDir = System.getenv("SG_TEMP_DIR");
            if (os.startsWith("mac") && !Strings.isNullOrEmpty((String)sgTempDir)) {
                File tmp = new File(sgTempDir, "sg_tests_tmp" + File.separatorChar + "sg-" + String.valueOf(UUID.randomUUID()));
                tmp.mkdirs();
                return tmp;
            }
            return Files.createTempDirectory(directoryNamePrefix, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            log.error("Failed to create temp directory with prefix: {}", (Object)directoryNamePrefix, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static KeyStore getKeystoreFromClassPath(String fileNameFromClasspath, String password) throws Exception {
        Path path = FileHelper.getAbsoluteFilePathFromClassPath(fileNameFromClasspath);
        if (path == null) {
            return null;
        }
        KeyStore ks = KeyStore.getInstance("JKS");
        try (FileInputStream fin = new FileInputStream(path.toFile());){
            ks.load(fin, password == null || password.isEmpty() ? null : password.toCharArray());
        }
        return ks;
    }

    public static Path getAbsoluteFilePathFromClassPath(String fileNameFromClasspath) throws FileNotFoundException {
        return FileHelper.getAbsoluteFilePathFromClassPath(null, fileNameFromClasspath);
    }

    public static Path getAbsoluteFilePathFromClassPath(String resourceDirectory, String fileNameFromClasspath) throws FileNotFoundException {
        URL fileUrl;
        if (resourceDirectory != null) {
            fileNameFromClasspath = resourceDirectory.endsWith("/") ? resourceDirectory + (String)fileNameFromClasspath : resourceDirectory + "/" + (String)fileNameFromClasspath;
        }
        if ((fileUrl = FileHelper.class.getClassLoader().getResource((String)fileNameFromClasspath)) == null) {
            throw new FileNotFoundException("Could not locate " + (String)fileNameFromClasspath);
        }
        if (fileUrl.getProtocol().equals("file")) {
            try {
                File file = new File(URLDecoder.decode(fileUrl.getFile(), "UTF-8"));
                if (!file.exists()) {
                    throw new FileNotFoundException("Could not locate " + (String)fileNameFromClasspath + " at " + String.valueOf(file));
                }
                return Paths.get(file.getAbsolutePath(), new String[0]);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (fileUrl.getProtocol().equals("jar")) {
            try {
                File tempFile = File.createTempFile(FilenameUtils.getBaseName((String)fileNameFromClasspath), FilenameUtils.getExtension((String)fileNameFromClasspath));
                FileUtils.copyInputStreamToFile((InputStream)fileUrl.openStream(), (File)tempFile);
                return tempFile.toPath();
            }
            catch (IOException e) {
                throw new RuntimeException("Error while making " + (String)fileNameFromClasspath + " available as temp file", e);
            }
        }
        throw new RuntimeException("Unsupported scheme " + String.valueOf(fileUrl));
    }

    public static final String loadFile(String file) throws IOException {
        StringWriter sw = new StringWriter();
        InputStream is = FileHelper.class.getResourceAsStream("/" + file);
        if (is == null) {
            throw new FileNotFoundException("Could not find resource in class path: " + file);
        }
        IOUtils.copy((InputStream)is, (Writer)sw, (Charset)StandardCharsets.UTF_8);
        return sw.toString();
    }

    public static void writeFile(String destFile, String content) throws IOException {
        FileWriter fw = new FileWriter(destFile, false);
        fw.write(content);
        fw.close();
    }

    public static BytesReference readYamlContent(String file) {
        BytesReference bytesReference;
        block8: {
            XContentParser parser = XContentFactory.xContent((XContentType)XContentType.YAML).createParser(XContentParserConfiguration.EMPTY, FileHelper.loadFile(file));
            try {
                parser.nextToken();
                XContentBuilder builder = XContentFactory.jsonBuilder();
                builder.copyCurrentStructure(parser);
                bytesReference = BytesReference.bytes((XContentBuilder)builder);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            parser.close();
        }
        return bytesReference;
    }

    public static BytesReference readYamlContentFromString(String yaml) {
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent((XContentType)XContentType.YAML).createParser(XContentParserConfiguration.EMPTY, yaml);
            parser.nextToken();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.copyCurrentStructure(parser);
            BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
            return bytesReference;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void copyFileContents(String srcFile, String destFile) {
        try {
            String s;
            FileReader fr = new FileReader(srcFile);
            BufferedReader br = new BufferedReader(fr);
            FileWriter fw = new FileWriter(destFile, false);
            while ((s = br.readLine()) != null) {
                fw.write(s);
                fw.write(System.getProperty("line.separator"));
                fw.flush();
            }
            br.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

