/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.searchguard.test.helper.certificate.TestCertificate;
import com.floragunn.searchguard.test.helper.cluster.SSLContextProvider;
import javax.net.ssl.SSLContext;

public class TestCertificateBasedSSLContextProvider
implements SSLContextProvider {
    private final TestCertificate caCertificate;
    private final TestCertificate certificate;

    public TestCertificateBasedSSLContextProvider(TestCertificate caCertificate, TestCertificate certificate) {
        this.caCertificate = caCertificate;
        this.certificate = certificate;
    }

    @Override
    public SSLContext getSslContext(boolean clientAuthentication) {
        try {
            TLSConfig.Builder tlsConfigBuilder = new TLSConfig.Builder().trust(this.caCertificate.getCertificateFile());
            if (clientAuthentication) {
                tlsConfigBuilder = tlsConfigBuilder.clientCert(this.certificate.getCertificateFile(), this.certificate.getPrivateKeyFile(), this.certificate.getPrivateKeyPassword());
            }
            return tlsConfigBuilder.build().getUnrestrictedSslContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Error when building SSLContext for tests", e);
        }
    }
}

