/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.fluent.collections.ImmutableMap;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SearchGuardVersion {
    private static final Logger log = LogManager.getLogger(SearchGuardVersion.class);
    private static final String VERSION = SearchGuardVersion.readVersionFromJar();
    private static final ImmutableMap<String, String> VERSION_HEADER = ImmutableMap.of((Object)"X-Search-Guard-Version", (Object)VERSION);

    public static String getVersion() {
        return VERSION;
    }

    public static ImmutableMap<String, String> header() {
        return VERSION_HEADER;
    }

    private static String readVersionFromJar() {
        try {
            InputStream inputStream = SearchGuardVersion.class.getResourceAsStream("/META-INF/maven/com.floragunn/search-guard-flx-security/pom.properties");
            if (inputStream == null) {
                throw new Exception("Could not find resource /META-INF/maven/com.floragunn/search-guard-flx-security/pom.properties");
            }
            Properties pomProperties = new Properties();
            pomProperties.load(inputStream);
            String version = pomProperties.getProperty("version");
            if (version == null || version.trim().length() == 0) {
                throw new Exception("Version property of /META-INF/maven/com.floragunn/search-guard-flx-security/pom.properties is empty");
            }
            int sep = version.indexOf("-es-");
            if (sep == -1) {
                sep = version.indexOf("-os-");
            }
            if (sep != -1) {
                return version.substring(0, sep);
            }
            return version;
        }
        catch (Exception e) {
            log.warn("Error while determining Search Guard version", (Throwable)e);
            return "<unknown_version>";
        }
    }
}

