/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.license;

import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.license.LicenseChangeListener;
import com.floragunn.searchguard.license.SearchGuardLicense;
import com.floragunn.searchguard.license.SearchGuardLicenseKey;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.xcontent.XContentType;

public class LicenseRepository
implements ComponentStateProvider {
    private static final Logger LOGGER = LogManager.getLogger(LicenseRepository.class);
    private final ClusterService clusterService;
    private final List<LicenseChangeListener> licenseChangeListeners = new ArrayList<LicenseChangeListener>();
    private final PrivilegedConfigClient privilegedClient;
    private final ConfigurationRepository configurationRepository;
    private final ComponentState componentState = new ComponentState(2, null, "license_repository", LicenseRepository.class);
    private volatile SearchGuardLicense effectiveLicense;
    private volatile SearchGuardLicense configuredLicense;
    private volatile ValidationErrors validationErrors;

    public LicenseRepository(Settings settings, Client client, ClusterService clusterService, ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
        this.clusterService = clusterService;
        this.privilegedClient = PrivilegedConfigClient.adapt(client);
        if (settings.getAsBoolean("searchguard.enterprise_modules_enabled", Boolean.valueOf(true)).booleanValue()) {
            configurationRepository.subscribeOnChange(configMap -> {
                SgDynamicConfiguration<SearchGuardLicenseKey> config = configMap.get(CType.LICENSE_KEY);
                if (config != null && config.getCEntry("default") != null) {
                    this.useLicense(config.getCEntry("default"), config);
                } else {
                    this.useLicense(null, null);
                }
            });
        } else {
            this.componentState.setState(ComponentState.State.SUSPENDED, "enterprise_modules_disabled");
        }
    }

    public synchronized void subscribeOnLicenseChange(LicenseChangeListener licenseChangeListener) {
        if (licenseChangeListener != null) {
            this.licenseChangeListeners.add(licenseChangeListener);
        }
    }

    public SearchGuardLicense getLicense() {
        if (this.configuredLicense != null) {
            this.configuredLicense.dynamicValidate(this.clusterService);
            return this.configuredLicense;
        }
        if (this.effectiveLicense != null) {
            this.effectiveLicense.dynamicValidate(this.clusterService);
            return this.effectiveLicense;
        }
        return null;
    }

    private SearchGuardLicense createOrGetTrial(String msg) {
        String searchguardIndex;
        try {
            searchguardIndex = this.configurationRepository.getEffectiveSearchGuardIndexAndCreateIfNecessary();
        }
        catch (ConfigUpdateException e1) {
            throw new RuntimeException(e1);
        }
        Index sgIndex = ((IndexAbstraction)this.clusterService.state().getMetadata().getIndicesLookup().get(searchguardIndex)).getWriteIndex();
        if (sgIndex == null) {
            LOGGER.error("Unable to retrieve trial license (or create  a new one) because {} index does not exist", (Object)searchguardIndex);
            throw new RuntimeException(searchguardIndex + " does not exist");
        }
        IndexMetadata sgIndexMetaData = this.clusterService.state().getMetadata().index(sgIndex);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create or retrieve trial license from {} created with version {} and mapping type: {}", (Object)searchguardIndex, (Object)sgIndexMetaData.getCreationVersion(), (Object)sgIndexMetaData.mapping().type());
        }
        long created = System.currentTimeMillis();
        GetResponse get = (GetResponse)((GetRequestBuilder)this.privilegedClient.prepareGet().setIndex(searchguardIndex)).setId("tattr").get();
        if (get.isExists()) {
            created = (Long)get.getSource().get("val");
        } else {
            try {
                this.privilegedClient.index(((IndexRequest)new IndexRequest(searchguardIndex).id("tattr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).create(true).source("{\"val\": " + System.currentTimeMillis() + "}", XContentType.JSON)).actionGet();
            }
            catch (VersionConflictEngineException versionConflictEngineException) {
            }
            catch (Exception e) {
                LOGGER.error("Unable to index tattr", (Throwable)e);
            }
        }
        SearchGuardLicense result = SearchGuardLicense.createTrialLicense(LicenseRepository.formatDate(created), msg);
        result.dynamicValidate(this.clusterService);
        return result;
    }

    private synchronized void notifyAboutLicenseChanges(SearchGuardLicense license) {
        for (LicenseChangeListener listener : this.licenseChangeListeners) {
            listener.onChange(license);
        }
    }

    private static String formatDate(long date) {
        return new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH).format(new Date(date));
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    private void useLicense(SearchGuardLicenseKey licenseKey, SgDynamicConfiguration<?> config) {
        this.componentState.setConfigVersion(config != null ? config.getDocVersion() : -1L);
        if (licenseKey != null) {
            SearchGuardLicense license = licenseKey.getLicense();
            ValidationErrors validationErrors = license.dynamicValidate(this.clusterService);
            if (!validationErrors.hasErrors()) {
                this.componentState.setState(ComponentState.State.INITIALIZED, "using_valid_license");
                this.componentState.setConfigProperty("license_uid", (Object)license.getUid());
                this.effectiveLicense = license;
            } else {
                this.componentState.setState(ComponentState.State.INITIALIZED, "license_invalid");
                this.componentState.addDetail((Object)validationErrors);
                this.componentState.setConfigProperty("license_uid", (Object)license.getUid());
                this.effectiveLicense = license;
            }
            this.configuredLicense = this.configuredLicense;
            this.validationErrors = validationErrors;
        } else {
            this.componentState.setState(ComponentState.State.INITIALIZED, "no_license");
            this.configuredLicense = null;
            this.effectiveLicense = this.createOrGetTrial(null);
        }
        this.notifyAboutLicenseChanges(this.effectiveLicense);
        this.printInfoText(this.effectiveLicense);
    }

    private void printInfoText(SearchGuardLicense sgLicense) {
        if (sgLicense != null) {
            LOGGER.info("Search Guard License Type: " + String.valueOf((Object)sgLicense.getType()) + ", " + (sgLicense.isValid() ? "valid" : "invalid"));
            if (sgLicense.getExpiresInDays() <= 30L && sgLicense.isValid()) {
                LOGGER.warn("Your Search Guard license expires in " + sgLicense.getExpiresInDays() + " days.");
                System.out.println("Your Search Guard license expires in " + sgLicense.getExpiresInDays() + " days.");
            }
            if (!sgLicense.isValid()) {
                String reasons = String.join((CharSequence)"; ", sgLicense.getMsgs());
                LOGGER.error("You are running an unlicensed version of Search Guard. Reason(s): " + reasons);
                System.out.println("You are running an unlicensed version of Search Guard. Reason(s): " + reasons);
                System.err.println("You are running an unlicensed version of Search Guard. Reason(s): " + reasons);
            }
        }
    }

    public SearchGuardLicense getConfiguredLicense() {
        return this.configuredLicense;
    }

    public ValidationErrors getValidationErrors() {
        return this.validationErrors;
    }
}

