/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.MultiTenancyChecker;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexVersions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class MultiTenancyCheckerIndexNamesTest
extends TestCase {
    private final String indexName;
    private final boolean multiTenancyRelated;

    public MultiTenancyCheckerIndexNamesTest(String indexName, boolean multiTenancyRelated) {
        this.indexName = indexName;
        this.multiTenancyRelated = multiTenancyRelated;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({".kibana-event-log-7.17.12-000001", false}, {".kibana_1329513022_ittenant_7.17.12_001", true}, {".kibana_3292183_kirk_7.17.12_001", true}, {".signals_truststores", false}, {".ds-.logs-deprecation.elasticsearch-default-2023.09.14-000001", false}, {".kibana_8.7.0_001", false}, {".one_hundred", false}, {"iot", false}, {"generated_logs", false}, {".geoip_databases", false}, {".apm-custom-link", false}, {".kibana-event-log-8.7.0-000001", false}, {".kibana_3292183_kirk_8.7.0_001", true}, {".kibana_-152937574_admintenant_7.17.12_001", true}, {".kibana_-152937574_admintenant_8.7.0_001", true}, {".kibana_1329513022_ittenant_8.7.0_001", true}, {".kibana_1329513022_ittenant_8.7.0_002", true}, {".kibana_1329513022_ittenant_8.8.0_001", true}, {".kibana_1329513022_ittenant_8.11.3_001", true}, {".kibana_1329513022_ittenant_8.11.3_999", true}, {".kibana_109651354_spock_8.7.0_001", true}, {"apm-agent-configuration", false}, {".apm-source-map", false}, {".kibana_92668751_admin_8.7.0_001", true}, {".kibana_739956815_uksz_8.7.0_001", true}, {".kibana_task_manager_8.7.0_001", false}, {".kibana_-348653185_hrtenant_7.17.12_001", true}, {".kibana_task_manager_7.17.12_001", false}, {".tasks", false}, {".kibana_-348653185_hrtenant_8.7.0_001", true}, {".kibana_-348653185_hrtenant_18.17.103_001", true}, {".kibana_-348653185_hrtenant_18.17.103_0012", false}, {".kibana_-348653185_hrtenant_8.7.0_001_backup", false}, {".kibana_-348653185_hrtenant_8.7.0_001_2", false}, {".kibana_-348653185_hrtenant_8.7.0_001_2023_12_11", false}, {".kibana_109651354_spock_7.17.12_001", true}, {".kibana_8.17.12_001", false}, {".kibana_8.9.12_001", false}, {".kibana_7.17.12_123", false}, {".kibana_739956815_uksz_7.17.12_001", true}, {".kibana_92668751_admin_7.17.12_001", true}, {".internal.alerts-observability.logs.alerts-default-000001", false}, {".ds-ilm-history-5-2023.12.12-000001", false}, {".kibana_security_solution_8.8.0_001", false}, {".internal.alerts-observability.metrics.alerts-default-000001", false}, {".kibana-event-log-8.8.0-000001 ", false}, {".internal.alerts-observability.apm.alerts-default-000001", false}, {".internal.alerts-observability.slo.alerts-default-000001", false}, {".kibana_ingest_8.8.0_001", false}, {".kibana_analytics_8.8.0_001", false}, {".apm-agent-configuration", false}, {".kibana_task_manager_8.8.0_001", false}, {".internal.alerts-observability.uptime.alerts-default-000001", false}, {".async-search", false}, {".async-search", false});
    }

    @Test
    public void shouldDetermineIfIndexIsRelatedToMultiTenancy() {
        MultiTenancyChecker.IndexRepository indexRepository = (MultiTenancyChecker.IndexRepository)Mockito.mock(MultiTenancyChecker.IndexRepository.class);
        Settings settings = Settings.builder().put("searchguard.multi_tenancy_bootstrap_check_enabled", true).build();
        MultiTenancyChecker checker = new MultiTenancyChecker(settings, indexRepository);
        IndexMetadata mock = (IndexMetadata)Mockito.mock(IndexMetadata.class);
        Mockito.when((Object)mock.getCreationVersion()).thenReturn((Object)IndexVersions.V_8_3_0);
        ImmutableMap indices = ImmutableMap.of((Object)this.indexName, (Object)mock);
        Mockito.when((Object)indexRepository.findIndicesMetadata()).thenReturn((Object)indices);
        boolean currentIndexIsMultiTenancyRelated = checker.findMultiTenancyConfigurationError().isPresent();
        String reason = "Index " + this.indexName + " should be MT related " + this.multiTenancyRelated;
        MatcherAssert.assertThat((String)reason, (Object)currentIndexIsMultiTenancyRelated, (Matcher)Matchers.equalTo((Object)this.multiTenancyRelated));
    }
}

