/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchguard.test.helper.cluster.SimpleRestHandler;
import com.floragunn.searchsupport.action.ActionHandlerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestHeaderDefinition;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.junit.Assert;
import org.junit.Test;

public class SearchGuardInterceptorIntegrationTests {
    @Test
    public void testAllowCustomHeaders() throws Exception {
        try (LocalCluster.Embedded cluster = new LocalCluster.Builder().embedded().nodeSettings("searchguard.allow_custom_headers", ".*").singleNode().sslEnabled().plugin(MockActionPlugin.class).user("header_test_user", "secret", new TestSgConfig.Role("header_test_user_role").indexPermissions("*").on("*").clusterPermissions("*")).start();
             GenericRestClient restClient = cluster.getRestClient("header_test_user", "secret", new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.get("/_header_test", new Header[]{new BasicHeader("test_header_name", "test_header_value")});
            DocNode headers = httpResponse.getBodyAsDocNode().getAsNode("headers");
            Assert.assertEquals((Object)"test_header_value", (Object)headers.get("test_header_name"));
        }
    }

    public static class MockActionPlugin
    extends Plugin
    implements ActionPlugin {
        public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
            return Arrays.asList(ActionHandlerFactory.actionHandler(MockTransportAction.TYPE, MockTransportAction.class));
        }

        public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
            return Arrays.asList(new RestHandler[]{new SimpleRestHandler<MockActionRequest, MockActionResponse>(new RestHandler.Route(RestRequest.Method.GET, "/_header_test"), MockTransportAction.TYPE, request -> new MockActionRequest(request.param("id")))});
        }

        public Collection<RestHeaderDefinition> getRestHeaders() {
            return Arrays.asList(new RestHeaderDefinition("test_header_name", true));
        }
    }

    public static class MockActionResponse
    extends ActionResponse
    implements ToXContentObject {
        private Map<String, String> headers;

        public MockActionResponse(Map<String, String> headers) {
            this.headers = headers;
        }

        public MockActionResponse(StreamInput in) throws IOException {
            this.headers = in.readMap(StreamInput::readString, StreamInput::readString);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("headers", this.headers);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        }

        public RestStatus status() {
            return RestStatus.OK;
        }
    }

    public static class MockActionRequest
    extends ActionRequest {
        private String id;

        public MockActionRequest(String id) {
            this.id = id;
        }

        public MockActionRequest(StreamInput in) throws IOException {
            this.id = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class MockTransportAction
    extends HandledTransportAction<MockActionRequest, MockActionResponse> {
        static ActionType<MockActionResponse> TYPE = new ActionType("cluster:admin/header_test");
        private ThreadPool threadPool;

        @Inject
        public MockTransportAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, AdminDNs adminDNs, ActionFilters actionFilters) {
            super(TYPE.name(), transportService, actionFilters, MockActionRequest::new, (Executor)threadPool.executor("generic"));
            this.threadPool = threadPool;
        }

        protected void doExecute(Task task, MockActionRequest request, ActionListener<MockActionResponse> listener) {
            listener.onResponse((Object)new MockActionResponse(this.threadPool.getThreadContext().getHeaders()));
        }
    }
}

