/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestAlias;
import com.floragunn.searchguard.test.TestData;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.Header;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class IgnoreUnauthorizedDisabledIntTest {
    static TestSgConfig.User LIMITED_USER_A = new TestSgConfig.User("limited_user_A").roles(new TestSgConfig.Role("limited_user_a_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("a*"));
    static TestSgConfig.User LIMITED_USER_B = new TestSgConfig.User("limited_user_B").roles(new TestSgConfig.Role("limited_user_b_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("b*"));
    static TestSgConfig.User LIMITED_USER_C = new TestSgConfig.User("limited_user_C").roles(new TestSgConfig.Role("limited_user_c_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("c*"));
    static TestSgConfig.User LIMITED_USER_D = new TestSgConfig.User("limited_user_D").roles(new TestSgConfig.Role("limited_user_d_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS").indexPermissions("SGS_CRUD", "indices:admin/refresh", "indices:data/write/delete/byquery").on("d*"));
    static TestSgConfig.User LIMITED_USER_A_B1 = new TestSgConfig.User("limited_user_A_B1").roles(new TestSgConfig.Role("limited_user_a_b1_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("a*").indexPermissions("SGS_CRUD").on("b1").aliasPermissions("SGS_CRUD").on("xalias_ab*"));
    static TestSgConfig.User UNLIMITED_USER = new TestSgConfig.User("unlimited_user").roles(new TestSgConfig.Role("unlimited_user_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("*").aliasPermissions("SGS_CRUD").on("*"));
    static TestIndex index_a1 = TestIndex.name("a1").documentCount(100).seed(1).attr("prefix", "a").build();
    static TestIndex index_a2 = TestIndex.name("a2").documentCount(110).seed(2).attr("prefix", "a").build();
    static TestIndex index_a3 = TestIndex.name("a3").documentCount(120).seed(3).attr("prefix", "a").build();
    static TestIndex index_b1 = TestIndex.name("b1").documentCount(51).seed(4).attr("prefix", "b").build();
    static TestIndex index_b2 = TestIndex.name("b2").documentCount(52).seed(5).attr("prefix", "b").build();
    static TestIndex index_b3 = TestIndex.name("b3").documentCount(53).seed(6).attr("prefix", "b").build();
    static TestIndex index_c1 = TestIndex.name("c1").documentCount(5).seed(7).attr("prefix", "c").build();
    static TestAlias xalias_ab1 = new TestAlias("xalias_ab1", index_a1, index_a2, index_a3, index_b1);
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().ignoreUnauthorizedIndices(false).users(LIMITED_USER_A, LIMITED_USER_B, LIMITED_USER_C, LIMITED_USER_D, LIMITED_USER_A_B1, UNLIMITED_USER).indices(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1).aliases(xalias_ab1).build();

    @Test
    public void search_noPattern() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get("/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
        }
        restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);
        try {
            httpResponse = restClient.get("/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_staticIndicies() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get("a1,a2,b1/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.containsInAnyOrder((Object[])new String[]{"a1", "a2", "b1"}))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);
        try {
            httpResponse = restClient.get("a1,a2,b1/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);
        try {
            httpResponse = restClient.get("a1,a2/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_C, new Header[0]);
        try {
            httpResponse = restClient.get("a1,a2,b1/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_indexPattern() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get("a*,b*/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.containsInAnyOrder((Object[])new String[]{"a1", "a2", "a3", "b1", "b2", "b3"}))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);
        try {
            httpResponse = restClient.get("a*,b*/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);
        try {
            httpResponse = restClient.get("a*/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.containsInAnyOrder((Object[])new String[]{"a1", "a2", "a3"}))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_C, new Header[0]);
        try {
            httpResponse = restClient.get("a*,b*/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_all() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get("_all/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
        }
        restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);
        try {
            httpResponse = restClient.get("_all/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_C, new Header[0]);
        try {
            httpResponse = restClient.get("_all/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_wildcard() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get("*/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.containsInAnyOrder((Object[])new String[]{"a1", "a2", "a3", "b1", "b2", "b3", "c1"}))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);
        try {
            httpResponse = restClient.get("*/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_C, new Header[0]);
        try {
            httpResponse = restClient.get("*/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_staticNonExisting() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        try (GenericRestClient restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);){
            httpResponse = restClient.get("ax/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isNotFound());
        }
        restClient = cluster.getRestClient(LIMITED_USER_C, new Header[0]);
        try {
            httpResponse = restClient.get("ax/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_alias() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get("xalias_ab1/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.containsInAnyOrder((Object[])new String[]{"a1", "a2", "a3", "b1"}))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);
        try {
            httpResponse = restClient.get("xalias_ab1/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_A_B1, new Header[0]);
        try {
            httpResponse = restClient.get("xalias_ab1/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.containsInAnyOrder((Object[])new String[]{"a1", "a2", "a3", "b1"}))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void msearch_staticIndices() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String msearchBody = "{\"index\":\"a1\"}\n{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}\n{\"index\":\"a2\"}\n{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}\n";
        try (GenericRestClient restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);){
            httpResponse = restClient.postJson("/_msearch", msearchBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].hits.hits[*]._index", Matchers.containsInAnyOrder((Object[])new String[]{"a1", "a2"}))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_B, new Header[0]);
        try {
            httpResponse = restClient.postJson("/_msearch", msearchBody, new Header[0]);
            System.out.println(httpResponse.getBody());
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].error.type", Matchers.containsInAnyOrder((Object[])new String[]{"security_exception"}))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void mget() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        TestData.TestDocument testDocumentA1 = index_a1.getTestData().anyDocument();
        TestData.TestDocument testDocumentB2 = index_b2.getTestData().anyDocument();
        DocNode mget = DocNode.of((String)"docs", Arrays.asList(DocNode.of((String)"_index", (Object)"a1", (String)"_id", (Object)testDocumentA1.getId()), DocNode.of((String)"_index", (Object)"b1", (String)"_id", (Object)testDocumentB2.getId())));
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.postJson("/_mget", (Map<String, Object>)mget, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("docs[*]._index", Matchers.containsInAnyOrder((Object[])new String[]{"a1", "b1"}))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);
        try {
            httpResponse = restClient.postJson("/_mget", (Map<String, Object>)mget, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("docs[?(@._index == 'a1')].found", Matchers.containsInAnyOrder((Object[])new Boolean[]{true}))}));
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("docs[?(@._index == 'b1')].error.type", Matchers.containsInAnyOrder((Object[])new String[]{"security_exception"}))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_termsAggregation_index() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String aggregationBody = "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":40}}}}";
        try (GenericRestClient restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);){
            httpResponse = restClient.postJson("/_search", aggregationBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);
        try {
            httpResponse = restClient.postJson("a*/_search", aggregationBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("aggregations.indices.buckets[*].key", Matchers.containsInAnyOrder((Object[])new String[]{"a1", "a2", "a3"}))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }
}

