/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestAlias;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import org.apache.http.Header;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class IgnoreUnauthorizedDisabledWithLegacyIndexIntTest {
    static TestSgConfig.User LIMITED_USER_A = new TestSgConfig.User("limited_user_A").roles(new TestSgConfig.Role("limited_user_a_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("a*"));
    static TestSgConfig.User LIMITED_USER_B = new TestSgConfig.User("limited_user_B").roles(new TestSgConfig.Role("limited_user_b_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("b*"));
    static TestSgConfig.User LIMITED_USER_C = new TestSgConfig.User("limited_user_C").roles(new TestSgConfig.Role("limited_user_c_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("c*"));
    static TestSgConfig.User LIMITED_USER_D = new TestSgConfig.User("limited_user_D").roles(new TestSgConfig.Role("limited_user_d_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS").indexPermissions("SGS_CRUD", "indices:admin/refresh", "indices:data/write/delete/byquery").on("d*"));
    static TestSgConfig.User LIMITED_USER_A_B1 = new TestSgConfig.User("limited_user_A_B1").roles(new TestSgConfig.Role("limited_user_a_b1_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("a*").indexPermissions("SGS_CRUD").on("b1"));
    static TestSgConfig.User UNLIMITED_USER = new TestSgConfig.User("unlimited_user").roles(new TestSgConfig.Role("unlimited_user_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("*").aliasPermissions("*").on("*"));
    static TestIndex index_a1 = TestIndex.name("a1").documentCount(100).seed(1).attr("prefix", "a").build();
    static TestIndex index_a2 = TestIndex.name("a2").documentCount(110).seed(2).attr("prefix", "a").build();
    static TestIndex index_a3 = TestIndex.name("a3").documentCount(120).seed(3).attr("prefix", "a").build();
    static TestIndex index_b1 = TestIndex.name("b1").documentCount(51).seed(4).attr("prefix", "b").build();
    static TestIndex index_b2 = TestIndex.name("b2").documentCount(52).seed(5).attr("prefix", "b").build();
    static TestIndex index_b3 = TestIndex.name("b3").documentCount(53).seed(6).attr("prefix", "b").build();
    static TestIndex index_c1 = TestIndex.name("c1").documentCount(5).seed(7).attr("prefix", "c").build();
    static TestAlias xalias_ab1 = new TestAlias("xalias_ab1", index_a1, index_a2, index_a3, index_b1);
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().embedded().singleNode().sslEnabled().ignoreUnauthorizedIndices(false).configIndexName("searchguard").users(LIMITED_USER_A, LIMITED_USER_B, LIMITED_USER_C, LIMITED_USER_D, LIMITED_USER_A_B1, UNLIMITED_USER).indices(index_a1, index_a2, index_a3, index_b1, index_b2, index_b3, index_c1).aliases(xalias_ab1).build();

    @Test
    public void search_noPattern() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get("/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);
        try {
            httpResponse = restClient.get("/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_all() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get("_all/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);
        try {
            httpResponse = restClient.get("_all/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_C, new Header[0]);
        try {
            httpResponse = restClient.get("_all/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_wildcard() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get("*/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);
        try {
            httpResponse = restClient.get("*,-searchguard/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.containsInAnyOrder((Object[])new String[]{"a1", "a2", "a3", "b1", "b2", "b3", "c1"}))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_A, new Header[0]);
        try {
            httpResponse = restClient.get("*/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_C, new Header[0]);
        try {
            httpResponse = restClient.get("*/_search?size=1000", new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }
}

