/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.int_tests;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.List;
import org.apache.http.Header;
import org.hamcrest.BaseMatcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={DefaultMode.class, BothMode.class})
public class BasicRoleMappingIntTests {
    static TestSgConfig.User SIMPLE_USER = new TestSgConfig.User("simple_user").backendRoles("backend_role_1", "backend_role_2", "backend_role_unmapped");
    static TestSgConfig.User SIMPLE_USER_SG_ROLES = new TestSgConfig.User("simple_user_sg_roles").roles("sg_role_1", "sg_role_2");
    static TestSgConfig.RoleMapping[] ROLE_MAPPING = new TestSgConfig.RoleMapping[]{new TestSgConfig.RoleMapping("role_1").backendRoles("backend_role_1"), new TestSgConfig.RoleMapping("role_2").backendRoles("backend_role_2")};
    static List<TestSgConfig.User> USERS = ImmutableList.of((Object)SIMPLE_USER, (Object)SIMPLE_USER_SG_ROLES);

    public static class BothMode {
        @ClassRule
        public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().users(USERS).roleMapping(ROLE_MAPPING).roleMappingResolutionMode("BOTH").build();

        @Test
        public void basicUserMapping_authInfo() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(SIMPLE_USER, new Header[0]);){
                GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("sg_roles", Matchers.containsInAnyOrder((Object[])new String[]{"role_1", "role_2", "backend_role_1", "backend_role_2", "backend_role_unmapped"}))}));
            }
        }

        @Test
        public void basicUserMapping_sgRoles_authInfo() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(SIMPLE_USER_SG_ROLES, new Header[0]);){
                GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("sg_roles", Matchers.containsInAnyOrder((Object[])new String[]{"sg_role_1", "sg_role_2"}))}));
            }
        }
    }

    public static class DefaultMode {
        @ClassRule
        public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().users(USERS).roleMapping(ROLE_MAPPING).build();

        @Test
        public void basicUserMapping_authInfo() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(SIMPLE_USER, new Header[0]);){
                GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("sg_roles", Matchers.containsInAnyOrder((Object[])new String[]{"role_1", "role_2"}))}));
            }
        }

        @Test
        public void basicUserMapping_sgRoles_authInfo() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(SIMPLE_USER_SG_ROLES, new Header[0]);){
                GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("sg_roles", Matchers.containsInAnyOrder((Object[])new String[]{"sg_role_1", "sg_role_2"}))}));
            }
        }
    }
}

