/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.int_tests;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.IndexApiMatchers;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestAlias;
import com.floragunn.searchguard.test.TestComponentTemplate;
import com.floragunn.searchguard.test.TestDataStream;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestIndexTemplate;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={SqlAuthorizationTests.class, SqlAuthorizationFlsFmTests.class})
public class SqlAuthorizationReadOnlyIntTests {
    static final Pattern HEX_HASH_PATTERN = Pattern.compile("[0-9a-f]{64}");
    static TestIndex index_a1 = TestIndex.name("index_a1").documentCount(100).attr("index_or_ds", "index_a1").seed(2).build();
    static TestIndex index_a2 = TestIndex.name("index_a2").documentCount(100).attr("index_or_ds", "index_a2").seed(3).build();
    static TestIndex index_b1 = TestIndex.name("index_b1").documentCount(100).attr("index_or_ds", "index_b1").seed(4).build();
    static TestIndex index_b2 = TestIndex.name("index_b2").documentCount(100).attr("index_or_ds", "index_b2").seed(5).build();
    static TestAlias alias_a = new TestAlias("alias_a", index_a1, index_a2);
    static TestAlias alias_b = new TestAlias("alias_b", index_b1, index_b2);
    static TestDataStream ds_a = TestDataStream.name("ds_a").documentCount(100).attr("index_or_ds", "ds_a").seed(6).rolloverAfter(10).build();
    static TestDataStream ds_b = TestDataStream.name("ds_b").documentCount(100).attr("index_or_ds", "ds_b").seed(7).rolloverAfter(10).build();
    static TestSgConfig.User USER_INDEX_A1 = new TestSgConfig.User("user_index_a1").description("user with access to index a1").roles(new TestSgConfig.Role("r1").clusterPermissions("indices:data/read/sql", "indices:data/read/sql/close_cursor", "indices:data/read/close_point_in_time").indexPermissions("indices:data/read/field_caps", "indices:data/read/open_point_in_time", "indices:data/read/search").on("index_a1")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(index_a1));
    static TestSgConfig.User USER_INDEX_A1_WITH_DLS = new TestSgConfig.User("user_index_a1_with_dls").description("user with access to index a1, and dls excluding dept_d").roles(new TestSgConfig.Role("r1").clusterPermissions("indices:data/read/sql", "indices:data/read/sql/close_cursor", "indices:data/read/close_point_in_time").indexPermissions("indices:data/read/field_caps", "indices:data/read/open_point_in_time", "indices:data/read/search").dls("{ \"bool\": { \"must_not\": { \"match\": { \"dept\": \"dept_d\" }}}}").on("index_a1")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(index_a1.filteredBy(doc -> !doc.getAsString("dept").equals("dept_d"))));
    static TestSgConfig.User USER_INDEX_A2 = new TestSgConfig.User("user_index_a2").description("user with access to index a2").roles(new TestSgConfig.Role("r1").clusterPermissions("indices:data/read/sql", "indices:data/read/sql/close_cursor", "indices:data/read/close_point_in_time").indexPermissions("indices:data/read/field_caps", "indices:data/read/open_point_in_time", "indices:data/read/search").on("index_a2")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(index_a2));
    static TestSgConfig.User USER_INDEX_B1 = new TestSgConfig.User("user_index_b1").description("user with access to index b1").roles(new TestSgConfig.Role("r1").clusterPermissions("indices:data/read/sql", "indices:data/read/sql/close_cursor", "indices:data/read/close_point_in_time").indexPermissions("indices:data/read/field_caps", "indices:data/read/open_point_in_time", "indices:data/read/search").on("index_b1")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(index_b1));
    static TestSgConfig.User USER_INDEX_B2 = new TestSgConfig.User("user_index_b2").description("user with access to index b2").roles(new TestSgConfig.Role("r1").clusterPermissions("indices:data/read/sql", "indices:data/read/sql/close_cursor", "indices:data/read/close_point_in_time").indexPermissions("indices:data/read/field_caps", "indices:data/read/open_point_in_time", "indices:data/read/search").on("index_b2")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(index_b2));
    static TestSgConfig.User USER_ALL_INDICES = new TestSgConfig.User("user_all_indices").description("user with access to all indices").roles(new TestSgConfig.Role("r1").clusterPermissions("indices:data/read/sql", "indices:data/read/sql/close_cursor", "indices:data/read/close_point_in_time").indexPermissions("indices:data/read/field_caps", "indices:data/read/open_point_in_time", "indices:data/read/search").on("index_*")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(index_a1, index_a2, index_b1, index_b2));
    static TestSgConfig.User USER_ALIAS_A = new TestSgConfig.User("user_alias_a").description("user with access to alias a").roles(new TestSgConfig.Role("r1").clusterPermissions("indices:data/read/sql", "indices:data/read/sql/close_cursor", "indices:data/read/close_point_in_time").aliasPermissions("indices:data/read/field_caps", "indices:data/read/open_point_in_time", "indices:data/read/search").on("alias_a")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(index_a1, index_a2, alias_a));
    static TestSgConfig.User USER_ALIAS_A_WITH_DLS = new TestSgConfig.User("user_alias_a_with_dls").description("user with access to alias a, and dls excluding dept_d").roles(new TestSgConfig.Role("r1").clusterPermissions("indices:data/read/sql", "indices:data/read/sql/close_cursor", "indices:data/read/close_point_in_time").aliasPermissions("indices:data/read/field_caps", "indices:data/read/open_point_in_time", "indices:data/read/search").dls("{ \"bool\": { \"must_not\": { \"match\": { \"dept\": \"dept_d\" }}}}").on("alias_a")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(index_a1.filteredBy(doc -> !doc.getAsString("dept").equals("dept_d")), index_a2.filteredBy(doc -> !doc.getAsString("dept").equals("dept_d")), alias_a.filteredBy(doc -> !doc.getAsString("dept").equals("dept_d"))));
    static TestSgConfig.User USER_ALIAS_B = new TestSgConfig.User("user_alias_b").description("user with access to alias b").roles(new TestSgConfig.Role("r1").clusterPermissions("indices:data/read/sql", "indices:data/read/sql/close_cursor", "indices:data/read/close_point_in_time").aliasPermissions("indices:data/read/field_caps", "indices:data/read/open_point_in_time", "indices:data/read/search").on("alias_b")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(index_b1, index_b2, alias_b));
    static TestSgConfig.User USER_DS_A = new TestSgConfig.User("user_ds_a").description("user with access to data stream a").roles(new TestSgConfig.Role("r1").clusterPermissions("indices:data/read/sql", "indices:data/read/sql/close_cursor", "indices:data/read/close_point_in_time").dataStreamPermissions("indices:data/read/field_caps", "indices:data/read/open_point_in_time", "indices:data/read/search").on("ds_a")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(ds_a));
    static TestSgConfig.User USER_DS_B = new TestSgConfig.User("user_ds_b").description("user with access to data stream b").roles(new TestSgConfig.Role("r1").clusterPermissions("indices:data/read/sql", "indices:data/read/sql/close_cursor", "indices:data/read/close_point_in_time").dataStreamPermissions("indices:data/read/field_caps", "indices:data/read/open_point_in_time", "indices:data/read/search").on("ds_b")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(ds_b));
    static TestSgConfig.User USER_DS_B_WITH_DLS = new TestSgConfig.User("user_ds_b_with_dls").description("user with access to data stream b, and dls excluding dept_d").roles(new TestSgConfig.Role("r1").clusterPermissions("indices:data/read/sql", "indices:data/read/sql/close_cursor", "indices:data/read/close_point_in_time").dataStreamPermissions("indices:data/read/field_caps", "indices:data/read/open_point_in_time", "indices:data/read/search").dls("{ \"bool\": { \"must_not\": { \"match\": { \"dept\": \"dept_d\" }}}}").on("ds_b")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(ds_b.filteredBy(doc -> !doc.getAsString("dept").equals("dept_d"))));
    static TestSgConfig.User USER_ALL_DS = new TestSgConfig.User("user_all_ds").description("user with access to all data streams").roles(new TestSgConfig.Role("r1").clusterPermissions("indices:data/read/sql", "indices:data/read/sql/close_cursor", "indices:data/read/close_point_in_time").dataStreamPermissions("indices:data/read/field_caps", "indices:data/read/open_point_in_time", "indices:data/read/search").on("ds_*")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(ds_a, ds_b));
    static TestSgConfig.User UNLIMITED_USER = new TestSgConfig.User("unlimited_user").description("unlimited").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").indexPermissions("*").on("*").aliasPermissions("*").on("*").dataStreamPermissions("*").on("*")).indexMatcher("read", IndexApiMatchers.sqlLimitedTo(index_a1, index_a2, index_b1, index_b2, alias_a, alias_b, ds_a, ds_b));
    static TestSgConfig.User UNLIMITED_USER_WITH_FLS = new TestSgConfig.User("unlimited_user_with_fls").description("unlimited, but has FLS on *_loc fields").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").aliasPermissions("*").fls("~*_loc").on("*").dataStreamPermissions("*").fls("~*_loc").on("*")).addFieldValueMatcher("$.columns[*].name", false, Matchers.everyItem((Matcher)Matchers.not((Matcher)Matchers.endsWith((String)"_loc")))).addFieldValueMatcher("$.rows[*]", true, Matchers.contains((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN))}));
    static TestSgConfig.User UNLIMITED_USER_WITH_FM = new TestSgConfig.User("unlimited_user_with_fm").description("unlimited, but has fm on *_ip fields").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "SGS_CLUSTER_MONITOR").aliasPermissions("*").maskedFields("*_ip").on("*").dataStreamPermissions("*").maskedFields("*_ip").on("*")).addFieldValueMatcher("$.columns[*].name", false, Matchers.hasItem((Matcher)Matchers.endsWith((String)"_loc"))).addFieldValueMatcher("$.rows[*]", true, Matchers.contains((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.nullValue()}));
    static TestSgConfig.User SUPER_UNLIMITED_USER = new TestSgConfig.User("super_unlimited_user").description("super unlimited (admin cert)").adminCertUser().indexMatcher("read", IndexApiMatchers.sqlLimitedTo(index_a1, index_a2, index_b1, index_b2, alias_a, alias_b, ds_a, ds_b)).addFieldValueMatcher("$.columns[*].name", false, Matchers.hasItem((Matcher)Matchers.endsWith((String)"_loc"))).addFieldValueMatcher("$.rows[*]", true, Matchers.contains((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN)), Matchers.not((Matcher)Matchers.matchesPattern((Pattern)HEX_HASH_PATTERN))}));
    static List<TestSgConfig.User> USERS = ImmutableList.of((Object)USER_INDEX_A1, (Object)USER_INDEX_A1_WITH_DLS, (Object)USER_INDEX_A2, (Object[])new TestSgConfig.User[]{USER_INDEX_B1, USER_INDEX_B2, USER_ALL_INDICES, USER_ALIAS_A, USER_ALIAS_A_WITH_DLS, USER_ALIAS_B, USER_DS_A, USER_DS_B, USER_DS_B_WITH_DLS, USER_ALL_DS, UNLIMITED_USER, UNLIMITED_USER_WITH_FLS, UNLIMITED_USER_WITH_FM, SUPER_UNLIMITED_USER});
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().users(USERS).indexTemplates(new TestIndexTemplate("ds_test", "ds_*").dataStream().composedOf(TestComponentTemplate.DATA_STREAM_MINIMAL)).indices(index_a1, index_a2, index_b1, index_b2).aliases(alias_a, alias_b).dataStreams(ds_a, ds_b).authzDebug(true).useExternalProcessCluster().enterpriseModulesEnabled().build();

    @RunWith(value=Parameterized.class)
    public static class SqlAuthorizationFlsFmTests {
        final TestSgConfig.User user;
        static List<TestSgConfig.User> USERS = ImmutableList.of((Object)UNLIMITED_USER_WITH_FLS, (Object)UNLIMITED_USER_WITH_FM, (Object)SUPER_UNLIMITED_USER, (Object[])new TestSgConfig.User[0]);

        public SqlAuthorizationFlsFmTests(TestSgConfig.User user, String description) {
            this.user = user;
        }

        @Parameterized.Parameters(name="{1}")
        public static Collection<Object[]> params() {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            for (TestSgConfig.User user : USERS) {
                result.add(new Object[]{user, user.getDescription()});
            }
            return result;
        }

        @Test
        public void queryIndicesWildcard_fls() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                GenericRestClient.HttpResponse response = client.postSql("SELECT * FROM \"index_a*\"", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, this.user.matcherForField("$.columns[*].name"));
            }
        }

        @Test
        public void queryAliasesWildcard_fls() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                GenericRestClient.HttpResponse response = client.postSql("SELECT * FROM \"alias_*\"", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, this.user.matcherForField("$.columns[*].name"));
            }
        }

        @Test
        public void queryDataStreamsWildcard_fls() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                GenericRestClient.HttpResponse response = client.postSql("SELECT * FROM \"ds_*\"", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, this.user.matcherForField("$.columns[*].name"));
            }
        }

        @Test
        public void queryIndicesWildcard_fm() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                GenericRestClient.HttpResponse response = client.postSql("SELECT dept, source_ip FROM \"index_a*\"", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, this.user.matcherForField("$.rows[*]"));
            }
        }

        @Test
        public void queryAliasesWildcard_fm() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                GenericRestClient.HttpResponse response = client.postSql("SELECT dept, source_ip FROM \"alias_*\"", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, this.user.matcherForField("$.rows[*]"));
            }
        }

        @Test
        public void queryDataStreamsWildcard_fm() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                GenericRestClient.HttpResponse response = client.postSql("SELECT dept, source_ip FROM \"ds_*\"", new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, this.user.matcherForField("$.rows[*]"));
            }
        }

        @Test
        public void queryIndicesWildcard_withCursor_fls() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                DocNode body = DocNode.of((String)"query", (Object)"SELECT * FROM \"index_a*\"", (String)"fetch_size", (Object)5);
                GenericRestClient.HttpResponse response = client.postSql((Map<String, Object>)body, new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, this.user.matcherForField("$.columns[*].name"));
                int numberOfValuesInRow = response.getBodyAsDocNode().findByJsonPath("$.columns[*]").size();
                MatcherAssert.assertThat((String)response.getBody(), (Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("$.cursor", Matchers.notNullValue())}));
                String cursor = response.getBodyAsDocNode().getAsString("cursor");
                response = client.postSql((Map<String, Object>)DocNode.of((String)"cursor", (Object)cursor), new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("$.rows[*]", Matchers.everyItem((Matcher)Matchers.hasSize((int)numberOfValuesInRow)))}));
                response = client.postJson("/_sql/close", (Map<String, Object>)DocNode.of((String)"cursor", (Object)cursor), new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            }
        }

        @Test
        public void queryIndicesWildcard_withCursor_fm() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                DocNode body = DocNode.of((String)"query", (Object)"SELECT dept, source_ip FROM \"index_a*\"", (String)"fetch_size", (Object)5);
                GenericRestClient.HttpResponse response = client.postSql((Map<String, Object>)body, new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, this.user.matcherForField("$.rows[*]"));
                MatcherAssert.assertThat((String)response.getBody(), (Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("$.cursor", Matchers.notNullValue())}));
                String cursor = response.getBodyAsDocNode().getAsString("cursor");
                response = client.postSql((Map<String, Object>)DocNode.of((String)"cursor", (Object)cursor), new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, this.user.matcherForField("$.rows[*]"));
                response = client.postJson("/_sql/close", (Map<String, Object>)DocNode.of((String)"cursor", (Object)cursor), new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class SqlAuthorizationTests {
        final TestSgConfig.User user;
        static List<TestSgConfig.User> USERS = ImmutableList.of((Object)USER_INDEX_A1, (Object)USER_INDEX_A1_WITH_DLS, (Object)USER_INDEX_A2, (Object[])new TestSgConfig.User[]{USER_INDEX_B1, USER_INDEX_B2, USER_ALL_INDICES, USER_ALIAS_A, USER_ALIAS_A_WITH_DLS, USER_ALIAS_B, USER_DS_A, USER_DS_B, USER_DS_B_WITH_DLS, USER_ALL_DS, UNLIMITED_USER, SUPER_UNLIMITED_USER});

        public SqlAuthorizationTests(TestSgConfig.User user, String description) {
            this.user = user;
        }

        @Parameterized.Parameters(name="{1}")
        public static Collection<Object[]> params() {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            for (TestSgConfig.User user : USERS) {
                result.add(new Object[]{user, user.getDescription()});
            }
            return result;
        }

        @Test
        public void queryIndicesWildcard() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                GenericRestClient.HttpResponse response = client.postSql("SELECT * FROM \"index_a*\"", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)IndexApiMatchers.sqlLimitedTo(index_a1, index_a2).but(this.user.indexMatcher("read")).whenEmpty(400));
            }
        }

        @Test
        public void queryOneIndex() throws Exception {
            GenericRestClient.HttpResponse response;
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                response = client.postSql("SELECT * FROM \"index_a1\"", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)IndexApiMatchers.sqlLimitedTo(index_a1).but(this.user.indexMatcher("read")).whenEmpty(400));
            }
            client = cluster.getRestClient(this.user, new Header[0]);
            try {
                response = client.postSql("SELECT * FROM \"index_a2\"", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)IndexApiMatchers.sqlLimitedTo(index_a2).but(this.user.indexMatcher("read")).whenEmpty(400));
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
            client = cluster.getRestClient(this.user, new Header[0]);
            try {
                response = client.postSql("SELECT * FROM \"index_b1\"", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)IndexApiMatchers.sqlLimitedTo(index_b1).but(this.user.indexMatcher("read")).whenEmpty(400));
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }

        @Test
        public void queryAliasesWildcard() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                GenericRestClient.HttpResponse response = client.postSql("SELECT * FROM \"alias_*\"", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)IndexApiMatchers.sqlLimitedTo(index_a1, index_a2, index_b1, index_b2, alias_a, alias_b).but(this.user.indexMatcher("read")).whenEmpty(400));
            }
        }

        @Test
        public void queryOneAlias() throws Exception {
            GenericRestClient.HttpResponse response;
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                response = client.postSql("SELECT * FROM \"alias_a\"", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)IndexApiMatchers.sqlLimitedTo(index_a1, index_a2, alias_a).but(this.user.indexMatcher("read")).whenEmpty(400));
            }
            client = cluster.getRestClient(this.user, new Header[0]);
            try {
                response = client.postSql("SELECT * FROM \"alias_b\"", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)IndexApiMatchers.sqlLimitedTo(index_b1, index_b2, alias_b).but(this.user.indexMatcher("read")).whenEmpty(400));
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }

        @Test
        public void queryDataStreamsWildcard() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                GenericRestClient.HttpResponse response = client.postSql("SELECT * FROM \"ds_*\"", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)IndexApiMatchers.sqlLimitedTo(ds_a, ds_b).but(this.user.indexMatcher("read")).whenEmpty(400));
            }
        }

        @Test
        public void queryOneDataStream() throws Exception {
            GenericRestClient.HttpResponse response;
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                response = client.postSql("SELECT * FROM \"ds_a\"", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)IndexApiMatchers.sqlLimitedTo(ds_a).but(this.user.indexMatcher("read")).whenEmpty(400));
            }
            client = cluster.getRestClient(this.user, new Header[0]);
            try {
                response = client.postSql("SELECT * FROM \"ds_b\"", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)IndexApiMatchers.sqlLimitedTo(ds_b).but(this.user.indexMatcher("read")).whenEmpty(400));
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }

        @Test
        public void queryIndicesWildcard_withCursor() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                DocNode body = DocNode.of((String)"query", (Object)"SELECT * FROM \"index_a*\"", (String)"fetch_size", (Object)5);
                GenericRestClient.HttpResponse response = client.postSql((Map<String, Object>)body, new Header[0]);
                IndexApiMatchers.SqlLimitedToMatcher indexAliasMatcher = (IndexApiMatchers.SqlLimitedToMatcher)IndexApiMatchers.sqlLimitedTo(index_a1, index_a2).but(this.user.indexMatcher("read"));
                MatcherAssert.assertThat((Object)response, (Matcher)indexAliasMatcher.whenEmpty(400));
                if (!indexAliasMatcher.but(this.user.indexMatcher("read")).isEmpty()) {
                    MatcherAssert.assertThat((String)response.getBody(), (Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("$.cursor", Matchers.notNullValue())}));
                    String cursor = response.getBodyAsDocNode().getAsString("cursor");
                    response = client.postSql((Map<String, Object>)DocNode.of((String)"cursor", (Object)cursor), new Header[0]);
                    MatcherAssert.assertThat((Object)response, (Matcher)indexAliasMatcher.shouldContainColumns(false));
                    response = client.postJson("/_sql/close", (Map<String, Object>)DocNode.of((String)"cursor", (Object)cursor), new Header[0]);
                    MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                }
            }
        }

        @Test
        public void queryAliasesWildcard_withCursor() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                DocNode body = DocNode.of((String)"query", (Object)"SELECT * FROM \"alias_*\"", (String)"fetch_size", (Object)5);
                GenericRestClient.HttpResponse response = client.postSql((Map<String, Object>)body, new Header[0]);
                IndexApiMatchers.SqlLimitedToMatcher indexAliasMatcher = (IndexApiMatchers.SqlLimitedToMatcher)IndexApiMatchers.sqlLimitedTo(index_a1, index_a2, index_b1, index_b2, alias_a, alias_b).but(this.user.indexMatcher("read"));
                MatcherAssert.assertThat((Object)response, (Matcher)indexAliasMatcher.whenEmpty(400));
                if (!indexAliasMatcher.but(this.user.indexMatcher("read")).isEmpty()) {
                    MatcherAssert.assertThat((String)response.getBody(), (Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("$.cursor", Matchers.notNullValue())}));
                    String cursor = response.getBodyAsDocNode().getAsString("cursor");
                    response = client.postSql((Map<String, Object>)DocNode.of((String)"cursor", (Object)cursor), new Header[0]);
                    MatcherAssert.assertThat((Object)response, (Matcher)indexAliasMatcher.shouldContainColumns(false));
                    response = client.postJson("/_sql/close", (Map<String, Object>)DocNode.of((String)"cursor", (Object)cursor), new Header[0]);
                    MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                }
            }
        }

        @Test
        public void queryDataStreamsWildcard_withCursor() throws Exception {
            try (GenericRestClient client = cluster.getRestClient(this.user, new Header[0]);){
                DocNode body = DocNode.of((String)"query", (Object)"SELECT * FROM \"ds_*\"", (String)"fetch_size", (Object)5);
                GenericRestClient.HttpResponse response = client.postSql((Map<String, Object>)body, new Header[0]);
                IndexApiMatchers.SqlLimitedToMatcher dsMatcher = (IndexApiMatchers.SqlLimitedToMatcher)IndexApiMatchers.sqlLimitedTo(ds_a, ds_b).but(this.user.indexMatcher("read"));
                MatcherAssert.assertThat((Object)response, (Matcher)dsMatcher.whenEmpty(400));
                if (!dsMatcher.but(this.user.indexMatcher("read")).isEmpty()) {
                    MatcherAssert.assertThat((String)response.getBody(), (Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("$.cursor", Matchers.notNullValue())}));
                    String cursor = response.getBodyAsDocNode().getAsString("cursor");
                    response = client.postSql((Map<String, Object>)DocNode.of((String)"cursor", (Object)cursor), new Header[0]);
                    MatcherAssert.assertThat((Object)response, (Matcher)dsMatcher.shouldContainColumns(false));
                    response = client.postJson("/_sql/close", (Map<String, Object>)DocNode.of((String)"cursor", (Object)cursor), new Header[0]);
                    MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                }
            }
        }
    }
}

