/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.configuration.ProtectedConfigIndexService;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.AsyncAssert;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class ProtectedConfigIndexServiceTest {
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().sslEnabled().embedded().build();

    @Test
    public void mappingUpdate() throws Exception {
        ClusterService clusterService = cluster.getInjectable(ClusterService.class);
        ProtectedConfigIndexService service = new ProtectedConfigIndexService(cluster.getInternalNodeClient(), clusterService, cluster.getInjectable(ThreadPool.class), new SearchGuardPlugin.ProtectedIndices());
        service.createIndex(new ProtectedConfigIndexService.ConfigIndex(".test_mapping_update").mapping((Map)ImmutableMap.of((Object)"properties", (Object)ImmutableMap.of((Object)"x", (Object)ImmutableMap.of((Object)"type", (Object)"text")))));
        service.onNodeStart();
        AsyncAssert.awaitAssert((String)"Index created", () -> clusterService.state().getMetadata().indices().containsKey(".test_mapping_update"), (Duration)Duration.ofSeconds(10L));
        service = new ProtectedConfigIndexService(cluster.getInternalNodeClient(), clusterService, cluster.getInjectable(ThreadPool.class), new SearchGuardPlugin.ProtectedIndices());
        service.createIndex(new ProtectedConfigIndexService.ConfigIndex(".test_mapping_update").mapping((Map)ImmutableMap.of((Object)"properties", (Object)ImmutableMap.of((Object)"x", (Object)ImmutableMap.of((Object)"type", (Object)"text"), (Object)"y", (Object)ImmutableMap.of((Object)"type", (Object)"text"))), 2).mappingUpdate(0, (Map)ImmutableMap.of((Object)"properties", (Object)ImmutableMap.of((Object)"y", (Object)ImmutableMap.of((Object)"type", (Object)"text")))));
        service.onNodeStart();
        AsyncAssert.awaitAssert((String)"Index updated", () -> ((IndexMetadata)clusterService.state().getMetadata().indices().get(".test_mapping_update")).mapping().getSourceAsMap().get("properties").equals(ImmutableMap.of((Object)"x", (Object)ImmutableMap.of((Object)"type", (Object)"text"), (Object)"y", (Object)ImmutableMap.of((Object)"type", (Object)"text"))), (Duration)Duration.ofSeconds(10L));
    }

    @Test
    public void settingsAndMappingUpdate() throws Exception {
        String indexName = ".test_settings_mapping_update";
        ClusterService clusterService = cluster.getInjectable(ClusterService.class);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)cluster.getInternalNodeClient().admin().indices().create(new CreateIndexRequest(".test_settings_mapping_update").mapping((Map)ImmutableMap.of((Object)"properties", (Object)ImmutableMap.of((Object)"x", (Object)ImmutableMap.of((Object)"type", (Object)"text")))).waitForActiveShards(1)).actionGet();
        Assert.assertTrue((boolean)acknowledgedResponse.isAcknowledged());
        GetSettingsResponse getSettingsResponse = (GetSettingsResponse)cluster.getInternalNodeClient().admin().indices().getSettings(new GetSettingsRequest().indices(new String[]{".test_settings_mapping_update"})).actionGet();
        Assert.assertFalse((boolean)((Boolean)IndexMetadata.INDEX_HIDDEN_SETTING.get((Settings)getSettingsResponse.getIndexToSettings().get(".test_settings_mapping_update"))));
        ProtectedConfigIndexService service = new ProtectedConfigIndexService(cluster.getInternalNodeClient(), clusterService, cluster.getInjectable(ThreadPool.class), new SearchGuardPlugin.ProtectedIndices());
        service.createIndex(new ProtectedConfigIndexService.ConfigIndex(".test_settings_mapping_update").mapping((Map)ImmutableMap.of((Object)"properties", (Object)ImmutableMap.of((Object)"x", (Object)ImmutableMap.of((Object)"type", (Object)"text"), (Object)"y", (Object)ImmutableMap.of((Object)"type", (Object)"text"))), 2).mappingUpdate(0, (Map)ImmutableMap.of((Object)"properties", (Object)ImmutableMap.of((Object)"y", (Object)ImmutableMap.of((Object)"type", (Object)"text")))));
        service.onNodeStart();
        AsyncAssert.awaitAssert((String)"Index updated", () -> ((IndexMetadata)clusterService.state().getMetadata().indices().get(".test_settings_mapping_update")).mapping().getSourceAsMap().get("properties").equals(ImmutableMap.of((Object)"x", (Object)ImmutableMap.of((Object)"type", (Object)"text"), (Object)"y", (Object)ImmutableMap.of((Object)"type", (Object)"text"))), (Duration)Duration.ofSeconds(30L));
        AsyncAssert.awaitAssert((String)"Index hidden", () -> ((IndexMetadata)clusterService.state().getMetadata().indices().get(".test_settings_mapping_update")).isHidden(), (Duration)Duration.ofSeconds(10L));
    }

    @Test
    public void settingsUpdate() throws Exception {
        String indexName = ".test_settings_update";
        ClusterService clusterService = cluster.getInjectable(ClusterService.class);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)cluster.getInternalNodeClient().admin().indices().create(new CreateIndexRequest(".test_settings_update").waitForActiveShards(1)).actionGet();
        Assert.assertTrue((boolean)acknowledgedResponse.isAcknowledged());
        GetSettingsResponse getSettingsResponse = (GetSettingsResponse)cluster.getInternalNodeClient().admin().indices().getSettings(new GetSettingsRequest().indices(new String[]{".test_settings_update"})).actionGet();
        Assert.assertFalse((boolean)((Boolean)IndexMetadata.INDEX_HIDDEN_SETTING.get((Settings)getSettingsResponse.getIndexToSettings().get(".test_settings_update"))));
        ProtectedConfigIndexService service = new ProtectedConfigIndexService(cluster.getInternalNodeClient(), clusterService, cluster.getInjectable(ThreadPool.class), new SearchGuardPlugin.ProtectedIndices());
        service.createIndex(new ProtectedConfigIndexService.ConfigIndex(".test_settings_update"));
        service.onNodeStart();
        AsyncAssert.awaitAssert((String)"Index hidden", () -> ((IndexMetadata)clusterService.state().getMetadata().indices().get(".test_settings_update")).isHidden(), (Duration)Duration.ofSeconds(10L));
    }
}

