/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.api;

import com.floragunn.codova.documents.DocWriter;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import org.junit.Assert;
import org.junit.Test;

public class MigrateConfigIndexApiIntegrationTest {
    static TestSgConfig.User TEST_USER_A = new TestSgConfig.User("test_user_a").roles(new TestSgConfig.Role("test_user_a_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("a*"));
    static TestSgConfig.User TEST_USER_B = new TestSgConfig.User("test_user_b").roles(new TestSgConfig.Role("unlimited_user_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("*"));
    static TestIndex index_a1 = TestIndex.name("a1").documentCount(100).seed(1).attr("prefix", "a").build();
    static TestIndex index_b1 = TestIndex.name("b1").documentCount(51).seed(4).attr("prefix", "b").build();

    @Test
    public void test() throws Exception {
        try (LocalCluster.Embedded cluster = new LocalCluster.Builder().embedded().singleNode().sslEnabled().configIndexName("searchguard").users(TEST_USER_A, TEST_USER_B).indices(index_a1, index_b1).start();){
            ConfigurationRepository configurationRespository = cluster.getInjectable(ConfigurationRepository.class);
            Assert.assertEquals((Object)"searchguard", (Object)configurationRespository.getEffectiveSearchGuardIndex());
            SgDynamicConfiguration oldUsersConfig = configurationRespository.getConfiguration(CType.INTERNALUSERS);
            SgDynamicConfiguration oldRolesConfig = configurationRespository.getConfiguration(CType.ROLES);
            SgDynamicConfiguration oldAuthcConfig = configurationRespository.getConfiguration(CType.AUTHC);
            try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
                GenericRestClient.HttpResponse response = restClient.post("/_searchguard/config/migrate_index");
                System.out.println(response.getBody());
                Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
                Thread.sleep(500L);
                Assert.assertEquals((Object)".searchguard", (Object)configurationRespository.getEffectiveSearchGuardIndex());
                SgDynamicConfiguration newUsersConfig = configurationRespository.getConfiguration(CType.INTERNALUSERS);
                SgDynamicConfiguration newRolesConfig = configurationRespository.getConfiguration(CType.ROLES);
                SgDynamicConfiguration newAuthcConfig = configurationRespository.getConfiguration(CType.AUTHC);
                Assert.assertTrue((oldUsersConfig != newUsersConfig ? 1 : 0) != 0);
                Assert.assertTrue((oldRolesConfig != newRolesConfig ? 1 : 0) != 0);
                Assert.assertTrue((oldAuthcConfig != newAuthcConfig ? 1 : 0) != 0);
                Assert.assertEquals((Object)DocWriter.json().writeAsString((Object)oldUsersConfig.getCEntries()), (Object)DocWriter.json().writeAsString((Object)newUsersConfig.getCEntries()));
                Assert.assertEquals((Object)DocWriter.json().writeAsString((Object)oldRolesConfig.getCEntries()), (Object)DocWriter.json().writeAsString((Object)newRolesConfig.getCEntries()));
                Assert.assertEquals((Object)DocWriter.json().writeAsString((Object)oldAuthcConfig.getCEntries()), (Object)DocWriter.json().writeAsString((Object)newAuthcConfig.getCEntries()));
            }
        }
    }
}

