/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.validation;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.authz.config.Tenant;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.validation.RoleRelationsValidator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RoleRelationsValidatorTest {
    @Mock
    private ConfigurationRepository configurationRepository;
    private RoleRelationsValidator roleRelationsValidator;

    @Before
    public void setUp() throws Exception {
        this.roleRelationsValidator = new RoleRelationsValidator(this.configurationRepository);
    }

    @Test
    public void configEntry_shouldValidateRelations_noTenantMatchesGivenPattern() throws Exception {
        this.roleRelationsValidator.setConfigMap(null);
        Role role = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"fake")})), null).get();
        List validationErrors = this.roleRelationsValidator.validateConfigEntry((Object)role);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"_"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"Tenant pattern: 'fake' does not match any tenant"));
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"fake1", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        role = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"fake")})), null).get();
        validationErrors = this.roleRelationsValidator.validateConfigEntry((Object)role);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"_"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"Tenant pattern: 'fake' does not match any tenant"));
    }

    @Test
    public void configEntry_shouldValidateRelations_tenantMatchingGivenPatternExists() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"exists", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        Role role = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"exist*")})), null).get();
        List validationErrors = this.roleRelationsValidator.validateConfigEntry((Object)role);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.empty());
    }

    @Test
    public void configEntry_shouldDoNothing_configTypeNotSupported() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"exists", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        Tenant tenant = new Tenant(null, false, false, false, null);
        List validationErrors = this.roleRelationsValidator.validateConfigEntry((Object)tenant);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.empty());
    }

    @Test
    public void configEntry_shouldDoNothing_configIsNull() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"exists", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        Tenant tenant = new Tenant(null, false, false, false, null);
        List validationErrors = this.roleRelationsValidator.validateConfigEntry((Object)tenant);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.empty());
    }

    @Test
    public void config_shouldValidateRelations_noTenantMatchesOneOfGivenPatterns() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"exists", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        Role roleOne = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"fake")})), null).get();
        Role roleTwo = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"exists")})), null).get();
        SgDynamicConfiguration roleConfig = SgDynamicConfiguration.of((CType)CType.ROLES, (String)"role1", (Object)roleOne, (String)"role2", (Object)roleTwo);
        List validationErrors = this.roleRelationsValidator.validateConfig(roleConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"roles.role1"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"Tenant pattern: 'fake' does not match any tenant"));
    }

    @Test
    public void config_shouldValidateRelations_tenantsMatchingAllOfGivenPatternsExist() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"first", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"first test tenant"), null).get()), (String)"second", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"second test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        Role roleOne = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"firs*")})), null).get();
        Role roleTwo = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"se*nd")})), null).get();
        SgDynamicConfiguration roleConfig = SgDynamicConfiguration.of((CType)CType.ROLES, (String)"role1", (Object)roleOne, (String)"role2", (Object)roleTwo);
        List validationErrors = this.roleRelationsValidator.validateConfig(roleConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void config_shouldDoNothing_configTypeNotSupported() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"first", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"first test tenant"), null).get()), (String)"second", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"second test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        Tenant tenant = new Tenant(null, false, false, false, null);
        SgDynamicConfiguration config = SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"a", (Object)tenant);
        List validationErrors = this.roleRelationsValidator.validateConfig(config);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void config_shouldDoNothing_configIsNull() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"first", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"first test tenant"), null).get()), (String)"second", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"second test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        List validationErrors = this.roleRelationsValidator.validateConfig(null);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void configList_shouldValidateRelations_newRolesAndTenantsConfigsArePresent_noTenantMatchesOneOfGivenPatterns() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"first", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"first test tenant"), null).get()), (String)"second", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"second test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        Role roleOne = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"firs*")})), null).get();
        Role roleTwo = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"se*nd")})), null).get();
        SgDynamicConfiguration newRoleConfig = SgDynamicConfiguration.of((CType)CType.ROLES, (String)"role1", (Object)roleOne, (String)"role2", (Object)roleTwo);
        SgDynamicConfiguration newTenantConfig = SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"second", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"second test tenant"), null).get()), (String)"third", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"third test tenant"), null).get()));
        List validationErrors = this.roleRelationsValidator.validateConfigs((List)ImmutableList.of((Object)newRoleConfig, (Object)newTenantConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"roles.role1"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"Tenant pattern: 'firs*' does not match any tenant"));
    }

    @Test
    public void configList_shouldValidateRelations_newRolesAndTenantsConfigsArePresent_tenantsMatchingAllOfGivenPatternsExist() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"first", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"first test tenant"), null).get()), (String)"second", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"second test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        Role roleOne = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"thi*")})), null).get();
        Role roleTwo = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"fo*th")})), null).get();
        SgDynamicConfiguration newRoleConfig = SgDynamicConfiguration.of((CType)CType.ROLES, (String)"role1", (Object)roleOne, (String)"role2", (Object)roleTwo);
        SgDynamicConfiguration newTenantConfig = SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"third", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"third test tenant"), null).get()), (String)"fourth", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"fourth test tenant"), null).get()));
        List validationErrors = this.roleRelationsValidator.validateConfigs((List)ImmutableList.of((Object)newRoleConfig, (Object)newTenantConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void configList_shouldValidateRelations_onlyNewRolesConfigIsPresent_noTenantMatchesOneOfGivenPatterns() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"first", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"first test tenant"), null).get()), (String)"second", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"second test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        Role roleOne = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"firs*")})), null).get();
        Role roleTwo = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"se*nds")})), null).get();
        SgDynamicConfiguration newRoleConfig = SgDynamicConfiguration.of((CType)CType.ROLES, (String)"role1", (Object)roleOne, (String)"role2", (Object)roleTwo);
        List validationErrors = this.roleRelationsValidator.validateConfigs((List)ImmutableList.of((Object)newRoleConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"roles.role2"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"Tenant pattern: 'se*nds' does not match any tenant"));
    }

    @Test
    public void configList_shouldValidateRelations_onlyNewRolesConfigIsPresent_tenantsMatchingAllOfGivenPatternsExist() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"first", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"first test tenant"), null).get()), (String)"second", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"second test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        Role roleOne = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"f*")})), null).get();
        Role roleTwo = (Role)Role.parse((DocNode)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", (Object)"s*")})), null).get();
        SgDynamicConfiguration newRoleConfig = SgDynamicConfiguration.of((CType)CType.ROLES, (String)"role1", (Object)roleOne, (String)"role2", (Object)roleTwo);
        List validationErrors = this.roleRelationsValidator.validateConfigs((List)ImmutableList.of((Object)newRoleConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void configList_shouldValidateRelations_shouldDoNothing_listIsNull() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"first", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"first test tenant"), null).get()), (String)"second", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"second test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        List validationErrors = this.roleRelationsValidator.validateConfigs(null);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void configList_shouldValidateRelations_shouldDoNothing_listContainsOnlyNullElement() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)CType.TENANTS, (String)"first", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"first test tenant"), null).get()), (String)"second", (Object)((Tenant)Tenant.parse((DocNode)DocNode.of((String)"description", (Object)"second test tenant"), null).get())));
        this.roleRelationsValidator.setConfigMap(configMap);
        List validationErrors = this.roleRelationsValidator.validateConfigs((List)ImmutableList.of(null));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
    }

    private ConfigMap configMapWithConfig(SgDynamicConfiguration<?> config) {
        return new ConfigMap.Builder("index").with(config).build();
    }
}

