/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.variables;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class ConfigVarApiTest {
    private static final TestSgConfig.User ADMIN_USER = new TestSgConfig.User("admin").roles(new TestSgConfig.Role("allaccess").indexPermissions("*").on("*").clusterPermissions("*"));
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().sslEnabled().user(ADMIN_USER).build();

    @Test
    public void putGetDeleteTest() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String secretId = "test_var";
            String secretContent = "Blabla";
            String secretPath = "/_searchguard/config/vars/" + secretId;
            GenericRestClient.HttpResponse response = client.putJson(secretPath, DocWriter.json().writeAsString((Object)ImmutableMap.of((Object)"value", (Object)secretContent)), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            Thread.sleep(20L);
            response = client.get(secretPath, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)secretContent, (Object)response.getBodyAsDocNode().get("data", new String[]{"value"}));
            response = client.get("/_searchguard/config/vars", new Header[0]);
            DocNode responseDoc = response.getBodyAsDocNode();
            Assert.assertEquals((String)response.getBody(), (Object)secretContent, (Object)responseDoc.get("data", new String[]{secretId, "value"}));
            response = client.delete(secretPath, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Thread.sleep(50L);
            response = client.get(secretPath, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)404L, (long)response.getStatusCode());
        }
    }

    @Test
    public void indexMappingTest() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.putJson("/_searchguard/config/vars/m1", DocWriter.json().writeAsString((Object)ImmutableMap.of((Object)"value", (Object)1)), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = client.putJson("/_searchguard/config/vars/m2", DocWriter.json().writeAsString((Object)ImmutableMap.of((Object)"value", (Object)"foo")), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = client.putJson("/_searchguard/config/vars/m3", DocWriter.json().writeAsString((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2))), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            Thread.sleep(20L);
            response = client.get("/_searchguard/config/vars/m1", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)1, (Object)response.getBodyAsDocNode().get("data", new String[]{"value"}));
            response = client.get("/_searchguard/config/vars/m2", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)"foo", (Object)response.getBodyAsDocNode().get("data", new String[]{"value"}));
            response = client.get("/_searchguard/config/vars/m3", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2), (Object)response.getBodyAsDocNode().get("data", new String[]{"value"}));
        }
    }

    @Test
    public void encryptedPutGetDeleteTest() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String secretId = "test_secret";
            String secretContent = "Foobar";
            String secretPath = "/_searchguard/config/vars/" + secretId;
            GenericRestClient.HttpResponse response = client.putJson(secretPath, DocWriter.json().writeAsString((Object)ImmutableMap.of((Object)"value", (Object)secretContent, (Object)"encrypt", (Object)true)), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            Thread.sleep(20L);
            response = client.get(secretPath, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertNotNull((String)response.getBody(), (Object)response.getBodyAsDocNode().get("data", new String[]{"encrypted", "value"}));
            response = client.get("/_searchguard/config/vars", new Header[0]);
            DocNode responseDoc = response.getBodyAsDocNode();
            Assert.assertNotNull((String)response.getBody(), (Object)responseDoc.get("data", new String[]{secretId, "encrypted", "value"}));
            response = client.delete(secretPath, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Thread.sleep(50L);
            response = client.get(secretPath, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)404L, (long)response.getStatusCode());
        }
    }

    @Test
    public void putIfNoneMatchTest() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String secretId = "test_if_n_m";
            String secretContent = "Blabla";
            String secretPath = "/_searchguard/config/vars/" + secretId;
            GenericRestClient.HttpResponse response = client.putJson(secretPath, DocWriter.json().writeAsString((Object)ImmutableMap.of((Object)"value", (Object)secretContent)), new Header[]{new BasicHeader("If-None-Match", "*")});
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            Thread.sleep(20L);
            response = client.putJson(secretPath, DocWriter.json().writeAsString((Object)ImmutableMap.of((Object)"value", (Object)(secretContent + "2"))), new Header[]{new BasicHeader("If-None-Match", "*")});
            Assert.assertEquals((String)response.getBody(), (long)412L, (long)response.getStatusCode());
            response = client.putJson(secretPath, DocWriter.json().writeAsString((Object)ImmutableMap.of((Object)"value", (Object)(secretContent + "2"))), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
        }
    }

    @Test
    public void putTestWithoutAdminCert() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(ADMIN_USER, new Header[0]);){
            GenericRestClient.HttpResponse updateResponse = client.putJson("/_searchguard/config/vars/foobar", DocWriter.json().writeAsString((Document)DocNode.of((String)"a", (Object)"b")), new Header[0]);
            Assert.assertEquals((String)updateResponse.getBody(), (long)403L, (long)updateResponse.getStatusCode());
        }
    }
}

