/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.DocumentParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.SelfDescribing;

public class SgMatchers {
    public static DiagnosingMatcher<String> equalsAsJson(final Object expectedObjectStructure) {
        Object rewrittenExpectedObjectStructure;
        try {
            rewrittenExpectedObjectStructure = SgMatchers.parseJson(DocWriter.json().writeAsString(expectedObjectStructure));
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        return new DiagnosingMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText("equals as JSON to ").appendValue(expectedObjectStructure);
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                Object parsedItem;
                if (!(item instanceof String)) {
                    mismatchDescription.appendValue(item).appendText(" is not a string");
                    return false;
                }
                try {
                    parsedItem = SgMatchers.parseJson((String)item);
                }
                catch (DocumentParseException e) {
                    mismatchDescription.appendValue(item).appendText(" is not valid JSON: " + String.valueOf((Object)e));
                    return false;
                }
                if (parsedItem.equals(rewrittenExpectedObjectStructure)) {
                    return true;
                }
                mismatchDescription.appendValue(parsedItem).appendText(" does not equal ").appendValue(rewrittenExpectedObjectStructure);
                return false;
            }
        };
    }

    public static DiagnosingMatcher<String> segment(final String patternString, final BaseMatcher<String> subMatcher) {
        return new DiagnosingMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText("segment " + patternString + " ").appendDescriptionOf((SelfDescribing)subMatcher);
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                if (!(item instanceof String)) {
                    mismatchDescription.appendValue(item).appendText(" is not a string");
                    return false;
                }
                String segment = SgMatchers.getStringSegment(patternString, (String)item);
                if (segment != null) {
                    if (subMatcher.matches((Object)segment)) {
                        return true;
                    }
                    subMatcher.describeMismatch((Object)segment, mismatchDescription);
                    return false;
                }
                mismatchDescription.appendText("Could not find pattern " + patternString + " in").appendValue(item);
                return false;
            }
        };
    }

    public static String getStringSegment(String patternString, String input) {
        Pattern pattern = Pattern.compile("^" + patternString + "$", 8);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static Object parseJson(String json) throws DocumentParseException {
        if (json == null) {
            return null;
        }
        return DocReader.json().read(json);
    }
}

