/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import org.apache.http.Header;
import org.elasticsearch.action.search.SearchContextId;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.hamcrest.MatcherAssert;

public class PitHolder
implements AutoCloseable {
    private final GenericRestClient genericRestClient;
    private final GenericRestClient.HttpResponse response;

    public static HolderClient of(GenericRestClient genericRestClient) {
        return new HolderClient(genericRestClient);
    }

    private PitHolder(GenericRestClient genericRestClient, GenericRestClient.HttpResponse response) {
        this.genericRestClient = genericRestClient;
        this.response = response;
    }

    public String getPitId() {
        MatcherAssert.assertThat((Object)this.response, RestMatchers.isOk());
        try {
            return this.response.getBodyAsDocNode().getAsString("id");
        }
        catch (DocumentParseException | Format.UnknownDocTypeException e) {
            throw new RuntimeException("Cannot retrieve PIT id", e);
        }
    }

    public DocNode asSearchBody() {
        MatcherAssert.assertThat((Object)this.response, RestMatchers.isOk());
        try {
            return DocNode.of((String)"pit.id", (Object)this.response.getBodyAsDocNode().getAsString("id"));
        }
        catch (DocumentParseException | Format.UnknownDocTypeException e) {
            throw new RuntimeException("Cannot retrieve PIT id", e);
        }
    }

    public String[] extractIndicesFromPit(NamedWriteableRegistry namedWriteableRegistry) {
        Objects.requireNonNull(namedWriteableRegistry, "Name writeable registry cannot be null");
        SearchContextId searchContextId = SearchContextId.decode((NamedWriteableRegistry)namedWriteableRegistry, (BytesReference)new BytesArray(Base64.getUrlDecoder().decode(this.getPitId())));
        return searchContextId.getActualIndices();
    }

    @Override
    public void close() throws Exception {
        if (this.response.getStatusCode() == 200) {
            GenericRestClient.HttpResponse response = this.genericRestClient.deleteJson("/_pit/", (Map<String, Object>)DocNode.of((String)"id", (Object)this.getPitId()), new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
        }
    }

    public GenericRestClient.HttpResponse getResponse() {
        return this.response;
    }

    public static class HolderClient {
        private final GenericRestClient genericRestClient;

        public HolderClient(GenericRestClient genericRestClient) {
            this.genericRestClient = Objects.requireNonNull(genericRestClient, "Rest client is required");
        }

        public PitHolder post(String path) throws Exception {
            GenericRestClient.HttpResponse response = this.genericRestClient.post(path);
            return new PitHolder(this.genericRestClient, response);
        }
    }
}

