/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.certificate;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.test.helper.certificate.CertificateType;
import com.floragunn.searchguard.test.helper.certificate.CertificateWithKeyPair;
import com.floragunn.searchguard.test.helper.certificate.NodeCertificateType;
import com.floragunn.searchguard.test.helper.certificate.TestCertificate;
import com.floragunn.searchguard.test.helper.certificate.TestCertificateFactory;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;

public class TestCertificates {
    private static final Logger log = LogManager.getLogger(TestCertificates.class);
    private final TestCertificateFactory testCertificateFactory;
    private final TestCertificate caCertificate;
    private final ImmutableList<TestCertificate> nodeCertificates;
    private final ImmutableList<TestCertificate> clientCertificates;
    private final File resources;

    private TestCertificates(TestCertificate caCertificate, List<TestCertificate> nodeCertificates, List<TestCertificate> clientCertificates, TestCertificateFactory testCertificateFactory, File resources) {
        this.caCertificate = caCertificate;
        this.nodeCertificates = ImmutableList.of(nodeCertificates);
        this.clientCertificates = ImmutableList.of(clientCertificates);
        this.testCertificateFactory = testCertificateFactory;
        this.resources = resources;
    }

    public File getCaKeyFile() {
        return this.caCertificate.getPrivateKeyFile();
    }

    public File getCaCertFile() {
        return this.caCertificate.getCertificateFile();
    }

    public TestCertificate getCaCertificate() {
        return this.caCertificate;
    }

    public List<TestCertificate> getClientsCertificates() {
        return this.clientCertificates;
    }

    public TestCertificate getAnyClientCertificate() {
        return (TestCertificate)this.clientCertificates.get(0);
    }

    public List<TestCertificate> getNodesCertificates() {
        return this.nodeCertificates;
    }

    public TestCertificate getNodeCertificate() {
        return (TestCertificate)this.nodeCertificates.get(0);
    }

    public TestCertificate getAdminCertificate() {
        return this.clientCertificates.stream().filter(testCertificate -> testCertificate.getCertificateType() == CertificateType.admin_client).findFirst().orElseThrow(() -> {
            log.error("No admin client certificate configured");
            return new RuntimeException("No admin client certificate configured");
        });
    }

    public TestCertificate create(String dn) {
        String privateKeyPassword = "secret_" + new Random().nextInt();
        TestCertificatesBuilder.CertificatesDefaults certificatesDefaults = new TestCertificatesBuilder.CertificatesDefaults();
        CertificateWithKeyPair certificateWithKeyPair = this.testCertificateFactory.createClientCertificate(dn, certificatesDefaults.validityDays, this.caCertificate.getCertificate(), this.caCertificate.getKeyPair().getPrivate());
        return new TestCertificate(certificateWithKeyPair.getCertificate(), certificateWithKeyPair.getKeyPair(), privateKeyPassword, CertificateType.other, this.resources);
    }

    public TestCertificates at(File directory) {
        return new TestCertificates(this.caCertificate.at(directory), (List<TestCertificate>)this.nodeCertificates.map(c -> c.at(directory)), (List<TestCertificate>)this.clientCertificates.map(c -> c.at(directory)), this.testCertificateFactory, directory);
    }

    public Settings getSgSettings() {
        TestCertificate certificate = this.getNodesCertificates().get(0);
        Settings.Builder result = Settings.builder();
        result.put("searchguard.ssl.transport.pemcert_filepath", certificate.getCertificateFile().getAbsolutePath());
        result.put("searchguard.ssl.transport.pemkey_filepath", certificate.getPrivateKeyFile().getAbsolutePath());
        if (certificate.getPrivateKeyPassword() != null) {
            result.put("searchguard.ssl.transport.pemkey_password", certificate.getPrivateKeyPassword());
        }
        result.put("searchguard.ssl.http.pemcert_filepath", certificate.getCertificateFile().getAbsolutePath());
        result.put("searchguard.ssl.http.pemkey_filepath", certificate.getPrivateKeyFile().getAbsolutePath());
        if (certificate.getPrivateKeyPassword() != null) {
            result.put("searchguard.ssl.http.pemkey_password", certificate.getPrivateKeyPassword());
        }
        result.putList("searchguard.authcz.admin_dn", new String[]{this.getAdminCertificate().getCertificate().getSubject().toString()});
        result.put("searchguard.ssl.transport.pemtrustedcas_filepath", this.getCaCertFile().getAbsolutePath());
        result.put("searchguard.ssl.http.pemtrustedcas_filepath", this.getCaCertFile().getAbsolutePath());
        result.put("searchguard.ssl.http.enabled", true);
        return result.build();
    }

    public static TestCertificatesBuilder builder() {
        return TestCertificates.builder(TestCertificateFactory.rsaBaseCertificateFactory());
    }

    public static TestCertificatesBuilder builder(TestCertificateFactory testCertificateFactory) {
        return new TestCertificatesBuilder(testCertificateFactory);
    }

    public static class TestCertificatesBuilder {
        private static final String DEFAULT_CA_DN = "CN=root.ca.example.com,OU=Organizational Unit,O=Organization";
        private static final String DEFAULT_ONE_NODE_DN = "CN=node-0.example.com,OU=Organizational Unit,O=Organization";
        private CertificatesDefaults certificatesDefaults = new CertificatesDefaults();
        private final TestCertificateFactory testCertificateFactory;
        private TestCertificate caCertificate;
        private final List<TestCertificate> nodesCertificates = new ArrayList<TestCertificate>();
        private final List<TestCertificate> clientsCertificates = new ArrayList<TestCertificate>();
        private final File resources;

        public TestCertificatesBuilder(TestCertificateFactory testCertificateFactory) {
            this.testCertificateFactory = testCertificateFactory;
            this.resources = FileHelper.createTempDirectory("certs");
        }

        public TestCertificates build() {
            if (this.caCertificate == null) {
                this.ca();
            }
            if (this.nodesCertificates.isEmpty()) {
                this.addNodes(DEFAULT_ONE_NODE_DN);
            }
            return new TestCertificates(this.caCertificate, this.nodesCertificates, this.clientsCertificates, this.testCertificateFactory, this.resources);
        }

        public TestCertificatesBuilder defaults(Function<CertificatesDefaults, CertificatesDefaults> defaultsFunction) {
            this.certificatesDefaults = defaultsFunction.apply(this.certificatesDefaults);
            return this;
        }

        public TestCertificatesBuilder ca() {
            return this.ca(DEFAULT_CA_DN);
        }

        public TestCertificatesBuilder ca(String dn) {
            return this.ca(dn, this.certificatesDefaults.validityDays, null);
        }

        public TestCertificatesBuilder ca(String dn, Date validityStartDate, Date validityEndDate) {
            if (this.caCertificate != null) {
                log.error("CA certificate already generated. CA certificate can be generated only once");
                throw new RuntimeException("CA certificate already generated. CA certificate can be generated only once");
            }
            CertificateWithKeyPair certificateWithKeyPair = this.testCertificateFactory.createCaCertificate(dn, validityStartDate, validityEndDate);
            this.caCertificate = new TestCertificate(certificateWithKeyPair.getCertificate(), certificateWithKeyPair.getKeyPair(), null, CertificateType.ca, this.resources);
            return this;
        }

        public TestCertificatesBuilder ca(String dn, int validityDays, String privateKeyPassword) {
            if (this.caCertificate != null) {
                log.error("CA certificate already generated. CA certificate can be generated only once");
                throw new RuntimeException("CA certificate already generated. CA certificate can be generated only once");
            }
            CertificateWithKeyPair certificateWithKeyPair = this.testCertificateFactory.createCaCertificate(dn, validityDays);
            this.caCertificate = new TestCertificate(certificateWithKeyPair.getCertificate(), certificateWithKeyPair.getKeyPair(), privateKeyPassword, CertificateType.ca, this.resources);
            return this;
        }

        public TestCertificatesBuilder addNodes(String ... dn) {
            return this.addNodes(Arrays.asList(dn), this.certificatesDefaults.validityDays, this.certificatesDefaults.nodeOid, this.certificatesDefaults.nodeDnsList, this.certificatesDefaults.nodeIpList, this.certificatesDefaults.nodeCertificateType, null);
        }

        public TestCertificatesBuilder addNodes(List<String> dnList, int validityDays, String nodeOid, List<String> dnsList, List<String> ipList, NodeCertificateType nodeCertificateType, String privateKeyPassword) {
            this.validateCaCertificate();
            dnList.forEach(dn -> {
                CertificateWithKeyPair certificateWithKeyPair = this.testCertificateFactory.createNodeCertificate((String)dn, validityDays, nodeOid, dnsList, ipList, this.caCertificate.getCertificate(), this.caCertificate.getKeyPair().getPrivate());
                this.nodesCertificates.add(new TestCertificate(certificateWithKeyPair.getCertificate(), certificateWithKeyPair.getKeyPair(), privateKeyPassword, nodeCertificateType.getCertificateType(), this.resources));
            });
            return this;
        }

        public TestCertificatesBuilder addClients(String ... dn) {
            return this.addClients(Arrays.asList(dn), this.certificatesDefaults.validityDays, null);
        }

        public TestCertificatesBuilder addClients(List<String> dnList, int validityDays, String privateKeyPassword) {
            this.addClients(dnList, validityDays, privateKeyPassword, false);
            return this;
        }

        public TestCertificatesBuilder addAdminClients(String ... dn) {
            return this.addAdminClients(Arrays.asList(dn), this.certificatesDefaults.validityDays, null);
        }

        public TestCertificatesBuilder addAdminClients(List<String> dnList, int validityDays, String privateKeyPassword) {
            this.addClients(dnList, validityDays, privateKeyPassword, true);
            return this;
        }

        private void addClients(List<String> dnList, int validityDays, String privateKeyPassword, boolean admin) {
            this.validateCaCertificate();
            dnList.forEach(dn -> {
                CertificateWithKeyPair certificateWithKeyPair = this.testCertificateFactory.createClientCertificate((String)dn, validityDays, this.caCertificate.getCertificate(), this.caCertificate.getKeyPair().getPrivate());
                this.clientsCertificates.add(new TestCertificate(certificateWithKeyPair.getCertificate(), certificateWithKeyPair.getKeyPair(), privateKeyPassword, admin ? CertificateType.admin_client : CertificateType.client, this.resources));
            });
        }

        private void validateCaCertificate() {
            if (this.caCertificate == null) {
                log.error("Ca certificate is not generated, generate CA certificate first");
                throw new RuntimeException("Ca certificate is not generated, generate CA certificate first");
            }
        }

        public static class CertificatesDefaults {
            private int validityDays = 30;
            private String nodeOid = "1.2.3.4.5.5";
            private List<String> nodeIpList = Collections.emptyList();
            private List<String> nodeDnsList = Collections.emptyList();
            private NodeCertificateType nodeCertificateType = NodeCertificateType.transport_and_rest;

            public CertificatesDefaults setValidityDays(int validityDays) {
                this.validityDays = validityDays;
                return this;
            }

            public CertificatesDefaults setNodeOid(String nodeOid) {
                this.nodeOid = nodeOid;
                return this;
            }

            public CertificatesDefaults setNodeIpList(String ... nodeIpList) {
                this.nodeIpList = Arrays.asList(nodeIpList);
                return this;
            }

            public CertificatesDefaults setNodeDnsList(String ... nodeDnsList) {
                this.nodeDnsList = Arrays.asList(nodeDnsList);
                return this;
            }

            public CertificatesDefaults setNodeCertificateType(NodeCertificateType nodeCertificateType) {
                this.nodeCertificateType = nodeCertificateType;
                return this;
            }
        }
    }
}

