/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.certificate.asymmetricscryptography;

import com.floragunn.searchguard.test.helper.certificate.asymmetricscryptography.AsymmetricCryptographyAlgorithm;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.ECGenParameterSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDSAAsymmetricCryptographyAlgorithm
implements AsymmetricCryptographyAlgorithm {
    private static final Logger log = LogManager.getLogger(ECDSAAsymmetricCryptographyAlgorithm.class);
    private final KeyPairGenerator generator;

    public ECDSAAsymmetricCryptographyAlgorithm(Provider securityProvider, String ellipticCurve) {
        try {
            this.generator = KeyPairGenerator.getInstance("EC", securityProvider);
            log.info("Initialize key pair generator with elliptic curve: {}", (Object)ellipticCurve);
            ECGenParameterSpec ecsp = new ECGenParameterSpec(ellipticCurve);
            this.generator.initialize(ecsp);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            log.error("Error while initializing", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getSignatureAlgorithmName() {
        return "SHA256withECDSA";
    }

    @Override
    public KeyPair generateKeyPair() {
        log.info("Create key pair");
        return this.generator.generateKeyPair();
    }
}

