/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public enum ClusterConfiguration {
    DEFAULT(new NodeSettings("master", true, false), new NodeSettings("data_1", false, true), new NodeSettings("data_2", false, true)),
    SINGLENODE(new NodeSettings("single", true, true)),
    CLIENTNODE(new NodeSettings("master", true, false), new NodeSettings("data_1", false, true), new NodeSettings("data_2", false, true), new NodeSettings("client_1", false, false)),
    THREE_MASTERS(new NodeSettings("master_1", true, false), new NodeSettings("master_2", true, false), new NodeSettings("master_3", true, false), new NodeSettings("data_1", false, true), new NodeSettings("data_2", false, true));

    private List<NodeSettings> nodeSettings = new LinkedList<NodeSettings>();

    private ClusterConfiguration(NodeSettings ... settings) {
        this.nodeSettings.addAll(Arrays.asList(settings));
    }

    public List<NodeSettings> getNodeSettings() {
        return Collections.unmodifiableList(this.nodeSettings);
    }

    public List<NodeSettings> getMasterNodeSettings() {
        return Collections.unmodifiableList(this.nodeSettings.stream().filter(a -> a.masterNode).collect(Collectors.toList()));
    }

    public List<NodeSettings> getNonMasterNodeSettings() {
        return Collections.unmodifiableList(this.nodeSettings.stream().filter(a -> !a.masterNode).collect(Collectors.toList()));
    }

    public int getNodes() {
        return this.nodeSettings.size();
    }

    public int getMasterNodes() {
        return (int)this.nodeSettings.stream().filter(a -> a.masterNode).count();
    }

    public int getDataNodes() {
        return (int)this.nodeSettings.stream().filter(a -> a.dataNode).count();
    }

    public int getClientNodes() {
        return (int)this.nodeSettings.stream().filter(a -> !a.masterNode && !a.dataNode).count();
    }

    public static class NodeSettings {
        public final boolean masterNode;
        public final boolean dataNode;
        public final String name;

        public NodeSettings(String name, boolean masterNode, boolean dataNode) {
            this.name = name;
            this.masterNode = masterNode;
            this.dataNode = dataNode;
        }
    }
}

