/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.log;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;

class LogMessage {
    private final String message;
    private final String stackTrace;

    public LogMessage(String message, Throwable throwable) {
        this.message = message;
        this.stackTrace = Optional.ofNullable(throwable).map(ExceptionUtils::getStackTrace).orElse("");
    }

    public boolean containMessage(String expectedMessage) {
        Objects.requireNonNull(expectedMessage, "Expected message must not be null.");
        return expectedMessage.equals(this.message);
    }

    public boolean stackTraceContains(String stackTraceFragment) {
        Objects.requireNonNull(stackTraceFragment, "Stack trace fragment is required.");
        return this.stackTrace.contains(stackTraceFragment);
    }

    public String getMessage() {
        return this.message;
    }
}

