/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.blocking;

import com.floragunn.searchguard.authc.blocking.ClientBlockRegistry;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeapBasedClientBlockRegistry<ClientIdType>
implements ClientBlockRegistry<ClientIdType> {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final Cache<ClientIdType, Long> cache;
    private final Class<ClientIdType> clientIdType;

    public HeapBasedClientBlockRegistry(long expiryMs, int maxEntries, Class<ClientIdType> clientIdType) {
        this.clientIdType = clientIdType;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(expiryMs, TimeUnit.MILLISECONDS).maximumSize((long)maxEntries).concurrencyLevel(4).removalListener(notification -> {
            if (this.log.isInfoEnabled()) {
                this.log.info("Unblocking " + String.valueOf(notification.getKey()));
            }
        }).build();
    }

    public HeapBasedClientBlockRegistry(Class<ClientIdType> clientIdType) {
        this.clientIdType = clientIdType;
        this.cache = CacheBuilder.newBuilder().build();
    }

    @Override
    public boolean isBlocked(ClientIdType clientId) {
        return this.cache.getIfPresent(clientId) != null;
    }

    @Override
    public void block(ClientIdType clientId) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Blocking " + String.valueOf(clientId));
        }
        this.cache.put(clientId, (Object)System.currentTimeMillis());
    }

    @Override
    public Class<ClientIdType> getClientIdType() {
        return this.clientIdType;
    }
}

