/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.rest;

import com.floragunn.searchguard.ssl.http.AttributedHttpRequest;
import io.netty.channel.EventLoop;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

class ExecuteInNettyEventLoopDispatcher
implements HttpServerTransport.Dispatcher {
    private static final Logger log = LogManager.getLogger(ExecuteInNettyEventLoopDispatcher.class);
    private final HttpServerTransport.Dispatcher original;
    private final ThreadPool threadPool;

    public ExecuteInNettyEventLoopDispatcher(HttpServerTransport.Dispatcher originalDispatcher, ThreadPool threadPool) {
        this.original = Objects.requireNonNull(originalDispatcher, "originalDispatcher must not be null");
        this.threadPool = Objects.requireNonNull(threadPool, "threadPool must not be null");
    }

    public void dispatchRequest(RestRequest request, RestChannel channel, ThreadContext threadContext) {
        Runnable runnable = () -> this.original.dispatchRequest(request, channel, threadContext);
        this.dispatch(request, runnable);
    }

    public void dispatchBadRequest(RestChannel channel, ThreadContext threadContext, Throwable cause) {
        Runnable runnable = () -> this.original.dispatchBadRequest(channel, threadContext, cause);
        this.dispatch(channel.request(), runnable);
    }

    private void dispatch(RestRequest request, Runnable runnable) {
        HttpRequest httpRequest = request.getHttpRequest();
        if (httpRequest instanceof AttributedHttpRequest) {
            AttributedHttpRequest attributedHttpRequest = (AttributedHttpRequest)httpRequest;
            EventLoop eventLoop = attributedHttpRequest.getEventLoop();
            if (eventLoop.inEventLoop()) {
                runnable.run();
            } else {
                Runnable runnableWithContext = this.threadPool.getThreadContext().preserveContext(runnable);
                eventLoop.execute(runnableWithContext);
            }
        } else {
            assert (false) : "Expected AttributedHttpRequest but got " + String.valueOf(httpRequest.getClass());
            log.error("Netty event loop not present, invalid type of request '{}'", (Object)httpRequest);
            runnable.run();
        }
    }
}

