/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.license;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.license.LicenseHelper;
import com.floragunn.searchguard.license.SearchGuardLicense;
import java.util.Map;

public final class SearchGuardLicenseKey
implements Document<SearchGuardLicenseKey> {
    private final SearchGuardLicense license;
    private final DocNode source;

    SearchGuardLicenseKey(SearchGuardLicense license, DocNode source) {
        this.license = license;
        this.source = source;
    }

    public SearchGuardLicense getLicense() {
        return this.license;
    }

    public Object toBasicObject() {
        return this.source;
    }

    public String toString() {
        return this.license.toString();
    }

    private static ValidationResult<SearchGuardLicenseKey> parseLicenseString(String licenseString, DocNode source) {
        Map parsedJson;
        String jsonString;
        try {
            jsonString = LicenseHelper.validateLicense(licenseString);
        }
        catch (ConfigValidationException e) {
            return new ValidationResult(e.getValidationErrors());
        }
        catch (Exception e) {
            return new ValidationResult(new ValidationError(null, e.getMessage()).cause((Throwable)e));
        }
        try {
            parsedJson = DocReader.json().readObject(jsonString);
        }
        catch (ConfigValidationException e) {
            return new ValidationResult(e.getValidationErrors());
        }
        SearchGuardLicenseKey result = new SearchGuardLicenseKey(new SearchGuardLicense(parsedJson), source);
        return new ValidationResult((Object)result, result.getLicense().staticValidate());
    }

    public static ValidationResult<SearchGuardLicenseKey> parse(DocNode docNode, Parser.Context context) {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
        if (docNode.isString()) {
            return SearchGuardLicenseKey.parseLicenseString(docNode.toString(), docNode);
        }
        ValidationResult result = (ValidationResult)vNode.get("key").by(node -> SearchGuardLicenseKey.parseLicenseString(node.toString(), docNode));
        if (result != null) {
            validationErrors.add("key", result);
        }
        vNode.checkForUnusedAttributes();
        if (result != null && result.hasResult()) {
            return new ValidationResult((Object)((SearchGuardLicenseKey)result.peek()), validationErrors);
        }
        return new ValidationResult(validationErrors);
    }
}

