/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc;

import com.floragunn.searchguard.authc.rest.ClientAddressAscertainer;
import inet.ipaddr.IPAddress;
import java.util.List;
import java.util.Map;
import org.elasticsearch.rest.RestRequest;

public abstract class RequestMetaData<T> {
    private final T request;
    private final IPAddress directIpAddress;
    private final IPAddress originatingIpAddress;
    private final boolean trustedProxy;
    private final String clientCertSubject;

    public RequestMetaData(T request, ClientAddressAscertainer.ClientIpInfo clientIpInfo, String clientCertSubject) {
        this.request = request;
        this.directIpAddress = clientIpInfo.getDirectIpAddress();
        this.originatingIpAddress = clientIpInfo.getOriginatingIpAddress();
        this.trustedProxy = clientIpInfo.isTrustedProxy();
        this.clientCertSubject = clientCertSubject;
    }

    public RequestMetaData(T request, IPAddress ipAddress, String clientCertSubject) {
        this.request = request;
        this.directIpAddress = ipAddress;
        this.originatingIpAddress = ipAddress;
        this.clientCertSubject = clientCertSubject;
        this.trustedProxy = false;
    }

    public T getRequest() {
        return this.request;
    }

    public IPAddress getDirectIpAddress() {
        return this.directIpAddress;
    }

    public IPAddress getOriginatingIpAddress() {
        return this.originatingIpAddress;
    }

    public boolean isTrustedProxy() {
        return this.trustedProxy;
    }

    public String getClientCertSubject() {
        return this.clientCertSubject;
    }

    public abstract String getHeader(String var1);

    public abstract Map<String, List<String>> getHeaders();

    public abstract String getParam(String var1);

    public String getAuthorizationByScheme(String header, String scheme) {
        String authorization = this.getHeader(header);
        if (authorization == null) {
            return null;
        }
        int separator = authorization.indexOf(32);
        if (separator == -1) {
            return null;
        }
        if (!authorization.substring(0, separator).equalsIgnoreCase(scheme)) {
            return null;
        }
        return authorization.substring(separator + 1).trim();
    }

    public String getAuthorizationByScheme(String scheme) {
        return this.getAuthorizationByScheme("Authorization", scheme);
    }

    public String toString() {
        if (this.request instanceof RestRequest) {
            return "[request=" + ((RestRequest)this.request).path() + ", directIpAddress=" + String.valueOf(this.getDirectIpAddress()) + ", originatingIpAddress=" + String.valueOf(this.getOriginatingIpAddress()) + ", clientCertSubject=" + this.clientCertSubject + "]";
        }
        return "[request=" + String.valueOf(this.request) + ", directIpAddress=" + String.valueOf(this.getDirectIpAddress()) + ", originatingIpAddress=" + String.valueOf(this.getOriginatingIpAddress()) + ", clientCertSubject=" + this.clientCertSubject + "]";
    }
}

