/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchguard.test.helper.cluster.SimpleRestHandler;
import com.floragunn.searchsupport.action.ActionHandlerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;

public class ResourceOwnerServiceTests {
    private static TestSgConfig.Role ROLE_OWN_INDEX = new TestSgConfig.Role("own_index").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("${user_name}", "${user_name}_*");
    private static TestSgConfig.User SULU = new TestSgConfig.User("sulu").roles(ROLE_OWN_INDEX);
    private static TestSgConfig.User EVIL_SULU = new TestSgConfig.User("evil_sulu").roles(ROLE_OWN_INDEX);
    private static TestSgConfig.User ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role("admin_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "indices:searchguard:async_search/_all_owners"));
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().singleNode().sslEnabled().users(SULU, EVIL_SULU, ADMIN).embedded().plugin(MockActionPlugin.class).build();

    @Test
    public void testAsyncSearch() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(SULU, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/test1,test2/_async_search?wait_for_completion_timeout=1ms", "{\n  \"query\": {\n    \"match_all\": {}\n  }\n}\n", new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode().hasNonNull("id"), (Matcher)Matchers.equalTo((Object)true));
            String searchId = response.getBodyAsDocNode().getAsString("id");
            response = client.get("/_async_search/" + searchId, new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            response = client.delete("/_async_search/" + searchId, new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            Thread.sleep(100L);
            response = client.get("/_async_search/" + searchId, new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isNotFound());
        }
    }

    @Test
    public void testAsyncSearchUserMismatch() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(SULU, new Header[0]);
             GenericRestClient client2 = cluster.getRestClient(EVIL_SULU, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/test1,test2/_async_search?wait_for_completion_timeout=1ms", "{\n  \"query\": {\n    \"match_all\": {}\n  }\n}\n", new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode().hasNonNull("id"), (Matcher)Matchers.equalTo((Object)true));
            String searchId = response.getBodyAsDocNode().getAsString("id");
            response = client2.get("/_async_search/" + searchId, new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isForbidden());
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBody(), (Matcher)Matchers.containsString((String)"is not owned by user evil_sulu"));
        }
    }

    @Test
    public void testAsyncSearchUserOverride() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(SULU, new Header[0]);
             GenericRestClient client2 = cluster.getRestClient(ADMIN, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/test1,test2/_async_search?wait_for_completion_timeout=1ms", "{\n  \"query\": {\n    \"match_all\": {}\n  }\n}\n", new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode().hasNonNull("id"), (Matcher)Matchers.equalTo((Object)true));
            String searchId = response.getBodyAsDocNode().getAsString("id");
            response = client2.get("/_async_search/" + searchId, new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            response = client2.delete("/_async_search/" + searchId, new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
        }
    }

    @Test
    public void testAsyncSearchUserMismatchForDelete() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(SULU, new Header[0]);
             GenericRestClient client2 = cluster.getRestClient(EVIL_SULU, new Header[0]);){
            GenericRestClient.HttpResponse response = client.postJson("/test1,test2/_async_search?wait_for_completion_timeout=1ms", "{\n  \"query\": {\n    \"match_all\": {}\n  }\n}\n", new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode().hasNonNull("id"), (Matcher)Matchers.equalTo((Object)true));
            String searchId = response.getBodyAsDocNode().getAsString("id");
            response = client2.delete("/_async_search/" + searchId, new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isForbidden());
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBody(), (Matcher)Matchers.containsString((String)"is not owned by user evil_sulu"));
        }
    }

    public static class MockActionPlugin
    extends Plugin
    implements ActionPlugin {
        public List<ActionPlugin.ActionHandler> getActions() {
            return Arrays.asList(ActionHandlerFactory.actionHandler(MockSubmitTransportAction.TYPE, MockSubmitTransportAction.class), ActionHandlerFactory.actionHandler(MockGetTransportAction.TYPE, MockGetTransportAction.class), ActionHandlerFactory.actionHandler(MockDeleteTransportAction.TYPE, MockDeleteTransportAction.class));
        }

        public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
            return Arrays.asList(new RestHandler[]{new SimpleRestHandler<MockSubmitActionRequest, MockActionResponse>(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_async_search"), MockSubmitTransportAction.TYPE, request -> new MockSubmitActionRequest(request.param("index"))), new SimpleRestHandler<MockGetActionRequest, MockActionResponse>(new RestHandler.Route(RestRequest.Method.GET, "/_async_search/{id}"), MockGetTransportAction.TYPE, request -> new MockGetActionRequest(request.param("id"))), new SimpleRestHandler<MockGetActionRequest, AcknowledgedResponse>(new RestHandler.Route(RestRequest.Method.DELETE, "/_async_search/{id}"), MockDeleteTransportAction.TYPE, request -> new MockGetActionRequest(request.param("id")))});
        }
    }

    public static class MockActionResponse
    extends ActionResponse
    implements ToXContentObject,
    ChunkedToXContentObject {
        private String id;
        private RestStatus restStatus;

        public MockActionResponse(String id, RestStatus restStatus) {
            this.id = id;
            this.restStatus = restStatus;
        }

        public MockActionResponse(StreamInput in) throws IOException {
            this.id = in.readOptionalString();
            this.restStatus = (RestStatus)in.readEnum(RestStatus.class);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.id != null) {
                builder.field("id", this.id);
            }
            builder.field("is_partial", true);
            builder.field("is_running", true);
            builder.field("start_time_in_millis", System.currentTimeMillis());
            builder.field("expiration_time_in_millis", System.currentTimeMillis());
            builder.startObject("response");
            builder.field("took", 0);
            builder.field("timed_out", false);
            builder.field("num_reduce_phases", 0);
            builder.startObject("_shards");
            builder.field("total", 1);
            builder.field("successful", 1);
            builder.field("skipped", 0);
            builder.field("failed", 0);
            builder.endObject();
            builder.startObject("hits");
            builder.startObject("total");
            builder.field("value", 0);
            builder.field("relation", "eq");
            builder.endObject();
            builder.nullField("max_score");
            builder.startArray("hits");
            builder.endArray();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.id);
            out.writeEnum((Enum)this.restStatus);
        }

        public RestStatus status() {
            return this.restStatus;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            ImmutableList list = ImmutableList.of((Object)((Object)this));
            return list.iterator();
        }

        public boolean isFragment() {
            return false;
        }
    }

    public static class MockDeleteTransportAction
    extends HandledTransportAction<MockGetActionRequest, AcknowledgedResponse> {
        static ActionType<AcknowledgedResponse> TYPE = new ActionType("indices:data/read/async_search/delete");

        @Inject
        public MockDeleteTransportAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, AdminDNs adminDNs, ActionFilters actionFilters) {
            super(TYPE.name(), transportService, actionFilters, MockGetActionRequest::new, (Executor)threadPool.executor("generic"));
        }

        protected void doExecute(Task task, MockGetActionRequest request, ActionListener<AcknowledgedResponse> listener) {
            listener.onResponse((Object)AcknowledgedResponse.of((boolean)true));
        }
    }

    public static class MockGetActionRequest
    extends ActionRequest {
        private String id;

        public MockGetActionRequest(String id) {
            this.id = id;
        }

        public MockGetActionRequest(StreamInput in) throws IOException {
            this.id = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class MockGetTransportAction
    extends HandledTransportAction<MockGetActionRequest, MockActionResponse> {
        static ActionType<MockActionResponse> TYPE = new ActionType("indices:data/read/async_search/get");

        @Inject
        public MockGetTransportAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, AdminDNs adminDNs, ActionFilters actionFilters) {
            super(TYPE.name(), transportService, actionFilters, MockGetActionRequest::new, (Executor)threadPool.executor("generic"));
        }

        protected void doExecute(Task task, MockGetActionRequest request, ActionListener<MockActionResponse> listener) {
            listener.onResponse((Object)new MockActionResponse(UUID.randomUUID().toString(), RestStatus.OK));
        }
    }

    public static class MockSubmitActionRequest
    extends ActionRequest {
        private String index;

        public MockSubmitActionRequest(String index) {
            this.index = index;
        }

        public MockSubmitActionRequest(StreamInput in) throws IOException {
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String getIndex() {
            return this.index;
        }

        public void setIndex(String index) {
            this.index = index;
        }
    }

    public static class MockSubmitTransportAction
    extends HandledTransportAction<MockSubmitActionRequest, MockActionResponse> {
        static ActionType<MockActionResponse> TYPE = new ActionType("indices:data/read/async_search/submit");

        @Inject
        public MockSubmitTransportAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, AdminDNs adminDNs, ActionFilters actionFilters) {
            super(TYPE.name(), transportService, actionFilters, MockSubmitActionRequest::new, (Executor)threadPool.executor("generic"));
        }

        protected void doExecute(Task task, MockSubmitActionRequest request, ActionListener<MockActionResponse> listener) {
            listener.onResponse((Object)new MockActionResponse(UUID.randomUUID().toString(), RestStatus.OK));
        }
    }
}

