/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.rest;

import com.floragunn.searchguard.authc.rest.ExecuteInNettyEventLoopDispatcher;
import com.floragunn.searchguard.ssl.http.AttributedHttpRequest;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import com.floragunn.searchsupport.util.EsLogging;
import io.netty.channel.EventLoop;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ExecuteInNettyEventLoopDispatcherTest {
    @ClassRule
    public static EsLogging esLogging = new EsLogging();
    @Mock
    private HttpServerTransport.Dispatcher originalDispatcher;
    @Mock
    private ThreadPool threadPool;
    @Mock
    private ThreadContext threadContext;
    @Mock
    private RestRequest restRequest;
    @Mock
    private RestChannel restChannel;
    @Mock
    private HttpRequest httpRequest;
    @Mock
    private AttributedHttpRequest attributedHttpRequest;
    @Mock
    private EventLoop eventLoop;
    @Mock
    private Runnable preservedRunnable;
    @Mock
    private Throwable cause;
    private ExecuteInNettyEventLoopDispatcher dispatcher;

    @Before
    public void setUp() {
        Mockito.when((Object)this.threadPool.getThreadContext()).thenReturn((Object)this.threadContext);
        this.dispatcher = new ExecuteInNettyEventLoopDispatcher(this.originalDispatcher, this.threadPool);
    }

    @Test
    public void shouldDelegateDispatchRequestToOriginalDispatcherWhenInEventLoop() {
        Mockito.when((Object)this.restRequest.getHttpRequest()).thenReturn((Object)this.attributedHttpRequest);
        Mockito.when((Object)this.attributedHttpRequest.getEventLoop()).thenReturn((Object)this.eventLoop);
        Mockito.when((Object)this.eventLoop.inEventLoop()).thenReturn((Object)true);
        this.dispatcher.dispatchRequest(this.restRequest, this.restChannel, this.threadContext);
        ((HttpServerTransport.Dispatcher)Mockito.verify((Object)this.originalDispatcher)).dispatchRequest(this.restRequest, this.restChannel, this.threadContext);
    }

    @Test
    public void shouldPreserveContextAndExecuteOnEventLoopWhenNotInEventLoop() {
        Mockito.when((Object)this.restRequest.getHttpRequest()).thenReturn((Object)this.attributedHttpRequest);
        Mockito.when((Object)this.attributedHttpRequest.getEventLoop()).thenReturn((Object)this.eventLoop);
        Mockito.when((Object)this.eventLoop.inEventLoop()).thenReturn((Object)false);
        ((ThreadContext)Mockito.doReturn((Object)this.preservedRunnable).when((Object)this.threadContext)).preserveContext((Runnable)Mockito.any(Runnable.class));
        this.dispatcher.dispatchRequest(this.restRequest, this.restChannel, this.threadContext);
        ((EventLoop)Mockito.verify((Object)this.eventLoop)).execute(this.preservedRunnable);
    }

    @Test
    public void shouldLogErrorWhenHttpRequestIsNotAttributed() {
        Mockito.when((Object)this.restRequest.getHttpRequest()).thenReturn((Object)this.httpRequest);
        Throwable throwable = ThrowableAssert.assertThatThrown(() -> this.dispatcher.dispatchRequest(this.restRequest, this.restChannel, this.threadContext), (Matcher[])new Matcher[]{Matchers.instanceOf(AssertionError.class)});
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Matchers.containsString((String)"Expected AttributedHttpRequest but got"));
    }

    @Test
    public void shouldDelegateDispatchBadRequestToOriginalDispatcherWhenInEventLoop() {
        Mockito.when((Object)this.restChannel.request()).thenReturn((Object)this.restRequest);
        Mockito.when((Object)this.restRequest.getHttpRequest()).thenReturn((Object)this.attributedHttpRequest);
        Mockito.when((Object)this.attributedHttpRequest.getEventLoop()).thenReturn((Object)this.eventLoop);
        Mockito.when((Object)this.eventLoop.inEventLoop()).thenReturn((Object)true);
        this.dispatcher.dispatchBadRequest(this.restChannel, this.threadContext, this.cause);
        ((HttpServerTransport.Dispatcher)Mockito.verify((Object)this.originalDispatcher)).dispatchBadRequest(this.restChannel, this.threadContext, this.cause);
    }

    @Test
    public void shouldPreserveContextAndExecuteBadRequestOnEventLoopWhenNotInEventLoop() {
        Mockito.when((Object)this.restChannel.request()).thenReturn((Object)this.restRequest);
        Mockito.when((Object)this.restRequest.getHttpRequest()).thenReturn((Object)this.attributedHttpRequest);
        Mockito.when((Object)this.attributedHttpRequest.getEventLoop()).thenReturn((Object)this.eventLoop);
        Mockito.when((Object)this.eventLoop.inEventLoop()).thenReturn((Object)false);
        ((ThreadContext)Mockito.doReturn((Object)this.preservedRunnable).when((Object)this.threadContext)).preserveContext((Runnable)Mockito.any(Runnable.class));
        this.dispatcher.dispatchBadRequest(this.restChannel, this.threadContext, this.cause);
        ((EventLoop)Mockito.verify((Object)this.eventLoop)).execute(this.preservedRunnable);
    }

    @Test
    public void shouldLogErrorWhenHttpRequestIsNotAttributedForDispatchBadRequest() {
        Mockito.when((Object)this.restChannel.request()).thenReturn((Object)this.restRequest);
        Mockito.when((Object)this.restRequest.getHttpRequest()).thenReturn((Object)this.httpRequest);
        Throwable throwable = ThrowableAssert.assertThatThrown(() -> this.dispatcher.dispatchBadRequest(this.restChannel, this.threadContext, this.cause), (Matcher[])new Matcher[]{Matchers.instanceOf(AssertionError.class)});
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Matchers.containsString((String)"Expected AttributedHttpRequest but got"));
    }
}

