/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.int_tests;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.IndexApiMatchers;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestAlias;
import com.floragunn.searchguard.test.TestComponentTemplate;
import com.floragunn.searchguard.test.TestDataStream;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestIndexLike;
import com.floragunn.searchguard.test.TestIndexTemplate;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.http.Header;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@NotThreadSafe
public class DataStreamAuthorizationReadWriteIntTests {
    static TestDataStream ds_ar1 = TestDataStream.name("ds_ar1").documentCount(22).rolloverAfter(10).build();
    static TestDataStream ds_ar2 = TestDataStream.name("ds_ar2").documentCount(22).rolloverAfter(10).build();
    static TestDataStream ds_aw1 = TestDataStream.name("ds_aw1").documentCount(22).rolloverAfter(10).build();
    static TestDataStream ds_aw2 = TestDataStream.name("ds_aw2").documentCount(22).rolloverAfter(10).build();
    static TestDataStream ds_br1 = TestDataStream.name("ds_br1").documentCount(22).rolloverAfter(10).build();
    static TestDataStream ds_br2 = TestDataStream.name("ds_br2").documentCount(22).rolloverAfter(10).build();
    static TestDataStream ds_bw1 = TestDataStream.name("ds_bw1").documentCount(22).rolloverAfter(10).build();
    static TestDataStream ds_bw2 = TestDataStream.name("ds_bw2").documentCount(22).rolloverAfter(10).build();
    static TestIndex index_cr1 = TestIndex.name("index_cr1").documentCount(10).build();
    static TestIndex index_cw1 = TestIndex.name("index_cw1").documentCount(10).build();
    static TestDataStream ds_hidden = TestDataStream.name("ds_hidden").documentCount(10).rolloverAfter(3).seed(8).attr("prefix", "h").build();
    static TestAlias alias_ab1r = new TestAlias("alias_ab1r", ds_ar1, ds_ar2, ds_aw1, ds_aw2, ds_br1, ds_bw1);
    static TestAlias alias_ab1w = new TestAlias("alias_ab1w", ds_aw1, ds_aw2, ds_bw1).writeIndex(ds_aw1);
    static TestAlias alias_ab1w_nowriteindex = new TestAlias("alias_ab1w_nowriteindex", ds_aw1, ds_aw2, ds_bw1);
    static TestAlias alias_c1 = new TestAlias("alias_c1", index_cr1);
    static TestIndex ds_bwx1 = TestIndex.name("ds_bwx1").documentCount(0).build();
    static TestIndex ds_bwx2 = TestIndex.name("ds_bwx2").documentCount(0).build();
    static TestAlias alias_bwx = new TestAlias("alias_bwx", new TestIndexLike[0]);
    static TestSgConfig.User LIMITED_USER_A = new TestSgConfig.User("limited_user_A").description("ds_a*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("ds_a*").dataStreamPermissions("SGS_WRITE").on("ds_aw*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_ar1, ds_ar2, ds_aw1, ds_aw2)).indexMatcher("write", IndexApiMatchers.limitedTo(ds_aw1, ds_aw2)).indexMatcher("create_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B = new TestSgConfig.User("limited_user_B").description("ds_b*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("ds_b*").dataStreamPermissions("SGS_WRITE").on("ds_bw*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_br1, ds_br2, ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("create_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B_READ_ONLY_A = new TestSgConfig.User("limited_user_B_read_only_A").description("ds_b*; read only on ds_a*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("ds_a*", "ds_b*").dataStreamPermissions("SGS_WRITE").on("ds_bw*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_ar1, ds_ar2, ds_aw1, ds_aw2, ds_br1, ds_br2, ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("create_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B_AUTO_PUT_ON_ALL = new TestSgConfig.User("limited_user_B_auto_put_on_all").description("ds_b* with full auto put").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("ds_b*").dataStreamPermissions("SGS_WRITE").on("ds_bw*").dataStreamPermissions("indices:admin/mapping/auto_put").on("*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_br1, ds_br2, ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("create_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B_CREATE_DS = new TestSgConfig.User("limited_user_B_create_ds").description("ds_b* with create ds privs").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("ds_b*").dataStreamPermissions("SGS_WRITE").on("ds_bw*").dataStreamPermissions("SGS_CREATE_DATA_STREAM").on("ds_bw*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_br1, ds_br2, ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("create_data_stream", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B_MANAGE_DS = new TestSgConfig.User("limited_user_B_manage_ds").description("ds_b* with manage privs").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("ds_b*").dataStreamPermissions("SGS_WRITE").on("ds_bw*").dataStreamPermissions("SGS_MANAGE").on("ds_bw*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_br1, ds_br2, ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("create_data_stream", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("manage_data_stream", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("manage_alias", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("get_alias", IndexApiMatchers.limitedTo(new TestIndexLike[0]));
    static TestSgConfig.User LIMITED_USER_B_MANAGE_INDEX_ALIAS = new TestSgConfig.User("limited_user_B_manage_index_alias").description("ds_b*, alias_bwx* with manage privs").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("ds_b*").dataStreamPermissions("SGS_WRITE").on("ds_bw*").dataStreamPermissions("SGS_MANAGE").on("ds_bw*").aliasPermissions("SGS_MANAGE_ALIASES").on("alias_bwx*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_br1, ds_br2, ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("create_data_stream", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("manage_data_stream", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2, alias_bwx)).indexMatcher("manage_alias", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2, alias_bwx)).indexMatcher("get_alias", IndexApiMatchers.limitedTo(alias_bwx));
    static TestSgConfig.User LIMITED_USER_B_CREATE_INDEX_MANAGE_ALIAS = new TestSgConfig.User("limited_user_B_create_index").description("ds_b* with create ds privs and manage alias privs, alias_bwx* with manage alias privs").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("ds_b*").dataStreamPermissions("SGS_WRITE").on("ds_bw*").dataStreamPermissions("SGS_CREATE_DATA_STREAM", "SGS_MANAGE_ALIASES").on("ds_bw*").aliasPermissions("SGS_MANAGE_ALIASES").on("alias_bwx*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_br1, ds_br2, ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("create_data_stream", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2, alias_bwx)).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_B_HIDDEN_MANAGE_INDEX_ALIAS = new TestSgConfig.User("limited_user_B_HIDDEN_anage_index_alias").description("ds_b*, ds_hidden*, alias_bwx* with manage privs").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("ds_b*", "ds_hidden*").dataStreamPermissions("SGS_WRITE").on("ds_bw*", "ds_hidden*").dataStreamPermissions("SGS_MANAGE").on("ds_bw*", "ds_hidden*").aliasPermissions("SGS_MANAGE_ALIASES").on("alias_bwx*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_br1, ds_br2, ds_bw1, ds_bw2, ds_bwx1, ds_bwx2, ds_hidden)).indexMatcher("write", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2, ds_hidden)).indexMatcher("create_data_stream", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2, ds_hidden)).indexMatcher("manage_data_stream", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2, alias_bwx, ds_hidden)).indexMatcher("manage_alias", IndexApiMatchers.limitedTo(ds_bw1, ds_bw2, ds_bwx1, ds_bwx2, alias_bwx, ds_hidden)).indexMatcher("get_alias", IndexApiMatchers.limitedTo(alias_bwx));
    static TestSgConfig.User LIMITED_USER_AB_MANAGE_INDEX = new TestSgConfig.User("limited_user_AB_manage_index").description("ds_a*, ds_b* with manage index privs").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on("ds_a*", "ds_b*").dataStreamPermissions("SGS_WRITE").on("ds_aw*", "ds_bw*").dataStreamPermissions("SGS_MANAGE").on("ds_aw*", "ds_bw*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_ar1, ds_ar2, ds_aw1, ds_aw2, ds_br1, ds_br2, ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("write", IndexApiMatchers.limitedTo(ds_aw1, ds_aw2, ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("create_data_stream", IndexApiMatchers.limitedTo(ds_aw1, ds_aw2, ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("manage_data_stream", IndexApiMatchers.limitedTo(ds_aw1, ds_aw2, ds_bw1, ds_bw2, ds_bwx1, ds_bwx2)).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_C = new TestSgConfig.User("limited_user_C").description("index_c*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh").on("index_c*").indexPermissions("SGS_WRITE").on("index_cw*")).indexMatcher("read", IndexApiMatchers.limitedTo(index_cr1, index_cw1)).indexMatcher("write", IndexApiMatchers.limitedTo(index_cw1)).indexMatcher("create_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_AB1_ALIAS = new TestSgConfig.User("limited_user_alias_AB1").description("alias_ab1").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").aliasPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/aliases/get").on("alias_ab1r").aliasPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/aliases/get", "SGS_WRITE", "indices:admin/refresh*").on("alias_ab1w*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_ar1, ds_ar2, ds_aw1, ds_aw2, ds_br1, ds_bw1, alias_ab1r, alias_ab1w_nowriteindex)).indexMatcher("write", IndexApiMatchers.limitedTo(ds_aw1, ds_aw2, ds_bw1, alias_ab1w_nowriteindex)).indexMatcher("create_data_stream", IndexApiMatchers.limitedTo(ds_aw1, ds_aw2, ds_bw1)).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedTo(ds_ar1, ds_ar2, ds_aw1, ds_aw2, ds_br1, ds_bw1, alias_ab1r));
    static TestSgConfig.User LIMITED_USER_AB1_ALIAS_READ_ONLY = new TestSgConfig.User("limited_user_alias_AB1_read_only").description("read/only on alias_ab1w, but with write privs in write index ds_aw1").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_WRITE", "indices:admin/refresh").on("ds_aw1").aliasPermissions("SGS_READ").on("alias_ab1w")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_aw1, ds_aw2, ds_bw1)).indexMatcher("write", IndexApiMatchers.limitedTo(ds_aw1)).indexMatcher("create_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_READ_ONLY_ALL = new TestSgConfig.User("limited_read_only_all").description("read/only on *").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ").on("*")).indexMatcher("read", IndexApiMatchers.unlimited()).indexMatcher("write", IndexApiMatchers.limitedToNone()).indexMatcher("create_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_READ_ONLY_A = new TestSgConfig.User("limited_read_only_A").description("read/only on ds_a*").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_READ").on("ds_a*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_ar1, ds_ar2, ds_aw1, ds_aw2)).indexMatcher("write", IndexApiMatchers.limitedToNone()).indexMatcher("create_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_NONE = new TestSgConfig.User("limited_user_none").description("no privileges for existing indices").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").dataStreamPermissions("SGS_CRUD", "SGS_INDICES_MONITOR").on("ds_does_not_exist_*")).indexMatcher("read", IndexApiMatchers.limitedToNone()).indexMatcher("write", IndexApiMatchers.limitedToNone()).indexMatcher("create_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User INVALID_USER_INDEX_PERMISSIONS_FOR_DATA_STREAM = new TestSgConfig.User("invalid_user_index_permissions_for_data_stream").description("invalid: index permissions for data stream").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_CRUD", "SGS_INDICES_MONITOR", "SGS_CREATE_DATA_STREAM").on("ds_*")).indexMatcher("read", IndexApiMatchers.limitedToNone()).indexMatcher("write", IndexApiMatchers.limitedToNone()).indexMatcher("create_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User LIMITED_USER_PERMISSIONS_ON_BACKING_INDICES = new TestSgConfig.User("limited_user_permissions_on_backing_indices").description("ds_a* on backing indices").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("SGS_READ", "SGS_INDICES_MONITOR", "indices:admin/refresh*").on(".ds-ds_a*").indexPermissions("SGS_WRITE").on(".ds-ds_aw*")).indexMatcher("read", IndexApiMatchers.limitedTo(ds_ar1, ds_ar2, ds_aw1, ds_aw2)).indexMatcher("write", IndexApiMatchers.limitedTo(ds_aw1, ds_aw2)).indexMatcher("create_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_data_stream", IndexApiMatchers.limitedToNone()).indexMatcher("manage_alias", IndexApiMatchers.limitedToNone()).indexMatcher("get_alias", IndexApiMatchers.limitedToNone());
    static TestSgConfig.User UNLIMITED_USER = new TestSgConfig.User("unlimited_user").description("unlimited").roles(new TestSgConfig.Role("r1").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS", "SGS_CLUSTER_MONITOR").indexPermissions("*").on("*").aliasPermissions("*").on("*").dataStreamPermissions("*").on("*")).indexMatcher("read", IndexApiMatchers.unlimited()).indexMatcher("write", IndexApiMatchers.unlimited()).indexMatcher("create_data_stream", IndexApiMatchers.unlimited()).indexMatcher("manage_data_stream", IndexApiMatchers.unlimited()).indexMatcher("manage_alias", IndexApiMatchers.unlimited()).indexMatcher("get_alias", IndexApiMatchers.unlimited());
    static TestSgConfig.User SUPER_UNLIMITED_USER = new TestSgConfig.User("super_unlimited_user").description("super unlimited (admin cert)").adminCertUser().indexMatcher("read", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("write", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("create_data_stream", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("manage_data_stream", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("manage_alias", IndexApiMatchers.unlimitedIncludingSearchGuardIndices()).indexMatcher("get_alias", IndexApiMatchers.unlimitedIncludingSearchGuardIndices());
    static List<TestSgConfig.User> USERS = ImmutableList.of((Object)LIMITED_USER_A, (Object)LIMITED_USER_B, (Object)LIMITED_USER_B_READ_ONLY_A, (Object[])new TestSgConfig.User[]{LIMITED_USER_B_AUTO_PUT_ON_ALL, LIMITED_USER_B_CREATE_DS, LIMITED_USER_B_MANAGE_DS, LIMITED_USER_B_MANAGE_INDEX_ALIAS, LIMITED_USER_B_HIDDEN_MANAGE_INDEX_ALIAS, LIMITED_USER_AB_MANAGE_INDEX, LIMITED_USER_C, LIMITED_USER_AB1_ALIAS, LIMITED_USER_AB1_ALIAS_READ_ONLY, LIMITED_READ_ONLY_ALL, LIMITED_READ_ONLY_A, LIMITED_USER_NONE, INVALID_USER_INDEX_PERMISSIONS_FOR_DATA_STREAM, LIMITED_USER_PERMISSIONS_ON_BACKING_INDICES, UNLIMITED_USER, SUPER_UNLIMITED_USER});
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().users(USERS).indexTemplates(new TestIndexTemplate("ds_test", "ds_*").dataStream().composedOf(TestComponentTemplate.DATA_STREAM_MINIMAL)).indexTemplates(new TestIndexTemplate("ds_hidden", "ds_hidden*").priority(10).dataStream("hidden", true).composedOf(TestComponentTemplate.DATA_STREAM_MINIMAL)).indices(index_cr1, index_cw1).aliases(alias_ab1w, alias_ab1r, alias_ab1w_nowriteindex, alias_c1).dataStreams(ds_ar1, ds_ar2, ds_aw1, ds_aw2, ds_br1, ds_br2, ds_bw1, ds_bw2, ds_hidden).authzDebug(true).useExternalProcessCluster().build();
    final TestSgConfig.User user;

    @Test
    public void createDocument() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/ds_bw1/_doc/", (Map<String, Object>)DocNode.of((String)"a", (Object)1, (String)"@timestamp", (Object)Instant.now().toString()), new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_bw1).at("_index").but(this.user.indexMatcher("write")).whenEmpty(403));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteByQuery_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            try (GenericRestClient adminRestClient = cluster.getAdminCertRestClient();){
                DocNode testDoc = DocNode.of((String)"test", (Object)"deleteByQuery_indexPattern", (String)"@timestamp", (Object)Instant.now().toString());
                GenericRestClient.HttpResponse httpResponse = adminRestClient.putJson("/ds_bw1/_create/put_delete_delete_by_query_b1?refresh=true", (Document<?>)testDoc.with("delete_by_query_test_delete", (Object)"yes"));
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isCreated());
                httpResponse = adminRestClient.putJson("/ds_bw1/_create/put_delete_delete_by_query_b2?refresh=true", (Document<?>)testDoc.with("delete_by_query_test_delete", (Object)"no"));
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isCreated());
                httpResponse = adminRestClient.putJson("/ds_aw1/_create/put_delete_delete_by_query_a1?refresh=true", (Document<?>)testDoc.with("delete_by_query_test_delete", (Object)"yes"));
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isCreated());
                httpResponse = adminRestClient.putJson("/ds_aw1/_create/put_delete_delete_by_query_a2?refresh=true", (Document<?>)testDoc.with("delete_by_query_test_delete", (Object)"no"));
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isCreated());
            }
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/ds_aw*,ds_bw*/_delete_by_query?refresh=true&wait_for_completion=true", (Map<String, Object>)DocNode.of((String)"query.term.delete_by_query_test_delete", (Object)"yes"), new Header[0]);
            if (IndexApiMatchers.containsExactly(ds_aw1, ds_aw2, ds_bw1, ds_bw2).at("_index").but(this.user.indexMatcher("write")).isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
                int expectedDeleteCount = IndexApiMatchers.containsExactly(ds_aw1, ds_bw1).at("_index").but(this.user.indexMatcher("write")).size();
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("deleted", IsEqual.equalTo((Object)expectedDeleteCount))}));
            }
        }
        finally {
            this.deleteTestDocs("deleteByQuery_indexPattern", "ds_aw*,ds_bw*");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void putDocument_bulk() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = restClient.putNdJson("/_bulk?refresh=true", new Document[]{DocNode.of((String)"create._index", (Object)"ds_aw1", (String)"create._id", (Object)"d1"), DocNode.of((String)"a", (Object)1, (String)"test", (Object)"putDocument_bulk", (String)"@timestamp", (Object)Instant.now().toString()), DocNode.of((String)"create._index", (Object)"ds_bw1", (String)"create._id", (Object)"d1"), DocNode.of((String)"b", (Object)1, (String)"test", (Object)"putDocument_bulk", (String)"@timestamp", (Object)Instant.now().toString())});
            if (this.user == LIMITED_USER_PERMISSIONS_ON_BACKING_INDICES) {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(new TestIndexLike[0]).at("items[*].create[?(@.result == 'created')]._index").but(this.user.indexMatcher("write")).whenEmpty(200));
            } else {
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)IndexApiMatchers.containsExactly(ds_aw1, ds_bw1).at("items[*].create[?(@.result == 'created')]._index").but(this.user.indexMatcher("write")).whenEmpty(200));
            }
        }
        finally {
            this.deleteTestDocs("putDocument_bulk", "ds_aw*,ds_bw*");
        }
    }

    @Test
    public void createDataStream() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            GenericRestClient.HttpResponse httpResponse = restClient.put("/_data_stream/ds_bwx1");
            if (IndexApiMatchers.containsExactly(ds_bwx1).but(this.user.indexMatcher("create_data_stream")).isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            }
        }
    }

    @Test
    public void putDataStream() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            GenericRestClient.HttpResponse httpResponse = restClient.putJson("/ds_bwx1/", (Document<?>)DocNode.EMPTY);
            if (this.user == UNLIMITED_USER || this.user == SUPER_UNLIMITED_USER || this.user == INVALID_USER_INDEX_PERMISSIONS_FOR_DATA_STREAM) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isBadRequest());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void deleteDataStream() throws Exception {
        try (GenericRestClient adminRestClient = cluster.getAdminCertRestClient().trackResources();
             GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);){
            GenericRestClient.HttpResponse httpResponse = adminRestClient.put("/_data_stream/ds_bwx1");
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            httpResponse = restClient.delete("/_data_stream/ds_bwx1", new Header[0]);
            if (this.user.indexMatcher("manage_data_stream").isEmpty()) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            }
        }
    }

    @Test
    public void aliases_createAlias() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            restClient.deleteWhenClosed("/*/_alias/alias_bwx");
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"add.index", (Object)"ds_bw1", (String)"add.alias", (Object)"alias_bwx")})), new Header[0]);
            if (IndexApiMatchers.containsExactly(ds_bw1, alias_bwx).isCoveredBy(this.user.indexMatcher("manage_alias"))) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void aliases_createAlias_indexPattern() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]).trackResources(cluster.getAdminCertRestClient());){
            restClient.deleteWhenClosed("/*/_alias/alias_bwx");
            GenericRestClient.HttpResponse httpResponse = restClient.postJson("/_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"add.indices", (Object)DocNode.array((Object[])new Object[]{"ds_bw*"}), (String)"add.alias", (Object)"alias_bwx")})), new Header[0]);
            if (IndexApiMatchers.containsExactly(ds_bw1, ds_bw2, alias_bwx).isCoveredBy(this.user.indexMatcher("manage_alias"))) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void aliases_removeIndex() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(this.user, new Header[0]);
             GenericRestClient adminRestClient = cluster.getAdminCertRestClient().trackResources();){
            adminRestClient.deleteWhenClosed("/*/_alias/alias_bwx");
            GenericRestClient.HttpResponse httpResponse = adminRestClient.put("/_data_stream/ds_bwx1");
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            httpResponse = adminRestClient.put("/_data_stream/ds_bwx2");
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            httpResponse = adminRestClient.postJson("/_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"add.indices", (Object)DocNode.array((Object[])new Object[]{"ds_bwx1", "ds_bwx2"}), (String)"add.alias", (Object)"alias_bwx")})), new Header[0]);
            MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isOk());
            httpResponse = restClient.postJson("/_aliases", (Map<String, Object>)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"remove_index.index", (Object)"ds_bwx1")})), new Header[0]);
            if (IndexApiMatchers.containsExactly(ds_bwx2).isCoveredBy(this.user.indexMatcher("manage_data_stream"))) {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isBadRequest());
            } else {
                MatcherAssert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
            }
        }
    }

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> params() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (TestSgConfig.User user : USERS) {
            result.add(new Object[]{user, user.getDescription()});
        }
        return result;
    }

    public DataStreamAuthorizationReadWriteIntTests(TestSgConfig.User user, String description) throws Exception {
        this.user = user;
    }

    private void deleteTestDocs(String testName, String indices) {
        try (GenericRestClient adminRestClient = cluster.getAdminCertRestClient();){
            adminRestClient.postJson("/" + indices + "/_delete_by_query?refresh=true&wait_for_completion=true", (Map<String, Object>)DocNode.of((String)"query.term", (Object)ImmutableMap.of((Object)"test.keyword", (Object)testName)), new Header[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while cleaning up test docs", e);
        }
    }
}

