/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import org.apache.http.Header;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class GenericTypeLevelConfigApiTest {
    private static final TestSgConfig.User ADMIN_USER = new TestSgConfig.User("admin").roles(new TestSgConfig.Role("allaccess").indexPermissions("*").on("*").clusterPermissions("*"));
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().sslEnabled().user(ADMIN_USER).build();

    @Test
    public void deleteTest() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse getResponseOld = client.get("/_searchguard/config", new Header[0]);
            Assert.assertEquals((String)getResponseOld.getBody(), (Object)"true", (Object)DocNode.wrap((Object)DocReader.json().read(getResponseOld.getBody())).getAsNode("authc").getAsString("exists"));
            GenericRestClient.HttpResponse deleteResponse = client.delete("/_searchguard/config/" + CType.AUTHC.getName(), new Header[0]);
            Assert.assertEquals((String)deleteResponse.getBody(), (long)200L, (long)deleteResponse.getStatusCode());
            GenericRestClient.HttpResponse getResponseNew = client.get("/_searchguard/config", new Header[0]);
            Assert.assertTrue((String)getResponseNew.getBody(), (boolean)DocNode.wrap((Object)DocReader.json().read(getResponseNew.getBody())).getAsNode("authc").getAsNode("content").isEmpty());
            Assert.assertEquals((String)getResponseNew.getBody(), (Object)"false", (Object)DocNode.wrap((Object)DocReader.json().read(getResponseNew.getBody())).getAsNode("authc").getAsString("exists"));
            deleteResponse = client.delete("/_searchguard/config/" + CType.AUTHC.getName(), new Header[0]);
            Assert.assertEquals((String)deleteResponse.getBody(), (long)404L, (long)deleteResponse.getStatusCode());
        }
    }
}

