/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.documents.patch.PatchableDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.AuthenticationFrontend;
import com.floragunn.searchguard.authc.base.StandardAuthenticationDomain;
import com.floragunn.searchguard.authc.session.ApiAuthenticationFrontend;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FrontendAuthcConfig
implements PatchableDocument<FrontendAuthcConfig>,
AutoCloseable {
    public static final FrontendAuthenticationDomain DEFAULT_BASIC_AUTHC = new FrontendAuthenticationDomain("basic", "Login", "If you have forgotten your username or password, please ask your system administrator");
    public static final FrontendAuthcConfig BASIC = new FrontendAuthcConfig(Collections.singletonList(DEFAULT_BASIC_AUTHC));
    private final Logger log = LogManager.getLogger(FrontendAuthcConfig.class);
    private ImmutableList<FrontendAuthenticationDomain> authDomains;
    private LoginPage loginPage;
    private boolean debug;
    private Map<String, Object> parsedJson;

    FrontendAuthcConfig() {
    }

    public FrontendAuthcConfig(List<FrontendAuthenticationDomain> authDomains) {
        this.authDomains = ImmutableList.of(authDomains);
        this.loginPage = LoginPage.DEFAULT;
    }

    public ImmutableList<FrontendAuthenticationDomain> getAuthDomains() {
        return this.authDomains;
    }

    public static ValidationResult<FrontendAuthcConfig> parse(Object parsedJson, ConfigurationRepository.Context context) {
        ValidatingDocNode vNode;
        ValidationErrors validationErrors = new ValidationErrors();
        try {
            vNode = new ValidatingDocNode(DocNode.wrap((Object)parsedJson).splitDottedAttributeNamesToTree(), validationErrors, (Parser.Context)context);
        }
        catch (UnexpectedDocumentStructureException e) {
            return new ValidationResult(e.getValidationErrors());
        }
        MetricsLevel metricsLevel = (MetricsLevel)vNode.get("metrics").withDefault((Enum)MetricsLevel.BASIC).asEnum(MetricsLevel.class);
        FrontendAuthcConfig result = new FrontendAuthcConfig();
        result.parsedJson = DocNode.wrap((Object)parsedJson);
        result.authDomains = ImmutableList.of((Collection)vNode.get("auth_domains").asList(documentNode -> FrontendAuthenticationDomain.parse(documentNode, context, metricsLevel)));
        FrontendAuthcConfig.checkForMultipleAuthDomainsWithAutoSelectEnabled(result.authDomains, validationErrors);
        result.loginPage = (LoginPage)vNode.get("login_page").withDefault((Object)LoginPage.DEFAULT).by(loginPage -> LoginPage.parse(loginPage, context));
        result.debug = vNode.get("debug").withDefault(false).asBoolean();
        vNode.checkForUnusedAttributes();
        return new ValidationResult((Object)result, validationErrors);
    }

    private static void checkForMultipleAuthDomainsWithAutoSelectEnabled(ImmutableList<FrontendAuthenticationDomain> authDomains, ValidationErrors validationErrors) {
        long domainsWithAutoSelectEnabled = authDomains.stream().filter(FrontendAuthenticationDomain::isAutoSelect).count();
        if (domainsWithAutoSelectEnabled > 1L) {
            validationErrors.add(new ValidationError("auth_domains", "Only one frontend authentication domain can have 'auto_select' enabled"));
        }
    }

    public LoginPage getLoginPage() {
        return this.loginPage;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Object toBasicObject() {
        if (this.parsedJson != null) {
            return this.parsedJson;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (this.loginPage != LoginPage.DEFAULT) {
            result.put("login_page", this.loginPage.toBasicObject());
        }
        result.put("authenticators", this.authDomains.stream().map(FrontendAuthenticationDomain::toBasicObject).collect(Collectors.toList()));
        return result;
    }

    public FrontendAuthcConfig parseI(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        return (FrontendAuthcConfig)FrontendAuthcConfig.parse(docNode, (ConfigurationRepository.Context)context).get();
    }

    @Override
    public void close() {
        for (FrontendAuthenticationDomain authenticator : this.authDomains) {
            try {
                if (!(authenticator.getAuthenticationDomain() instanceof AutoCloseable)) continue;
                ((AutoCloseable)((Object)authenticator.getAuthenticationDomain())).close();
            }
            catch (Exception e) {
                this.log.warn("Error while closing auth domain {}", authenticator.getAuthenticationDomain(), (Object)e);
            }
        }
    }

    public static class LoginPage
    implements Document<LoginPage> {
        public static final LoginPage DEFAULT = new LoginPage();
        private URI brandImage = URI.create("/plugins/searchguard/assets/searchguard_logo.svg");
        private boolean showBrandImage = true;
        private String title = "Please log in";
        private String buttonStyle = "";

        public static LoginPage parse(DocNode documentNode, ConfigurationRepository.Context context) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(documentNode, validationErrors);
            LoginPage result = new LoginPage();
            result.brandImage = context != null && !context.isLenientValidationRequested() ? vNode.get("brand_image").withDefault(LoginPage.DEFAULT.brandImage).asAbsoluteURI() : vNode.get("brand_image").withDefault(LoginPage.DEFAULT.brandImage).asURI();
            result.showBrandImage = vNode.get("show_brand_image").withDefault(true).asBoolean();
            result.title = vNode.get("title").asString();
            result.buttonStyle = vNode.get("button_style").asString();
            validationErrors.throwExceptionForPresentErrors();
            return result;
        }

        public URI getBrandImage() {
            return this.brandImage;
        }

        public void setBrandImage(URI brandImage) {
            this.brandImage = brandImage;
        }

        public boolean isShowBrandImage() {
            return this.showBrandImage;
        }

        public void setShowBrandImage(boolean showBrandImage) {
            this.showBrandImage = showBrandImage;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getButtonStyle() {
            return this.buttonStyle;
        }

        public void setButtonStyle(String buttonStyle) {
            this.buttonStyle = buttonStyle;
        }

        public Object toBasicObject() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("brand_image", this.brandImage != null ? this.brandImage.toASCIIString() : null);
            result.put("show_brand_image", this.showBrandImage);
            result.put("title", this.title);
            result.put("button_style", this.buttonStyle);
            return result;
        }
    }

    public static class FrontendAuthenticationDomain
    implements Document<FrontendAuthenticationDomain> {
        private String type;
        private String label;
        private boolean enabled = true;
        private AuthenticationDomain<ApiAuthenticationFrontend> authenticationDomain;
        private boolean unavailable = false;
        private String message;
        private Map<String, Object> parsedJson;
        private boolean captureUrlFragment;
        private boolean autoSelect = false;

        public FrontendAuthenticationDomain() {
        }

        public FrontendAuthenticationDomain(String type, String label) {
            this.type = type;
            this.label = label;
        }

        public FrontendAuthenticationDomain(String type, String label, String message) {
            this.type = type;
            this.label = label;
            this.message = message;
        }

        public FrontendAuthenticationDomain(String type, String label, AuthenticationDomain<ApiAuthenticationFrontend> authenticationDomain) {
            this.type = type;
            this.label = label;
            this.authenticationDomain = authenticationDomain;
        }

        public static FrontendAuthenticationDomain parse(DocNode documentNode, ConfigurationRepository.Context context, MetricsLevel metricsLevel) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(documentNode, validationErrors);
            FrontendAuthenticationDomain result = new FrontendAuthenticationDomain();
            try {
                result.parsedJson = documentNode.toMap();
                result.type = vNode.get("type").required().asString();
                result.label = vNode.get("label").withDefault(result.type).asString();
                result.enabled = vNode.get("enabled").withDefault(true).asBoolean();
                result.message = vNode.get("message").asString();
                result.captureUrlFragment = vNode.get("capture_url_fragment").withDefault(false).asBoolean();
                result.autoSelect = vNode.get("auto_select").withDefault(false).asBoolean();
                if ("basic".equals(result.type)) {
                    if (result.message == null) {
                        result.message = DEFAULT_BASIC_AUTHC.getMessage();
                    }
                } else if (context != null && result.enabled) {
                    result.authenticationDomain = StandardAuthenticationDomain.parse(vNode, validationErrors, ApiAuthenticationFrontend.class, context, metricsLevel);
                }
            }
            catch (Exception e) {
                if (e instanceof ConfigValidationException) {
                    throw e;
                }
                validationErrors.add(new ValidationError(null, String.format("Failed to parse config due to exception: %s - %s", e.getClass().getName(), e.getMessage())).cause((Throwable)e));
            }
            validationErrors.throwExceptionForPresentErrors();
            return result;
        }

        public String getType() {
            return this.type;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public AuthenticationDomain<ApiAuthenticationFrontend> getAuthenticationDomain() {
            return this.authenticationDomain;
        }

        public AuthenticationFrontend getAuthenticationFrontend() {
            return this.authenticationDomain != null ? this.authenticationDomain.getFrontend() : null;
        }

        public boolean isUnavailable() {
            return this.unavailable;
        }

        public String getMessage() {
            return this.message;
        }

        public String getId() {
            return this.authenticationDomain != null ? this.authenticationDomain.getId() : null;
        }

        public Object toBasicObject() {
            return this.parsedJson;
        }

        public boolean isCaptureUrlFragment() {
            return this.captureUrlFragment;
        }

        public boolean isAutoSelect() {
            return this.autoSelect;
        }

        public String toString() {
            return "Authenticator [type=" + this.type + ", authenticationDomain=" + String.valueOf(this.authenticationDomain) + "]";
        }
    }
}

